#!/bin/bash
#SBATCH -J nsh2_2
#SBATCH -o nsh2_2.o%j
#SBATCH -e nsh2_2.o%j
#SBATCH -N 1
#SBATCH -n 5
#SBATCH --mem=5000
#SBATCH -t 720:00:00
#SBATCH --partition=mpi-cpus  --gres=gpu:0

python3 embed.py \
  -dset wordnet/noun_closure.csv \
  -epochs 1000 \
  -negs 50 \
  -burnin 20 \
  -dampening 0.75 \
  -ndproc 4 \
  -eval_each 100 \
  -sparse \
  -burnin_multiplier 0.01 \
  -neg_multiplier 0.1 \
  -lr_type constant \
  -train_threads 1 \
  -dampening 1.0 \
  -batchsize 50 \
  -manifold LTiling_rsgd \
  -dim 2 \
  -com_n 1 \
  -lr 0.5 -no-maxnorm
