#!/bin/sh

cd hyperrogue
make mymake
./mymake -O3 -rv
cd ..

cd hyperbolic-embedder
make
cd ..

cd poincare-embeddings
python setup.py build_ext --inplace
cd ..

cd hypviewer
g++ gentree.cpp -o gentree -I include/ src/HypGraph.cpp src/HypNode.cpp src/HypPoint.cpp src/HypTransform.cpp src/HypNodeArray.cpp src/HypLink.cpp src/HypGroupArray.cpp
cd ..

cd HyperbolicTiling_Learning
python setup.py build_ext --inplace
cd ..

cd mercator
g++ -O3 -std=c++11 -I include/ src/embeddingS1_unix.cpp -o mercator
cd ..

cd d-mercator
sh build.sh
cd ..

cd kvk
g++ hyperlink.cpp auxiliary/network.cpp auxiliary/global.cpp auxiliary/mle.cpp -o hyperlink.exe -O3
cd ..

cd scripts
g++ -O3 graph-to-matlab.cpp -o ../bin/graph-to-matlab
g++ -O3 mercator-to-bfkl.cpp -o ../bin/mercator-to-bfkl
cd ..
