# execute do-all.sh on simulated graphs

# embed with default temperature
function embed {
size=$1
id=$2
temp=$3
DIR=graphs/simulated/$size-T$temp/$id/
mkdir -p $DIR
hyperbolic-embedder/embedder --generate $DIR/groundtruth -n $size -T 0.$temp -seed 42$id -embed $DIR/compare
bin/convert-graph $DIR/graph-orig-links.txt $DIR/graph.txt $DIR/graph.csv
}

for temp in 1 4 7 
do
for size in 500 1000 2000
do
for id in `seq -w 0 49`
do
echo iteration $temp $size $id
embed $size $id $temp
done
done
done
