# execute do-all.sh on simulated graphs

for temp in 1 4 7 
do
for size in 500 1000 2000
do
for id in `seq -w 0 49`
do
echo iteration $temp $size $id

DIR=graphs/simulated/$size-T$temp/$id/
CDIR=graphs/simulated/converted/$size-T$temp/$id/
mkdir -p $CDIR
DHRGSEED="hyperrogue/hyper -c - -fixx 42$size$temp$id -nogui -s -"
$DHRGSEED -geo 534h -dimconvert-graph $DIR/groundtruth-coordinates.txt $CDIR/graph-orig.txt $CDIR/graph-orig-coordinates.txt >> graphs/simulated/converted/log
bin/convert-graph $CDIR/graph-orig.txt $CDIR/graph.txt $CDIR/graph.csv
done
done
done
