// convert the Mercator format to BFKL format

#include <iostream>
#include <string>
#include <cstdio>
#include <cmath>

using namespace std;

int N = 7;
double radius = 1.3;

int main() {
  string s;
  while(getline(cin, s)) {
    if(s[0] == '#') {
      auto pos = s.find("nb. vertices");
      if(pos != string::npos) N = atoi(s.c_str() + 19);
      pos = s.find("radius_H2");
      if(pos != string::npos) {
        radius = atof(s.c_str() + pos + 13);
        printf("n R alpha T\n%d %f 0 0\n", N, radius);
        }
      }
    else if(s != "") {
      char vname[100];
      double theta, r, kappa;
      sscanf(s.c_str(), "%s%lf%lf%lf", vname, &kappa, &theta, &r);
      printf("%s %lf %lf\n", vname, r, theta * 180 / M_PI);
      }
    }
  }
