#!/bin/bash

# verify that evaluation steps are always not performed on the current embeddings

function verify {
  DIR=$1
  if [ -f $DIR/log.txt ]
  then
  stepa=`grep "$2" $DIR/log.txt | grep finished | tail -n 1 | sed "s- : .*--" | sed "s-universal--"`
  stepb=`grep "$3" $DIR/log.txt | grep -v finished | tail -n 1 | sed "s- : .*--" | sed "s-universal--"`
  echo info: DIR=$1 A=$stepa B=$stepb 1>&2
  if [ -n "$stepa" ]
  then 
    if [ -n "$stepb" ]
    then
      if [ "$stepa" = "$stepb" ]
      then echo warning: equal times for $1/$2/$3 1>&2
      else diff=$((`date "+%s" -d "$stepb"`-`date "+%s" -d "$stepa"`))
        echo difference is $diff 1>&2
        if [ $diff -le 0 ]
        then echo ERROR: bad sequence for $1/$2/$3 1>&2
        fi
      fi
    else
      echo ERROR: step B not performed for $1/$2/$3 1>&2
    fi
  fi  
  fi
  }

function stat {

  DIR=results/$1/

  if [ -n "$2" ]
  then DIR=results/repeated/$1$2/
  fi

  # verify $DIR "embed using Poincare 2D" "evaluate Poincare 2D"
  # verify $DIR "embed using Poincare 2D" "convert Poincare 2D"
  # verify $DIR "convert Poincare 2D" "evaluate poincare2 fulleval"

  # verify $DIR "embed using Poincare 3D" "evaluate Poincare 3D"
  # verify $DIR "embed using Poincare 3D" "convert Poincare 3D"
  # verify $DIR "convert Poincare 3D" "evaluate poincare3 fulleval"

  # verify $DIR "embed using Lorentz 2D" "evaluate Lorentz 2D"
  # verify $DIR "embed using Lorentz 2D" "convert Lorentz 2D"
  # verify $DIR "convert Lorentz 2D" "evaluate lorentz2 fulleval"

  # verify $DIR "embed using Lorentz 3D" "evaluate Lorentz 3D"
  # verify $DIR "embed using Lorentz 3D" "convert Lorentz 3D"
  # verify $DIR "convert Lorentz 3D" "evaluate lorentz3 fulleval"

  if [ ! -f $DIR/summary.txt ]
  then
  echo missing file, need to reprocess
  SEED=$2 sh scripts/process.sh - $1
  fi
 
  cat $DIR/summary.txt
  }

if [[ $1 == *h* ]]
then echo ::: real-world hierarchies 1>&2
  stat noun
  stat mammal
  stat verbf
  stat acm
  stat mesh
  stat tetrapoda
  stat csphd
fi

if [[ $1 == *r* ]]
then echo ::: real-world graphs 1>&2
  stat astroph
  stat condmat
  stat grqc
  stat hepph
  stat facebook
  stat yeast
  stat diseasome
  stat followers-2009
  stat connectome/CElegans
  stat connectome/Human1
  stat connectome/Drosophila1
  stat connectome/Mouse3
fi

if [[ $1 == *s* ]]
then echo ::: including the simulations 1>&2
  for t in 1 4 7
  do
  for size in 500 1000 2000
  do
  for id in `seq -w 0 49`
  do stat simulated/$size-T$t/$id
  done
  done
  done
fi

if [[ $1 == *u* ]]
then echo ::: including the converted simulations 1>&2
  for id in `seq -w 0 49`
  do
  for t in 1 4 7
  do
  for size in 500 1000 2000
  do stat simulated/converted/$size-T$t/$id
  done
  done
  done
fi

if [[ $1 == *t* ]]
then echo ::: including the 3D simulations 1>&2
  for it in 0 1 2 3 4 5 6 7 8 9 
  do for n in 1000 2000
  do for R in 5 6 7 8
  do for T in 1 4 7
  do GRAPH=simulated/3d/$n-$R-$T/$it/
  stat $GRAPH
  done
  done
  done
  done
fi

if [[ $1 == *n* ]]
then echo ::: nouns-repeated 1>&2
  stat noun
  stat noun 1
  stat noun 2
  stat noun 3
  stat noun 4
fi

if [[ $1 == *A* ]]
then echo ::: repeated experiments A 1>&2
  stat grqc
  for i in 1 2 3 4
  do stat grqc $i
  done
  stat yeast
  for i in 1 2 3 4
  do stat yeast $i
  done
fi

if [[ $1 == *c* ]]
then echo ::: other connectomes 1>&2
  for x in `ls graphs/connectome`
  do echo $x
  stat connectome/$x
  for i in 1 2 3 4
  do stat connectome/$x $i
  done
  done
fi

# 'silly' graph for tests
if [[ $1 == *y* ]]
then 
  stat silly
fi
