#include <string>
#include <vector>
#include <iostream>
#include <map>

using namespace std;

vector<string> graphs;

map<string, map<string, double>> values;

int main(int argc, char ** argv) {

  string graph = "none";
  string s;

  while(getline(cin, s)) {
    int p = -1;
    for(int i=0; i<int(s.size()); i++) if(s[i] == '=') p = i;
    if(p == -1) continue;
    string cat = s.substr(0, p);
    string vals = s.substr(p+1);
    if(cat == "GRAPH") { graph = vals; graphs.push_back(graph); continue; }
    if(vals == "") continue;
    double vald = atof(vals.c_str());
    values[graph][cat] = vald;
    }

  for(auto g: graphs) {
    char head[100];
    auto& v = values[g];
    printf("%-35s", g.c_str());

    string misses;

    auto act = [&] (const string& name, const string& yes, const string& miss) {
      if(v.count(name) && v[name] != 0) printf("%s", yes.c_str()); else { for(char c: yes) printf("."); misses += miss; }
      };
    auto space = [] () { printf(" "); };

    act("lorentz2_time", "L2", "L2:b ");
    act("lorentz2_map", "#", "L2:c ");
    act("lorentz2_au", "#", "L2:k ");
    space();
 
    act("lorentz3_time", "L3", "L3:H ");
    act("lorentz3_map", "#", "");
    act("lorentz3_au", "#", "L3:IW ");
    space();

    act("poincare2_time", "P2", "P2:q ");
    act("poincare2_map", "#", "P2:v ");
    act("poincare2_au", "#", "P2:RS ");
    space();

    act("poincare3_time", "P3", "P3:t ");
    act("poincare3_map", "#", "P3:y ");
    act("poincare3_au", "#", "P3:AB ");
    space();

    act("bfkl_time", "B2", "B2:a ");
    act("bfkl_au", "#", "B2:j ");
    space();

    act("lorentz2_ddhrg_map", "LD", "LD:e ");
    act("lorentz2_ddhrg_au", "#", "LD:p ");
    space();

    act("bfkl_ddhrg_map", "BD", "LD:f ");
    act("bfkl_ddhrg_au", "#", "LD:o ");
    space();

    act("penalty2_map", "BP", "BP:V ");
    act("penalty2_au", "#", "");
    space();

    act("poincare5_map", "P5", "P5:uz ");
    space();

    act("euclidean50_map", "E50", "E50:rw ");
    space();

    act("euclidean200_map", "E200", "E200:sx ");
    space();

    act("coalescent2_time", "C", "C:1 ");
    act("coalescent2_map", "C", "C:2 ");
    act("coalescent3_time", "C", "C:3 ");
    act("coalescent3_map", "C", "C:4 ");
    act("kvk_time", "K", "K:5 ");
    act("kvk_map", "K", "K:6 ");

    act("mercator_fast_time", "M2", "M2a:F ");
    act("mfast_map", "a", "M2a:J ");

    act("mercator_full_time", "M2", "M2u:G ");
    act("mfull_map", "u", "M2u:K ");

    act("mdim_time", "M3", "M3:T ");
    act("mdim_map", "#", "M3:U ");
    space();

    act("norec_treerep_hr_map", "TN", "TN:N ");
    act("wrec_treerep_hr_map", "TW", "TN:O ");
    space();

    act("ltiling_map", "L2", "L2:PQ ");
    space();

    act("rogueviz_au", "R2", "R2:L ");
    act("rogueviz_map", "#", "R2:M ");
    space();

    act("hypviewer_au", "H3", "H3:C ");
    act("hypviewer_map", "#", "H3:D ");
    space();
    // act("hypviewer_map", "# ", ". ", "H3:E ");
 
    act("anneal2_map", "A2", "A:X ");
    act("anneal3_map", "A3", "A:Y ");
    space();

    printf("%s\n", misses.c_str());
    fflush(stdout);
    }

  return 0;
  }
