#include <string>
#include <vector>
#include <iostream>
#include <map>

using namespace std;

vector<string> graphs;

map<string, map<string, double>> values;

void tableline(string title, const auto& f) {
  printf("%-30s ", title.c_str());
  for(auto g: graphs) printf(" &%7s", f(g).c_str());
  printf(" \\\\\n");
  }

string fmtf(string fmt, double val) {
  if(!val) return "";
  char buf[100];
  sprintf(buf, fmt.c_str(), val);
  return buf;
  }

string its(int val) {
  if(val == 0) return "";
  char buf[100];
  sprintf(buf, "%d", val);
  return buf;  
  }

string measures = "tmausrlc";

int mode = 0;

void gen(string s) {
  auto ex = [&] (char c) {
    bool incase = false;
    for(char d: s) if(c==d) return true; else if((c>>5) == (d>>5)) incase = true;
    if(!incase) return true;
    return false;
    };

  bool lc_ratio = true;
  auto ltf = [&] (string s, double v) { auto info = values[s]["entropy"]; return (lc_ratio && v) ? fmtf("%.3f", 1 - v / info) : fmtf("%.1f", v); };
  auto ctf = [&] (string s, double v) { auto info = values[s]["entropy"]; return (lc_ratio && v) ? fmtf("%.3f", info / (info + v)) : fmtf("%.1f", v); };

  if(ex('n') && ex('N')) {
    tableline("nodes", [&] (string s) { return its(values[s]["n"]); }); // log-bfkl-improve.txt
    tableline("edges", [&] (string s) { return its(values[s]["m"]); }); // nothing
    // tableline("information", [&] (string s) { return its(values[s]["entropy"]); });
    }

  if(ex('L')) {
    if(ex('t')) tableline("Lorentz 2D embed time [s]", [&] (string s) { return its(values[s]["lorentz2_time"]); }); // timer "embed using Lorentz"
    if(ex('t')) tableline("Lorentz 2D eval time [s]", [&] (string s) { return fmtf("%.2f", values[s]["lorentz2_eval_time"]); }); // log-lorentz2-evaluate.txt
    if(ex('r')) tableline("Lorentz 2D radius AU", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_au"]); }); // log-lorentz2-evaluate.txt
    if(ex('g')) tableline("Lorentz 2D radius grid", [&] (string s) { return its(values[s]["lorentz2_radius_pre_improve"]); }); // log-lorentz2-improve.txt

    if(ex('m')) {
      tableline("MR Lorentz2D", [&] (string s) { return fmtf("%.1f", values[s]["lorentz2_meanrank"]); }); // log-lorentz2-evaluate.txt
      tableline("dMR Lorentz2D", [&] (string s) { return fmtf("%.1f", values[s]["lorentz2_pre_meanrank"]); }); // log-lorentz2-improve.txt
      tableline("MR Lorentz2D + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["lorentz2_ddhrg_meanrank"]); }); // log-lorentz2-improve.txt
      tableline("dMR Lorentz2D + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["lorentz2_post_meanrank"]); }); // log-lorentz2-improve.txt
      }

    if(ex('a')) {
      tableline("mAP Lorentz2D", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_map"]); }); // log-lorentz2-evaluate.txt
      tableline("dmAP Lorentz2D", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_pre_map"]); }); // log-lorentz2-improve.txt
      tableline("dmAP Lorentz2D + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_post_map"]); }); // log-lorentz2-improve.txt
      tableline("mAP Lorentz2D + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_ddhrg_map"]); }); // log-lorentz2-improve.txt
      }

    if(ex('l')) {
      tableline("loglik Lorentz2D", [&] (string s) { return ltf(s, values[s]["lorentz2_loglik"]); }); // log-lorentz2-fulleval.txt
      }

    if(ex('c')) {
      tableline("control Lorentz2D", [&] (string s) { return ctf(s, values[s]["lorentz2_control"]); }); // log-lorentz2-fulleval.txt
      }

    if(ex('t')) tableline("Lorentz 3D embed time [s]", [&] (string s) { return its(values[s]["lorentz3_time"]); }); // timer "embed using Lorentz"
    // if(ex('t')) tableline("Lorentz 3D eval time [s]", [&] (string s) { return fmtf("%.2f", values[s]["lorentz3_eval_time"]); }); // missing
    if(ex('r')) tableline("Lorentz 3D radius AU", [&] (string s) { return fmtf("%.3f", values[s]["lorentz3_au"]); }); // log-lorentz2-evaluate.txt
    // if(ex('g')) tableline("Lorentz 3D radius grid", [&] (string s) { return its(values[s]["lorentz3_radius_pre_improve"]); }); // log-lorentz2-improve.txt

    if(ex('m')) {
      tableline("MR Lorentz3D", [&] (string s) { return fmtf("%.1f", values[s]["lorentz3_meanrank"]); }); // log-lorentz2-evaluate.txt
      // tableline("dMR Lorentz3D", [&] (string s) { return fmtf("%.1f", values[s]["lorentz3_pre_meanrank"]); }); // log-lorentz2-improve.txt
      // tableline("MR Lorentz3D + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["lorentz3_ddhrg_meanrank"]); }); // log-lorentz2-improve.txt
      // tableline("dMR Lorentz3D + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["lorentz3_post_meanrank"]); }); // log-lorentz2-improve.txt
      }

    if(ex('a')) {
      tableline("mAP Lorentz3D", [&] (string s) { return fmtf("%.3f", values[s]["lorentz3_map"]); }); // log-lorentz2-evaluate.txt
      // tableline("dmAP Lorentz3D", [&] (string s) { return fmtf("%.3f", values[s]["lorentz3_pre_map"]); }); // log-lorentz2-improve.txt
      // tableline("dmAP Lorentz3D + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["lorentz3_post_map"]); }); // log-lorentz2-improve.txt
      // tableline("mAP Lorentz3D + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["lorentz3_ddhrg_map"]); }); // log-lorentz2-improve.txt
      }

    if(ex('l')) {
      tableline("loglik Lorentz3D", [&] (string s) { return ltf(s, values[s]["lorentz3_loglik"]); }); // log-lorentz2-fulleval.txt
      }

    if(ex('c')) {
      tableline("control Lorentz3D", [&] (string s) { return ctf(s, values[s]["lorentz3_control"]); }); // log-lorentz2-fulleval.txt
      }
    }

  if(ex('B')) {
    if(ex('r')) tableline("BFKL radius AU", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_au"]); }); // bfkl-coordinates.txt
    if(ex('g')) tableline("BFKL radius grid", [&] (string s) { return its(values[s]["bfkl_radius_pre_improve"]); }); // log-bfkl-improve.txt
    if(ex('t')) {
      tableline("BFKL embed time [s]", [&] (string s) { return its(values[s]["bfkl_time"]); }); // timer "embed using BFKL"
      tableline("DHRG improve time [s]", [&] (string s) { return its(values[s]["improve_bfkl_time"]); }); // timer "improve BFKL"
      }

    if(ex('m')) {
      tableline("MR BFKL", [&] (string s) { return fmtf("%.1f", values[s]["bfkl_meanrank"]); });
      tableline("dMR BFKL", [&] (string s) { return fmtf("%.1f", values[s]["bfkl_pre_meanrank"]); });
      tableline("dMR BFKL + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["bfkl_post_meanrank"]); });
      tableline("MR BFKL + DHRG", [&] (string s) { return fmtf("%.1f", values[s]["bfkl_ddhrg_meanrank"]); });
      }

    if(ex('a')) {
      tableline("mAP BFKL", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_map"]); });
      tableline("dmAP BFKL", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_pre_map"]); });
      tableline("dmAP BFKL + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_post_map"]); });
      tableline("mAP BFKL + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_ddhrg_map"]); });
      }

    if(ex('u') && mode != 2) {
      tableline("success BFKL", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_greedy_success"]); });
      tableline("success BFKL + DHRG", [&] (string s) { return fmtf("%.3f", values[s]["dhrg_greedy_success"]); });
      tableline("success BFKL + DDHRG", [&] (string s) { return fmtf("%.3f", values[s]["bfkl_ddhrg_greedy_success"]); });
      tableline("success Lorentz2D", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_greedy_success"]); });
      tableline("success Lorentz2D + DD", [&] (string s) { return fmtf("%.3f", values[s]["lorentz2_ddhrg_greedy_success"]); });
      }

    if(ex('s') && mode != 2) {
      tableline("stretch BFKL", [&] (string s) { return fmtf("%.2f", values[s]["bfkl_greedy_stretch"]); });
      tableline("stretch BFKL + DHRG", [&] (string s) { return fmtf("%.2f", values[s]["dhrg_greedy_stretch"]); });
      tableline("stretch BFKL + DDHRG", [&] (string s) { return fmtf("%.2f", values[s]["bfkl_ddhrg_greedy_stretch"]); });
      tableline("stretch Lorentz2D", [&] (string s) { return fmtf("%.2f", values[s]["lorentz2_greedy_stretch"]); });
      tableline("stretch Lorentz2D + DD", [&] (string s) { return fmtf("%.2f", values[s]["lorentz2_ddhrg_greedy_stretch"]); });
      }

    if(ex('l')) {
      tableline("loglik BFKL", [&] (string s) { return ltf(s, values[s]["bfkl_loglik"]); });
      }

    if(ex('c')) {
      tableline("control BFKL", [&] (string s) { return ctf(s, values[s]["bfkl_control"]); });
      }
    }

  if(ex('Q')) {
    if(ex('r')) tableline("penalty radius AU", [&] (string s) { return fmtf("%.3f", values[s]["penalty2_au"]); }); // bfkl-coordinates.txt
    if(ex('m')) tableline("MR penalty", [&] (string s) { return fmtf("%.1f", values[s]["penalty2_meanrank"]); });
    if(ex('a')) tableline("mAP penalty", [&] (string s) { return fmtf("%.3f", values[s]["penalty2_map"]); });
    if(ex('u')) tableline("success penalty", [&] (string s) { return fmtf("%.3f", values[s]["penalty2_greedy_success"]); });
    if(ex('s')) tableline("stretch penalty", [&] (string s) { return fmtf("%.2f", values[s]["penalty2_greedy_stretch"]); });
    if(ex('l')) tableline("loglik penalty", [&] (string s) { return ltf(s, values[s]["penalty2_loglik"]); });
    if(ex('c')) tableline("control penalty", [&] (string s) { return ctf(s, values[s]["penalty2_control"]); });
    }

  if(ex('A')) {
    if(ex('r')) tableline("anneal2 radius AU", [&] (string s) { return fmtf("%.3f", values[s]["anneal2_au"]); });
    if(ex('m')) tableline("MR anneal2", [&] (string s) { return fmtf("%.1f", values[s]["anneal2_meanrank"]); });
    if(ex('a')) tableline("mAP anneal2", [&] (string s) { return fmtf("%.3f", values[s]["anneal2_map"]); });
    if(ex('u')) tableline("success anneal2", [&] (string s) { return fmtf("%.3f", values[s]["anneal2_greedy_success"]); });
    if(ex('s')) tableline("stretch anneal2", [&] (string s) { return fmtf("%.2f", values[s]["anneal2_greedy_stretch"]); });
    if(ex('l')) tableline("loglik anneal2", [&] (string s) { return ltf(s, values[s]["anneal2_loglik"]); });
    if(ex('c')) tableline("control anneal2", [&] (string s) { return ctf(s, values[s]["anneal2_control"]); });

    if(ex('r')) tableline("anneal3 radius AU", [&] (string s) { return fmtf("%.3f", values[s]["anneal3_au"]); });
    if(ex('m')) tableline("MR anneal3", [&] (string s) { return fmtf("%.1f", values[s]["anneal3_meanrank"]); });
    if(ex('a')) tableline("mAP anneal3", [&] (string s) { return fmtf("%.3f", values[s]["anneal3_map"]); });
    if(ex('u')) tableline("success anneal3", [&] (string s) { return fmtf("%.3f", values[s]["anneal3_greedy_success"]); });
    if(ex('s')) tableline("stretch anneal3", [&] (string s) { return fmtf("%.2f", values[s]["anneal3_greedy_stretch"]); });
    if(ex('l')) tableline("loglik anneal3", [&] (string s) { return ltf(s, values[s]["anneal3_loglik"]); });
    if(ex('c')) tableline("control anneal3", [&] (string s) { return ctf(s, values[s]["anneal3_control"]); });
    }

  if(ex('C')) {
    if(ex('t')) tableline("coalescent2 embed time [s]", [&] (string s) { return its(values[s]["coalescent2_time"]); });
    if(ex('r')) tableline("coalescent2 radius AU", [&] (string s) { return fmtf("%.3f", values[s]["coalescent2_au"]); });
    if(ex('m')) tableline("MR coalescent2", [&] (string s) { return fmtf("%.1f", values[s]["coalescent2_meanrank"]); });
    if(ex('a')) tableline("mAP coalescent2", [&] (string s) { return fmtf("%.3f", values[s]["coalescent2_map"]); });
    if(ex('u')) tableline("success coalescent2", [&] (string s) { return fmtf("%.3f", values[s]["coalescent2_greedy_success"]); });
    if(ex('s')) tableline("stretch coalescent2", [&] (string s) { return fmtf("%.2f", values[s]["coalescent2_greedy_stretch"]); });
    if(ex('l')) tableline("loglik coalescent2", [&] (string s) { return ltf(s, values[s]["coalescent2_loglik"]); });
    if(ex('c')) tableline("control coalescent2", [&] (string s) { return ctf(s, values[s]["coalescent2_control"]); });

    if(ex('t')) tableline("coalescent3 embed time [s]", [&] (string s) { return its(values[s]["coalescent3_time"]); });
    if(ex('r')) tableline("coalescent3 radius AU", [&] (string s) { return fmtf("%.3f", values[s]["coalescent3_au"]); });
    if(ex('m')) tableline("MR coalescent3", [&] (string s) { return fmtf("%.1f", values[s]["coalescent3_meanrank"]); });
    if(ex('a')) tableline("mAP coalescent3", [&] (string s) { return fmtf("%.3f", values[s]["coalescent3_map"]); });
    if(ex('u')) tableline("success coalescent3", [&] (string s) { return fmtf("%.3f", values[s]["coalescent3_greedy_success"]); });
    if(ex('s')) tableline("stretch coalescent3", [&] (string s) { return fmtf("%.2f", values[s]["coalescent3_greedy_stretch"]); });
    if(ex('l')) tableline("loglik coalescent3", [&] (string s) { return ltf(s, values[s]["coalescent3_loglik"]); });
    if(ex('c')) tableline("control coalescent3", [&] (string s) { return ctf(s, values[s]["coalescent3_control"]); });
    }

  if(ex('K')) {
    if(ex('t')) tableline("kvk embed time [s]", [&] (string s) { return its(values[s]["kvk_time"]); });
    if(ex('r')) tableline("kvk radius AU", [&] (string s) { return fmtf("%.3f", values[s]["kvk_au"]); });
    if(ex('m')) tableline("MR kvk", [&] (string s) { return fmtf("%.1f", values[s]["kvk_meanrank"]); });
    if(ex('a')) tableline("mAP kvk", [&] (string s) { return fmtf("%.3f", values[s]["kvk_map"]); });
    if(ex('u')) tableline("success kvk", [&] (string s) { return fmtf("%.3f", values[s]["kvk_greedy_success"]); });
    if(ex('s')) tableline("stretch kvk", [&] (string s) { return fmtf("%.2f", values[s]["kvk_greedy_stretch"]); });
    if(ex('l')) tableline("loglik kvk", [&] (string s) { return ltf(s, values[s]["kvk_loglik"]); });
    if(ex('c')) tableline("control kvk", [&] (string s) { return ctf(s, values[s]["kvk_control"]); });
    }

  if(ex('S')) {
    if(ex('m')) tableline("MR landscape 200D", [&] (string s) { return fmtf("%.1f", values[s]["landscape200_meanrank"]); });
    if(ex('m')) tableline("MR landscape 50D", [&] (string s) { return fmtf("%.1f", values[s]["landscape50_meanrank"]); });
    if(ex('a')) tableline("mAP landscape 200D", [&] (string s) { return fmtf("%.3f", values[s]["landscape200_map"]); });
    if(ex('a')) tableline("mAP landscape 50D", [&] (string s) { return fmtf("%.3f", values[s]["landscape50_map"]); });
    }

  if(ex('P')) {
    if(ex('t')) {
      tableline("Poincare 2D embed time [s]", [&] (string s) { return its(values[s]["poincare2_time"]); });
      tableline("Poincare 3D embed time [s]", [&] (string s) { return its(values[s]["poincare3_time"]); });
      }

    if(ex('m')) {
      tableline("MR Poincare 2D", [&] (string s) { return fmtf("%.1f", values[s]["poincare2_meanrank"]); });
      tableline("MR Poincare 3D", [&] (string s) { return fmtf("%.1f", values[s]["poincare3_meanrank"]); });
      tableline("MR Poincare 5D", [&] (string s) { return fmtf("%.1f", values[s]["poincare5_meanrank"]); });
      }

    if(ex('a')) {
      tableline("mAP Poincare 2D", [&] (string s) { return fmtf("%.3f", values[s]["poincare2_map"]); });
      tableline("mAP Poincare 3D", [&] (string s) { return fmtf("%.3f", values[s]["poincare3_map"]); });
      tableline("mAP Poincare 5D", [&] (string s) { return fmtf("%.3f", values[s]["poincare5_map"]); });
      }

    if(ex('u') && mode != 2) {
      tableline("success Poincare2D", [&] (string s) { return fmtf("%.3f", values[s]["poincare2_greedy_success"]); });
      tableline("success Poincare3D", [&] (string s) { return fmtf("%.3f", values[s]["poincare3_greedy_success"]); });
      }

    if(ex('s') && mode != 2) {
      tableline("stretch Poincare2D", [&] (string s) { return fmtf("%.3f", values[s]["poincare2_greedy_stretch"]); });
      tableline("stretch Poincare3D", [&] (string s) { return fmtf("%.2f", values[s]["poincare3_greedy_stretch"]); });
      }

    if(ex('r')) {
      tableline("Poincare2D radius AU", [&] (string s) { return fmtf("%.3f", values[s]["poincare2_au"]); });
      tableline("Poincare3D radius AU", [&] (string s) { return fmtf("%.3f", values[s]["poincare3_au"]); });
      }

    if(ex('l')) {
      tableline("loglik Poincare2D", [&] (string s) { return ltf(s, values[s]["poincare2_loglik"]); });
      tableline("loglik Poincare3D", [&] (string s) { return ltf(s, values[s]["poincare3_loglik"]); });
      }

    if(ex('c')) {
      tableline("control Poincare2D", [&] (string s) { return ctf(s, values[s]["poincare2_control"]); });
      tableline("control Poincare3D", [&] (string s) { return ctf(s, values[s]["poincare3_control"]); });
      }
    }

  if(ex('E')) {
    if(ex('m')) {
      tableline("MR Euclidean50D", [&] (string s) { return fmtf("%.1f", values[s]["euclidean50_meanrank"]); });
      tableline("MR Euclidean200D", [&] (string s) { return fmtf("%.1f", values[s]["euclidean200_meanrank"]); });
      }
    if(ex('a')) {
      tableline("mAP Euclidean50D", [&] (string s) { return fmtf("%.3f", values[s]["euclidean50_map"]); });
      tableline("mAP Euclidean200D", [&] (string s) { return fmtf("%.3f", values[s]["euclidean200_map"]); });
      }
    }

  if(ex('H') && mode != 1) {
    if(ex('r')) tableline("HypViewer radius AU", [&] (string s) { return fmtf("%.3f", values[s]["hypviewer_au"]); });
    if(ex('r')) tableline("RogueViz radius AU", [&] (string s) { return fmtf("%.3f", values[s]["rogueviz_au"]); });
    if(ex('m')) tableline("MR HypViewer", [&] (string s) { return fmtf("%.1f", values[s]["hypviewer_meanrank"]); });
    if(ex('m')) tableline("MR RogueViz", [&] (string s) { return fmtf("%.1f", values[s]["rogueviz_meanrank"]); });
    if(ex('a')) tableline("mAP HypViewer", [&] (string s) { return fmtf("%.3f", values[s]["hypviewer_map"]); });
    if(ex('a')) tableline("mAP RogueViz", [&] (string s) { return fmtf("%.3f", values[s]["rogueviz_map"]); });
    }

  if(ex('M')) {
    if(ex('t')) {
      tableline("Mercator fast embed time [s]", [&] (string s) { return its(values[s]["mercator_fast_time"]); });
      tableline("Mercator full embed time [s]", [&] (string s) { return its(values[s]["mercator_full_time"]); });
      tableline("d-Mercator embed time [s]", [&] (string s) { return its(values[s]["mdim_time"]); });
      }
    if(ex('r')) {
      tableline("Mercator fast radius AU", [&] (string s) { return fmtf("%.3f", values[s]["mfast_au"]); });
      tableline("Mercator full radius AU", [&] (string s) { return fmtf("%.3f", values[s]["mfull_au"]); });
      tableline("d-Mercator radius AU", [&] (string s) { return fmtf("%.3f", values[s]["mdim_au"]); });
      }
    if(ex('m')) {
      tableline("MR Mercator fast", [&] (string s) { return fmtf("%.1f", values[s]["mfast_meanrank"]); });
      tableline("MR Mercator full", [&] (string s) { return fmtf("%.1f", values[s]["mfull_meanrank"]); });
      tableline("MR d-Mercator", [&] (string s) { return fmtf("%.1f", values[s]["mdim_meanrank"]); });
      }
    if(ex('a')) {
      tableline("mAP Mercator fast", [&] (string s) { return fmtf("%.3f", values[s]["mfast_map"]); });
      tableline("mAP Mercator full", [&] (string s) { return fmtf("%.3f", values[s]["mfull_map"]); });
      tableline("mAP d-Mercator", [&] (string s) { return fmtf("%.3f", values[s]["mdim_map"]); });
      }
    if(ex('u') && mode != 2) {
      tableline("success Mercator fast", [&] (string s) { return fmtf("%.3f", values[s]["mfast_greedy_success"]); });
      tableline("success Mercator full", [&] (string s) { return fmtf("%.3f", values[s]["mfull_greedy_success"]); });
      tableline("success d-Mercator", [&] (string s) { return fmtf("%.3f", values[s]["mdim_greedy_success"]); });
      }
    if(ex('s') && mode != 2) {
      tableline("stretch Mercator fast", [&] (string s) { return fmtf("%.2f", values[s]["mfast_greedy_stretch"]); });
      tableline("stretch Mercator full", [&] (string s) { return fmtf("%.2f", values[s]["mfull_greedy_stretch"]); });
      tableline("stretch d-Mercator", [&] (string s) { return fmtf("%.2f", values[s]["mdim_greedy_stretch"]); });
      }
    if(ex('l')) {
      tableline("loglik Mercator fast", [&] (string s) { return ltf(s, values[s]["mfast_loglik"]); });
      tableline("loglik Mercator full", [&] (string s) { return ltf(s, values[s]["mfull_loglik"]); });
      tableline("loglik d-Mercator", [&] (string s) { return ltf(s, values[s]["mdim_loglik"]); });
      }
    if(ex('c')) {
      tableline("control Mercator fast", [&] (string s) { return ctf(s, values[s]["mfast_control"]); });
      tableline("control Mercator full", [&] (string s) { return ctf(s, values[s]["mfull_control"]); });
      tableline("control d-Mercator", [&] (string s) { return ctf(s, values[s]["mdim_control"]); });
      }
    }

  if(ex('T')) {
    if(ex('r')) {
      tableline("TreeRep diameter rec", [&] (string s) { return fmtf("%.3f", values[s]["wrec_treerep_tu"]); });
      tableline("TreeRep diameter norec", [&] (string s) { return fmtf("%.3f", values[s]["norec_treerep_tu"]); });
      }
    if(ex('m')) {
      tableline("MR TreeRep rec", [&] (string s) { return fmtf("%.1f", values[s]["wrec_treerep_hr_meanrank"]); });
      tableline("MR TreeRep norec", [&] (string s) { return fmtf("%.1f", values[s]["norec_treerep_hr_meanrank"]); });
      }
    if(ex('a')) {      
      tableline("mAP TreeRep rec orig", [&] (string s) { return fmtf("%.3f", values[s]["wrec_treerep_map"]); });
      tableline("mAP TreeRep norec orig", [&] (string s) { return fmtf("%.3f", values[s]["norec_treerep_map"]); });
      tableline("mAP TreeRep rec", [&] (string s) { return fmtf("%.3f", values[s]["wrec_treerep_hr_map"]); });
      tableline("mAP TreeRep norec", [&] (string s) { return fmtf("%.3f", values[s]["norec_treerep_hr_map"]); });
      }
    if(ex('u') && mode != 2) {
      tableline("success TreeRep rec", [&] (string s) { return fmtf("%.3f", values[s]["wrec_treerep_hr_greedy_success"]); });
      tableline("success TreeRep norec", [&] (string s) { return fmtf("%.3f", values[s]["norec_treerep_hr_greedy_success"]); });
      }
    if(ex('s') && mode != 2) {
      tableline("stretch TreeRep rec", [&] (string s) { return fmtf("%.3f", values[s]["wrec_treerep_hr_greedy_stretch"]); });
      tableline("stretch TreeRep norec", [&] (string s) { return fmtf("%.3f", values[s]["norec_treerep_hr_greedy_stretch"]); });
      }
    }

  if(ex('G')) {
    if(ex('t')) tableline("ltiling embed time [s]", [&] (string s) { return its(values[s]["ltiling_time"]); });
    if(ex('r')) tableline("ltiling radius", [&] (string s) { return fmtf("%.3f", values[s]["ltiling_diam"]/2); });
    if(ex('m')) tableline("MR ltiling", [&] (string s) { return fmtf("%.1f", values[s]["ltiling_meanrank"]); });
    if(ex('a')) tableline("mAP ltiling", [&] (string s) { return fmtf("%.3f", values[s]["ltiling_map"]); });
    if(mode != '2') {
      if(ex('u')) tableline("success ltiling", [&] (string s) { return fmtf("%.3f", values[s]["ltiling_greedy_success"]); });
      if(ex('s')) tableline("stretch ltiling", [&] (string s) { return fmtf("%.3f", values[s]["ltiling_greedy_stretch"]); });
      }
    }
  }

int main(int argc, char ** argv) {

  string graph = "none";
  string s;

  while(getline(cin, s)) {
    int p = -1;
    for(int i=0; i<int(s.size()); i++) if(s[i] == '=') p = i;
    if(p == -1) continue;
    string cat = s.substr(0, p);
    string vals = s.substr(p+1);
    if(cat == "GRAPH") { graph = vals; graphs.push_back(graph); continue; }
    double vald = atof(vals.c_str());
    values[graph][cat] = vald;
    }

  tableline("graph name", [&] (string s) { 
    if(s.substr(0, 11) == "connectome/") s = s.substr(11, 5) + s.back();
    if(s.substr(3, 11) == "connectome/") s = s.substr(0, 3) + s.substr(14, 2) + s.back();
    if(s.substr(0, 12) == "simulated/3d") {
      int n, r, t, id;
      sscanf(s.c_str(), "simulated/3d/%d-%d-%d/%d", &n, &r, &t, &id);
      char head[20];
      sprintf(head, "S%d%d%d-%d", n/1000, r, t, id);
      s = head;
      }
    if(s.substr(0, 12) == "simulated/co") {
      int n, r, t, id;
      sscanf(s.c_str(), "simulated/converted/%d-T%d/%d", &n, &t, &id);
      char head[20];
      sprintf(head, "U%d-%d-%d", n/500, t, id);
      s = head;
      }

    return s.substr(0, 6);
    });
  string argvs = argc > 1 ? argv[1] : "";

  string line = "";

  for(char ch: argvs) { if(ch == '1' || ch == '2') mode = ch - '0'; else if(ch == ',') gen(line), line = ""; else line += ch; }
  gen(line);

  return 0;
  }
