# Bayesian Active Learning for fully Bayesian Gaussian Processes
This work reproduces the experiments for our paper: Bayesian Active Learning for fully Bayesian Gaussian Processes.

To run all the experiments, run the bash file `run_all_experiments.sh`.


### The structure of the code
The code is structured as follows:
- ``AL_experiments.py``: This is the central script to run the active learning scheme. 
  It uses the config.yaml to set default arguments, which can be overwritten by giving inputs when called, e.g.
  ``python AL_experiments.py --model_type fbgp_mcmc``.
    
- The **folder structure** is
    - **models**: Here you can find the different models. The central models for this project are fbgp_mcmc and gp_prior.
    - **Simulators**: Here you can find the specific simulators.
    - **utils**: This folder contains all the utility code such as data handling, metrics, transformations, but also the implementations of the acquisition functions. To see the acquisition functions, take a look at `sampling_strategies.py`.

    