##!/usr/bin/env bash
# Benchmarking of AL setup

FOLDER="results/"
for SIMULATOR in homo1 gramacy1d higdon1d motorcycle gramacy2d branin2d ishigami3d hartmann6d
do
  for REPETITION in 1 2 3 4 5 6 7 8 9 10 
  do

    if [ 'homo1' = ${SIMULATOR} ]; then AL_STEPS=40; fi
    if [ 'motorcycle' = ${SIMULATOR} ]; then AL_STEPS=30; fi
    if [ 'gramacy1d' = ${SIMULATOR} ]; then AL_STEPS=90; fi
    if [ 'gramacy2d' = ${SIMULATOR} ]; then AL_STEPS=40; fi
    if [ 'higdon1d' = ${SIMULATOR} ]; then AL_STEPS=60; fi
    if [ 'branin2d' = ${SIMULATOR} ]; then AL_STEPS=40; fi
    if [ 'ishigami3d' = ${SIMULATOR} ]; then AL_STEPS=100; fi
    if [ 'hartmann6d' = ${SIMULATOR} ]; then AL_STEPS=100; fi

    # GP (MAP): ALM
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_variance_${REPETITION}.pkl" --selection_criteria variance --model_type gp_prior --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
    # FBGP: ALM    
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_mcmc_variance_${REPETITION}.pkl" --selection_criteria variance --model_type fbgp_mcmc --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
    # FBGP: B-ALM
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_mcmc_mean_variance_${REPETITION}.pkl" --selection_criteria mcmc_mean_variance --model_type fbgp_mcmc --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
    # FBGP: BALD
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_mcmc_bald_${REPETITION}.pkl" --selection_criteria mcmc_bald --model_type fbgp_mcmc --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
    # FBGP: B-QBC
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_mcmc_qbc_noise_${REPETITION}.pkl" --selection_criteria mcmc_qbc --model_type fbgp_mcmc --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
    # FBGP: QB-MGP
    python AL_toy_simulator.py --output_file "${FOLDER}/${SIMULATOR}_mcmc_gmm_noise_${REPETITION}.pkl" --selection_criteria mcmc_gmm --model_type fbgp_mcmc --simulator ${SIMULATOR} --seed ${REPETITION} --active_learning_steps ${AL_STEPS} --outputs 1 --min_change_in_var -1 --initial_samples 3 --k_samples 1 --repeat_sampling 1 --beta_sampling -1 --n_runs 1 --n_epochs 1000 --plot false
   
  done
done

