# Benchmarking of AL setup

FOLDER="results/dummy_exact"

for SIMULATOR in homo1 homo2 homo3 hetero1 hetero2 hetero3 hetero4 motorcycle
do
   for CRITERIA in mi emoc GSx GSy iGS iGSr cohns #variance random combi variance_min_change
   do
      for REPETITION in 1 2 3 4 5 6 7 8 9 10
      do
         MINCHANGE=-1
         BETA=-1  # For now, it should be -1 or 0.1 depending on the method
         if [ 'variance_min_change' = ${CRITERIA} ]; then
            MINCHANGE=0.1
         fi

         if [ 'combi' = ${CRITERIA} ]; then
            MINCHANGE=0.1
         fi

         CRITERIA_NAME=${CRITERIA}
         if [ 'variance_min_change' = ${CRITERIA} ]; then
            CRITERIA_NAME='variance'
         fi
         #echo exact_k4_${SIMULATOR}_${CRITERIA}_${REPETITION}_${CRITERIA_NAME}_${MINCHANGE}

         if [ 'homo1' = ${SIMULATOR} ]; then AL_STEPS=20; fi
         if [ 'homo2' = ${SIMULATOR} ]; then AL_STEPS=20; fi
         if [ 'homo3' = ${SIMULATOR} ]; then AL_STEPS=50; fi
         if [ 'hetero1' = ${SIMULATOR} ]; then AL_STEPS=30; fi
         if [ 'hetero2' = ${SIMULATOR} ]; then AL_STEPS=25; fi
         if [ 'hetero3' = ${SIMULATOR} ]; then AL_STEPS=50; fi
         if [ 'hetero4' = ${SIMULATOR} ]; then AL_STEPS=50; fi
         if [ 'motorcycle' = ${SIMULATOR} ]; then AL_STEPS=40; fi
	
         python AL_dummy_simulator.py --simulator ${SIMULATOR} --active_learning_steps ${AL_STEPS} --outputs 1 --output_file "${FOLDER}/exact_k4_${SIMULATOR}_${CRITERIA}_${REPETITION}.pkl" --selection_criteria ${CRITERIA_NAME} --min_change_in_var ${MINCHANGE} --initial_samples 2 --k_samples 4 --repeat_sampling 1 --beta_sampling ${BETA} --model_type exact --n_runs 1 --n_epochs 1000 --seed ${REPETITION}
         python AL_dummy_simulator.py --simulator ${SIMULATOR} --active_learning_steps ${AL_STEPS} --outputs 1 --output_file "${FOLDER}/exact_k1_${SIMULATOR}_${CRITERIA}_${REPETITION}.pkl" --selection_criteria ${CRITERIA_NAME} --min_change_in_var ${MINCHANGE} --initial_samples 2 --k_samples 1 --repeat_sampling 4 --beta_sampling -1 --model_type exact --n_runs 1 --n_epochs 1000 --seed ${REPETITION}

      done
   done
done

