# EucliFold: A 3D Spatial Reasoning Dataset

EucliFold is a comprehensive dataset for evaluating 3D spatial reasoning capabilities in vision-language models. The dataset focuses on cube folding, rotation, and spatial relationship understanding through visual question answering tasks.

## Overview

This dataset contains 100 unique cube configurations, each with multiple question types designed to test different aspects of 3D spatial reasoning:

- **Perception Tasks**: Color and orientation recognition on cube faces
- **Operation Tasks**: Mental rotation and spatial transformation reasoning
- **Folding Tasks**: 2D net to 3D cube folding prediction
- **Matching Tasks**: Comparison of different cube nets

```
EucliFold_submit/
├── cubes/                    # 100 cube samples (00000-00099)
│   └── 00000/               # Each contains:
│       ├── cube_positive/   # 3D cube images
│       ├── cube_negative/   # Negative samples
│       ├── net_positive/    # 2D net images
│       ├── net_negative/    # Negative nets
│       ├── *.json           # Question files
│       └── rep_3d.json     # 3D representations
├── utils/                   # Utility functions
├── questions.py             # Question templates
└── cube_gen.ipynb          # Data generation
```

## Data Generation

The dataset is generated using the `cube_gen.ipynb` notebook, which:

1. **Generates 100 unique cube patterns** with random color and orientation combinations
2. **Creates 24 rotated variants** for each cube using group theory
3. **Generates positive and negative samples** for each question type
4. **Produces 2D net representations** using 11 different net types
5. **Creates visual images** for both 3D cubes and 2D nets

