#--------------------- one image ---------------------
import numpy as np

########################
# context: system prompt
########################

system_prompt_one_image = dict()
system_prompt_one_image['direct'] = "The following is a True/False question based on an image. " \
    "Directly output only 'True' or 'False' as your answer. " \
    "Do not provide any reasoning, explanation, or additional text."
system_prompt_one_image['cot'] =  "The following is a True/False question based on an image. " \
    "Analyze the image and the question carefully, then determine if the statement is True or False. " \
    "Provide your reasoning step by step."

def question_template_one_image(statement):
    question = "Question: Based on the image and the description of the image, is the following statement True or False?\n"
    description = f"Description: The image shows a cube with three visible faces (top, front, right), each face has an arrow on it.\n"
    user_message = question + \
        description + \
        statement + \
        "Answer:"
    return user_message

Euclidean_statement = "Statement: Imagine that the cube is set at the center of a 3D space, " \
    f"and let the positive x, y, and z axes point out from the right, top, and front faces, respectively. "

AXIS = {
    'front': 'positive-z',
    'back': 'negative-z',
    'left': 'negative-x',
    'right': 'positive-x',
    'top': 'positive-y',
    'bottom': 'negative-y',
}

############################
# questions: perception_cube
############################
def question_perception_cube_color(face, color):
    statement = f"Statement: There is a {color} arrow on the {face} face of the cube.\n"
    return question_template_one_image(statement)

def question_perception_cube_orientation(face, orientation):
    statement = f"Statement: " \
        f"The arrow on the {face} face of the cube is pointing towards the {orientation} face of the cube.\n"
    return question_template_one_image(statement)

def question_perception_cube_Euclidean(face, orientation):
    statement = Euclidean_statement + \
        f"The arrow on the {face} face of the cube is pointing in the {AXIS[orientation]} direction.\n"
    return question_template_one_image(statement)

################
# operation_cube
################
def question_operation_cube_rotation(degree, rot_face, face, orientation):
    statement = f"Statement: " \
        f"If the cube rotates {degree} degrees counterclockwise around its {rot_face} face, " \
        f"the arrow on the initial {face} face of the cube will point to the {orientation}.\n"
    return question_template_one_image(statement)

def question_operation_cube_Euclidean(degree, rot_face, face, orientation):
    statement = Euclidean_statement + \
        f"If the cube rotates {degree} degrees counterclockwise around the {AXIS[rot_face]} axis, " \
        f"the arrow on the initial {face} face of the cube will point in the {AXIS[orientation]} direction.\n"
    return question_template_one_image(statement)

#--------------------- two images ---------------------
########################
# context: system prompt
########################

system_prompt_two_images = dict()
system_prompt_two_images['direct'] = "The following is a True/False question based on two images. " \
    "Directly output only 'True' or 'False' as your answer. " \
    "Do not provide any reasoning, explanation, or additional text."
system_prompt_two_images['cot'] =  "The following is a True/False question based on two images. " \
    "Analyze the images and the question carefully, then determine if the statement is True or False. " \
    "Provide your reasoning step by step."

###########
# questions
###########

question_apple_banana = "Question: Based on Image-1 and Image-2, is the following statement True or False?\n" \
    "Statement: There is an apple in Image-1, and a banana in Image-2.\n" \
    "Answer:"

question_fold = "Question: Based on Image-1 and Image-2, is the following statement True or False?\n" \
    "Statement: The cube in Image-2 can be formed by folding the net shown in Image-1.\n" \
    "Answer:"

question_match = "Question: Based on Image-1 and Image-2, is the following statement True or False?\n" \
    "Statement: The cube net in Image-1 and the cube net in Image-2 can be folded into identical cubes.\n" \
    "Answer:"

#--------------------- save ---------------------
import json
question_dict = dict()
question_dict['system_prompt_one_image'] = system_prompt_one_image
question_dict['system_prompt_two_images'] = system_prompt_two_images
question_dict['question_apple_banana'] = question_apple_banana
question_dict['question_folding'] = question_fold
question_dict['question_matching'] = question_match
with open('question_dict.json', 'w') as f:
    json.dump(question_dict, f, indent=4)