# Original Question

Compounds that have the same molecular formula but are different in their structural arrangement are known as isomers. Isomers have two types, constitutional isomers and stereoisomers. Constitutional isomers have the same molecular formula but differ in their structures. In stereoisomers, molecules are connected in the same way, but their arrangements in space are different.
Among the given compounds (benzoquinone & cyclohexane-1,3,5-trione) the compound that does not show tautomerism (A) and among methyl 2-hydroxypropanoate and dimethyl fumarate which one will show optical isomerism (B).

---

# DeepSeek response (via openrouter)

\boxed{\text{benzoquinone}}
\boxed{\text{methyl 2-hydroxypropanoate}}
\boxed{\text{methyl 2-hydroxypropanoate}}

---

# DeepSeek reasoning (via openrouter)

To solve for the question, we need to understand what tautomerism and optical isomerism mean.

### Tautomerism

#### Tautomerism refers to a dynamic equilibrium between two compounds usually by the migration of a hydrogen atom within the molecules. The most common tautomerism is keto-enol tautomerism where a carbonyl compound (keto form) interconverts with an enol form (a compound containing a double bond and a hydroxyl group on adjacent carbon atoms).

##### Benzoquinone (more specifically, para-benzoquinone or simply known as p-benzoquinone) has the molecular formula $C_6H_4O_2$, where the structure is a six-membered ring with four conjugated carbon atoms and two oxygen atoms in a para-position acting as ketones.

The structure can be depicted as:
$$
\ce{O= \underset{| \\ \underset{\displaystyle O}{\underset{||}{\underset{\phantom{.....} \\ \displaystyle \underset{\displaystyle ||}{\underset{\phantom{..} \\ \displaystyle O}}{}}} \\ \phantom{...}}}{} }
$$
which only has a single canonical structure due to resonance within the conjugated system but does not typically exhibit keto-enol tautomerism because there is no alpha hydrogen (i.e., a hydrogen attached to a carbon that is adjacent to a carbonyl carbon).

##### Cyclohexane-1,3,5-trione has the molecular formula $C_6H_6O_3$, which means that it has a six-membered ring where three ketone groups are attached to carbons 1, 3, and 5. Its structure is:
$$
\ce{\underset{6}{\overset{1}{C}}(=O) - \underset{5}{\overset{2}{\underset{|}{\underset{}{\underset{\phantom{...}}{\overset{}{\underset{}{\underset{}{\underset{\displaystyle O}}{}|}}}{\phantom{...}}}}}\underset{\displaystyle O}{\underset{||}{\underset{4}C}} - \underset{3}{\underset{\phantom{5}}{\underset{|}{C}}}(=O)}},
$$
which can be written as:
$$
\ce{CH2(=O) - CH2 - CH2(=O) - CH2 - CH2(=O)}
$$
The question suggests that one of the given compounds does not show tautomerism. To exhibit keto-enol tautomerism, a carbonyl-containing compound should ideally have at least one alpha hydrogen atom (i.e., a hydrogen attached to a carbon atom next to a carbonyl group).

However, in the case of cyclohexane-1,3,5-trione ("Phloroglucinol triketo form"), the molecule does have alpha hydrogen atoms (specifically, the carbon atoms linking carbons 1, 2, and 3 each have such hydrogens). Thus, cyclohexane-1,3,5-trione can exhibit keto-enol tautomerism because it can lose a hydrogen from the carbon atoms next to the carbonyl carbon groups (i.e., carbon atoms 2, 4, and 6).

However, for benzoquinone, the structure shows only two carbonyl groups which directly bond to the carbon atoms of the aromatic ring where all the carbon atoms are either part of a double bond or a carbonyl group. Thus, there are no alpha hydrogens available for keto-enol tautomerism.

Based on this, the compound that does not show tautomerism should be **benzoquinone**.

Thus, "A" should be identified as "benzoquinone."

### Optical Isomerism

#### Optical isomerism refers to the property of a compound where two isomers are non-superimposable mirror images of each other. Such isomers are called enantiomers. A compound shows optical isomerism if it has a chiral center, which is typically a carbon atom bonded to four different groups.

#### Methyl 2-hydroxypropanoate has the molecular formula $C_4H_8O_3$, which corresponds to the ester of 2-hydroxypropanoic acid (also known as lactic acid) where the carboxyl group is esterified with methanol. Its structure is represented as:
$$
\ce{CH3-CH(OH)-COOH}
$$
However, at the question description stage ("methyl 2-hydroxypropanoate"), what we intend here is:
$$
\ce{CH3 - CH (\underset{(OH)}{-}) - COOCH3}.
$$

If we look closely at the central carbon (the second carbon atom in the chain "$CH_3 - \underline{CH(OH)} - COOCH_3$"), which is connected to four different groups:
$$
\ce{-CH3, -H, -OH, -COOCH3}.
$$
This carbon has four different substituents ($\ce{CH3}$, $\ce{H}$, $\ce{OH}$, and $\ce{COOCH3}$), which makes it a chiral center. Hence, **compound methyl 2-hydroxypropanoate should show optical isomerism** due to the presence of a chiral carbon.

#### Dimethyl fumarate has the molecular formula $C_6H_8O_4$. Fumarate refers to the trans isomer of but-2-enedioic acid (fumaric acid). Thus, if we consider dimethyl fumarate, it means both carboxylic acid groups are esterified. The structure thus looks like:
$$
\ce{H3COOC-CH=CH-COOCH3}
$$
However, a key property is that the double bond means that dimethyl fumarate should be in a trans configuration where the two $\ce{COOCH3}$ groups are on opposite sides of the double bond. 

However, for a molecule to show optical isomerism, it should have a chiral center where a carbon is attached to four different groups. Since there is no chiral carbon in dimethyl fumarate (since both carbon atoms making up the double bond are bonded to two identical groups: one has $\ce{-COOCH3}$ and $\ce{-H}$, while the other one has the same $\ce{COOCH3}$ and $\ce{H}$), there does not appear to be any chiral centers here. Another possibility might be a "plane of symmetry" that makes the molecule "achiral" even if there are double bonds.

Based on the reasoning above, **only methyl 2-hydroxypropanoate should show optical isomerism**.

Thus, "B" should be identified as "methyl 2-hydroxypropanoate."

Hence, the answer for:
1. The compound that does not show tautomerism is **benzoquinone** (A).
2. The compound that shows optical isomerism is **methyl 2-hydroxypropanoate** (B).

Thus, the answers should be:
**A = Benzoquinone or simply 'benzene-1,4-dione'**
**B = Methyl 2-hydroxypropanoate or simply 'methyl 2-hydroxypropanoate'**

However, a more appropriate check for the structures referenced here may help us validate how "methyl 2-hydroxypropanoate" is represented here accurately:
The compound "methyl 2-hydroxypropanoate" should indeed be:
$$\ce{CH3-CH(OH)-COOCH3}$$
However, it should be noted that the methyl ester of 2-hydroxypropanoic (also known as "methyl lactate") is shown here explicitly as $\ce{CH3-CH(OH)-COOCH3}$ where the second carbon atom serves as a chiral center (excluding any special case such as rapid epimerization which might make the compound optically inactive).

However, it seems like the question is structured such that there is part "A" and part "B" where:

1. Among benzoquinone and cyclohexane-1,3,5-trione, the compound that does not show tautomerism is benzoquinone (A part).
2. Among methyl 2-hydroxypropanoate and dimethyl fumarate, the one showing optical isomerism is methyl 2-hydroxypropanoate (B part).

The question seems to require us to identify the compounds for part A and part B. Thus, "A" should be "benzoquinone" and "B" should be "methyl 2-hydroxypropanoate," thus answers can be identified as follows:
A and B respectively should be:
$$
\boxed{\text{benzoquinone}}, \boxed{\text{methyl 2-hydroxypropanoate}}.
$$

However, since there seems to be a bit of a need for a confirmation that the answer makes sense:
$$
\text{(A) for tautomerism check: } \text{Benzene-1,4-dione (benzoquinone) typically does not show keto-enol tautomerism due to no alpha-hydrogens.} \\\\
\text{(B) for optical isomerism check: } \text{Methyl 2-hydroxypropanoate indeed has a chiral carbon atom where the carbon is attached to CH3, H, OH, and COOCH3 groups.}
$$

If you need the structures verified explicitly:

1. Benzoquinone (which is mainly $p$-benzoquinone) structure does not show keto-enol tautomerism when compared to cyclohexane-1,3,5-trione which does show treutomeric behehaviour.
2. Methyl 2-hydroxypropanoate has a chiral center thus shows optical isomerism, unlike dimethyl fumarate whose symmetrical structure makes it not show optical isomerism.


---

