# Introduction

This repository is an official implementation of DDG to create synthetic datasets.


# Requirements
```
cd iclr25_code 
conda env create -f environment.yaml
conda activate layerdiffuse
# You may have to install Diffusers from source to run script.
pip install git+https://github.com/huggingface/diffusers
```

# Datasets
CUB: CUB-200-2011 https://www.vision.caltech.edu/datasets/cub_200_2011/
Car: StanfordCars https://github.com/jhpohovey/StanfordCars-Dataset
Aircraft: FGVC-Aircraft https://www.robots.ox.ac.uk/~vgg/data/fgvc-aircraft/
WaterBird: group_DRO https://github.com/kohpangwei/group_DRO 
为了方便输入，我们将数据集全部转换为了ImageFolder格式，可以直接使用torchvision.datasets.ImageFolder读取。
其中,WaterBird可使用[water_bird_extactor.py](water_bird_extactor.py)来进行论文中的数据集划分提取。
其格式如下
```
|-- dataset
    |-- train
        |-- class1
            |-- img1
            |-- img2
            |-- ...
        |-- class2
            |-- img1
            |-- img2
            |-- ...
        |-- ...
    |-- test
        |-- class1
            |-- img1
            |-- img2
            |-- ...
        |-- class2
            |-- img1
            |-- img2
            |-- ...
        |-- ...
```
 
# Preparing CDP & CIP Data
你可以使用[sam_bird_aircraft_car.sh](sam_bird_aircraft_car.sh)中的脚本来生成CDP和CIP数据集。
值得注意的是，请将[sam_cdp_cip.py](sam_cdp_cip.py)中main()的数据集路径修改为你的数据集路径。

# Transparency Textual Inversion
你可以使用[transparency_textual_inversion.py](transparency_textual_inversion.py)来进行Transparency Textual Inversion，其中[inver_cub_cdp_0.5_500.sh](inver_cub_cdp_0.5_500.sh)是一个示例脚本。

# DDG
作为本项目的核心，当你准备好CDP&CIP Data 与相应的Transparency Textual Inversion数据后，你可以使用img2img.py来进行基于DDG的数据集生成。
本项目所使用的Diffusion模型为[SG161222/RealVisXL_V4.0](https://huggingface.co/SG161222/RealVisXL_V4.0)，项目会自动下载模型。
作为示例，你可以使用[gen_cub_cluster1_strength0.5.sh](gen_cub_cluster1_strength0.5.sh)来进行生成。

# Training
[train.py](train.py)
[train_hub_vit.py](train_hub_vit.py)
[train_hub_waterbird.py](train_hub_waterbird.py)
为了方便训练，我们提供了train.py,train_hub_vit.py,train_hub_waterbird.py来进行训练。请注意，你需要修改脚本中的数据集路径来进行训练。

# Test
关于测试，我们基于[GuidedMixUp](https://github.com/3neutronstar/GuidedMixup) 与 [Diff-Mix](https://github.com/Zhicaiwww/Diff-Mix) 的测试脚本来进行对齐的测试。

# Acknowledgements
本项目基于[diffusers](https://github.com/huggingface/diffusers)与[LayerDiffuse](https://github.com/lllyasviel/LayerDiffuse?tab=readme-ov-file) 并在其基础上进行了构建。
相关训练与测试代码基于[GuidedMixUp](https://github.com/3neutronstar/GuidedMixup) 与 [Diff-Mix](https://github.com/Zhicaiwww/Diff-Mix) 进行了修改。

## Training & Test

For training, the following scripts are provided:

- [train.py](train.py)
- [train_hub_vit.py](train_hub_vit.py)
- [train_hub_waterbird.py](train_hub_waterbird.py)

Make sure to update the dataset paths in the scripts before starting the training.

Example for train.py:

```bash
    CUDA_VISIBLE_DEVICES=$gpu_id python train.py --dataset $dataset --split $gpu_id --nsplits 8 --strength $strength --nclusters $nclusters --num_generated_per_image $num_generated_per_image --max_strength $max_strength
```

### Example usage for `train.py`:

1. **Using default settings**:
    ```bash
    python train.py --mode train --dataset cub --model resnet18
    ```

2. **Using `ResNet50` model, GPU 0, with `randaugment`**:
    ```bash
    python train.py --mode train --dataset cub --model resnet50 --gpu 0 --randaug
    ```

3. **Training with `ViT` model, learning rate 0.001, and `diffusemix` mode**:
    ```bash
    python train.py --mode train --dataset car --model vit --lr 0.001 --train_mode diffusemix
    ```

4. **Resuming training from a checkpoint with a fixed random seed**:
    ```bash
    python train.py --mode train --dataset aircraft --model densenet121 --resume --seed 42
    ```

5. **Using `CutMix` and `MixUp` data augmentation with `hook_hidden` mixup type**:
    ```bash
    python train.py --mode train --dataset cub --model resnet18 --use_cutmix --use_mixup --mixup_type hook_hidden
    ```

6. **Custom image augmentation with enhanced strength and synthetic image generation**:
    ```bash
    python train.py --mode train --dataset car --model resnet50 --prob_aug 0.6 --prob_syn 0.3 --num_syn 5 --strength 0.5
    ```

7. **Evaluation mode (test only)**:
    ```bash
    python train.py --mode test --dataset aircraft --model densenet121 --gpu 0
    ```
