#!/bin/bash

# Define the path to the file containing the directory paths

strength=0.5
max_train_steps=500
n_clusters=1

file_path="train_dir_lists/sorted_cdp_cub.list"
# Check if the file exists
if [ ! -f "$file_path" ]; then
    echo "File not found: $file_path"
    exit 1
fi

# Define the output directory based on the basename
output_dir="./learned_embed_cdp/CUB_200_2011-${strength}-${n_clusters}clusters/"

# Ensure the output directory exists
mkdir -p "$output_dir"
echo "Now Inverse ${line} to ${output_dir}"

# Execute the command with the directory path from the current line
accelerate launch --config_file 8gpu.yaml transparency_textual_inversion.py \
    --initializer_token="bird" \
    --placeholder_token="<embed>" \
    --mixed_precision="fp16" \
    --resolution=512 \
    --num_vectors=1 \
    --train_batch_size=4 \
    --max_train_steps=$max_train_steps \
    --train_dir_list="$file_path" \
    --output_dir="$output_dir" \
    --save_steps=100 \
    --learning_rate=1e-4 \
    --lr_warmup_steps=0 \
    --strength $strength