import pandas as pd
import json

# Provided JSON data
name = ("llama-3.1-8B-instruct_LA2_128_32_1")
path = "./"+name
with open(path+"/result.json", "r", encoding="utf-8") as f:
    scores = json.load(f)
# Desired order based on the image labels (standardized to match JSON keys)
ordered_keys = [
    "narrativeqa", "qasper", "multifieldqa_en", "hotpotqa", "2wikimqa", "musique",
    "gov_report", "qmsum", "multi_news", "trec", "triviaqa", "samsum",
    "passage_count", "passage_retrieval_en", "lcc", "repobench-p"
]

# Construct row with values in the given order
row = [scores.get(k, "") for k in ordered_keys]
df = pd.DataFrame([row], columns=[k.title().replace("_", "").replace("-", "").replace("Qa", "QA").replace("Pcount", "PCount").replace("Qmsum", "QMSum").replace("Trec", "TREC") for k in ordered_keys])


output_path = path+"/"+name+".csv"
df.to_csv(output_path, index=False)
