import numpy as np
from gym import utils
from . import mujoco_env
import math


class PointEnv(mujoco_env.MujocoEnv, utils.EzPickle):
    def __init__(self):
        mujoco_env.MujocoEnv.__init__(self, 'point.xml', 2)
        utils.EzPickle.__init__(self)

    def step(self, action):
        done = False
        action = np.clip(action, -1.0, 1.0)
        self.do_simulation(action, self.frame_skip)
        next_obs = self._get_obs()
        # qpos = next_obs[:2]
        # goal = [25.0, 0.0]  # 目标位置坐标
        # reward = -np.linalg.norm(goal - qpos)
        extra_reward, done = self.get_extra_reward(next_obs, done)
        # reward = -np.linalg.norm(goal - qpos)
        # reward += extra_reward
        # reward = 0
        return next_obs, extra_reward, done, {}

    def get_extra_reward(self, state, done):
        # 这个extra_reward也是non_markovian_reward, 因为一旦判定是事件发生,则本episode结束
        extra_reward = 0
        qpos = state[:2]
        goal = [25.0, 0.0]  # 目标位置坐标
        # 横坐标在12.3-12.6之间 纵坐标在-1-1 认定是撞墙
        # 横坐标在25-30之间 纵坐标在-8-8 认定达到目的地

        # 下面的if是point到达目标点的reward
        if qpos[0] > 25 and qpos[0] < 30 and qpos[1] > -8 and qpos[1] < 8:
            extra_reward = 100
            done = True
            extra_reward = -np.linalg.norm(goal - qpos) + extra_reward

        # 下面的elif是在point-v1下使用,当前设置对撞墙的判定很苛刻,如果效果不好可以缩小判定范围至point撞到墙中间的空里算-100
        # elif qpos[0] > 12.3 and qpos[0] < 13 and qpos[1] > -1 and qpos[1] < 1:
        #     extra_reward = -100
        #     done = True
        #     extra_reward = -np.linalg.norm((goal - qpos)) + extra_reward

        # 下面两个elif是在point-v2下使用,当前设置对撞墙的判定很苛刻,如果效果不好可以缩小判定范围至point撞到墙中间的空里算-100
        # elif qpos[0] > 12.3 and qpos[0] < 13 and qpos[1] > 4 and qpos[1] < 8:
        #     extra_reward = -100
        #     done = True
        #     extra_reward = -np.linalg.norm(goal - qpos) + extra_reward
        # elif qpos[0] > 12.3 and qpos[0] < 13 and qpos[1] > -8 and qpos[1] < -4:
        #     extra_reward = -100
        #     done = True
        #     extra_reward = -np.linalg.norm(goal - qpos) + extra_reward

        # 下面三个elif是在point-v2下使用,当前设置对撞墙的判定很苛刻,如果效果不好可以缩小判定范围至point撞到墙中间的空里算-100

        elif qpos[0] > 7.3 and qpos[0] < 8 and qpos[1] > -1 and qpos[1] < 1:
            extra_reward = -100
            done = True
            extra_reward = -np.linalg.norm((goal - qpos)) + extra_reward

        elif qpos[0] > 12.3 and qpos[0] < 13 and qpos[1] > 4 and qpos[1] < 8:
            extra_reward = -100
            done = True
            extra_reward = -np.linalg.norm(goal - qpos) + extra_reward
        elif qpos[0] > 12.3 and qpos[0] < 13 and qpos[1] > -8 and qpos[1] < -4:
            extra_reward = -100
            done = True
            extra_reward = -np.linalg.norm(goal - qpos) + extra_reward


        return extra_reward, done

    def get_distance_reward(self, state):
        qpos = state[:2]
        goal = [25.0, 0.0]  # 目标位置坐标
        reward = -np.linalg.norm((goal - qpos))

        return reward

    def get_non_markovian_reward(self, state):
        extra_reward = 0
        qpos = state[:2]
        goal = [25.0, 0.0]  # 目标位置坐标
        # 横坐标在12.3-12.6之间 纵坐标在0.06-0.07 认定是撞墙
        # 横坐标在25-30之间 纵坐标在-8-8 认定达到目的地

        if qpos[0] > 25 and qpos[0] < 30 and qpos[1] > -8 and qpos[1] < 8:
            extra_reward = 100
        elif qpos[0] > 12.3 and qpos[0] < 12.6 and qpos[1] > 0.06 and qpos[1] < 0.07:
            extra_reward = -100

        reward = -np.linalg.norm((goal - qpos)) + extra_reward
        return reward

    def _get_obs(self):
        return np.concatenate([
            self.sim.data.qpos.flat,
            self.sim.data.qvel.flat,
        ])

    def reset_model(self):
        qpos = self.init_qpos + self.np_random.uniform(low=-.1, high=.1, size=self.model.nq)
        qvel = self.init_qvel + self.np_random.randn(self.model.nv) * .1
        self.set_state(qpos, qvel)
        return self._get_obs()

    def viewer_setup(self):
        self.viewer.cam.distance = self.model.stat.extent * 0.5
