## *DeepJuice and SlowFast Video Processing Wiki*

### *1. Overview*
This repository provides code to install and run DeepJuice, a toolset for deep learning video analysis, and implements SlowFast models for video processing.

### *2. Installation Instructions*

#### *Prerequisites:*
Before running the code, make sure you have the following dependencies installed:
- Python libraries: ftfy, regex, tqdm, timm, torchmetrics, torchinfo, torchlens, pytorchvideo

#### *Steps to Install:*

1. *Install Pre-Requisites:*
   bash
   !pip install ftfy regex tqdm
   !pip install timm torchmetrics torchinfo
   !pip install git+https://github.com/johnmarktaylor91/torchlens
   !pip install pytorchvideo
   

2. *Clone DeepJuiceDev Repo:*
   - Use the following command to clone the repository:
   bash
   %cd /content/
   !git clone https://github.com/ColinConwell/DeepJuiceDev.git
   %cd /content/DeepJuiceDev
   

3. *Install DeepJuice:*
   - Create a setup.py file and install it:
   python
   with open('/content/DeepJuiceDev/setup.py', 'w') as f:
       f.write('''
       from setuptools import find_packages, setup

       setup(
         name='deepjuice',
         packages=find_packages(),
         version='0.1.0',
         description='deepjuice from Colin',
         author='Colin Conwell'
       )
       ''')
   !pip install -e .
   

4. *Restart the Runtime:*
   - After installation, restart the runtime for changes to take effect.

---

### *3. Running the Code*

After installing the dependencies and setting up the repository, you can start running the notebook.

#### *Load and Setup Helper Functions:*
The helper functions will allow you to load video data, process it, and use the SlowFast model for transformation.

python
# Load helper functions
from pathlib import Path
import pandas as pd
import torch

# Sample helper function to get video loader
def get_video_loader(video_set, clip_duration, transforms, batch_size=64, **kwargs):
    if isinstance(video_set, pd.Series) or isinstance(video_set, list):
        return DataLoader(VideoData(video_set, clip_duration, transforms), batch_size, **kwargs)


#### *SlowFast Transformations:*
You can transform video frames into tensors using the PackPathway class, which samples frames at different temporal rates.

python
class PackPathway(torch.nn.Module):
    def __init__(self):
        super().__init__()

    def forward(self, frames: torch.Tensor):
        fast_pathway = frames
        alpha = 4
        slow_pathway = torch.index_select(
            frames,
            1,
            torch.linspace(0, frames.shape[1] - 1, frames.shape[1] // alpha).long(),
        )
        return [slow_pathway, fast_pathway]


---

### *4. Model Setup*

You can set up your model and run it on your data with the following configuration:

python
# Set up variables for the model and data paths
model_name = 'slowfast_r50'
data_dir = "/content/drive/MyDrive/Colab_Notebooks/data"
video_path = f'{data_dir}/asl/831/'
extension = 'mp4'
device = 'cuda'
cache = '/content/.cache'


Ensure you point to the correct directories and file paths for your specific use case.

---

### *5. Conclusion*
The setup and configuration provided here will allow you to clone and run DeepJuice along with SlowFast model processing for video analysis. If you encounter any issues, check the troubleshooting section or consult the repository maintainers.

Feel free to expand this wiki by adding further sections for advanced usage or troubleshooting as necessary!
