# VisionTTRL: Single-Sample Test-Time Reinforcement Learning for Vision-Language Models

## Supplementary Materials

This directory contains the experimental results and data for our paper "Single-Sample Test-Time Reinforcement Learning for Vision-Language Models".

## Directory Structure

```
├── final_tta_runs_200/           # VisionReasoner-7B TTRL results
│   ├── countbench/               # CountBench dataset results
│   ├── pixmoval/                 # PixMo-Count validation results
│   ├── pixmotest/                # PixMo-Count test results
│   ├── reasonsegtest/            # ReasonSeg test results
│   ├── reasonsegval/             # ReasonSeg validation results
│   ├── refcocog/                 # RefCOCOg dataset results
│   ├── refcocoplus/              # RefCOCO+ dataset results
│   └── refcoco/                  # RefCOCO dataset results
├── qwen_final_tta_runs_200/      # Qwen2.5-VL-7B TTRL results
│   ├── countbench/               # CountBench dataset results
│   ├── pixmoval/                 # PixMo-Count validation results
│   ├── pixmotest/                # PixMo-Count test results
│   ├── reasonsegtest/            # ReasonSeg test results
│   ├── reasonsegval/             # ReasonSeg validation results
│   ├── refcocog/                 # RefCOCOg dataset results
│   ├── refcocoplus/              # RefCOCO+ dataset results
│   └── refcoco/                  # RefCOCO dataset results
└── README.md                     # This file
```

## Results Structure

Each dataset directory contains:
- `tta_results.json`: Complete experimental results including:
  - Baseline model prediction
  - TTRL step-by-step results (0-4 epochs)
  - Timing data (`timing_ms` field)
  - Generated responses with `<think>` tags


## Usage

To reproduce the results:
1. Use the provided `tta_results.json` files for exact performance numbers
2. Refer to the paper for detailed experimental setup
3. Check the Appendix for metric definitions and evaluation protocols

## Contact

For questions about the experimental setup or results, please refer to the main paper or contact the authors.
