#!/bin/bash

# Ensure the script stops if any command fails
set -e

# Create conda environment if it doesn't exist
if ! conda env list | awk '{print $1}' | grep -qxF 'rap'; then
  echo "Creating conda environment rap with Python 3.10..."
  conda create -n rap python=3.10 -y
else
  echo "Conda environment rap already exists."
fi

# Activate the conda environment
# Replace with your actual conda path if 'conda' is not in your PATH
# or if you are using a different environment manager (e.g., virtualenv, venv)
CONDA_BASE=$(conda info --base)
source $CONDA_BASE/etc/profile.d/conda.sh
conda activate rap

# Install requirements
echo "Installing requirements from requirement.txt..."
pip install -r requirements.txt

# Install transformers
echo "Install transformers=v4.45.0"
if [ ! -d "transformers" ]; then
  git clone https://github.com/huggingface/transformers.git
  echo "Cloned transformers repository."
else
  echo "Transformers directory already exists, skipping clone step."
fi
pushd transformers
git checkout v4.45.0
git apply --ignore-space-change --ignore-whitespace ../patches/transformers-v4.45.0.patch
pip install -e .
popd # Go back to the original directory using popd instead of cd ..

# Modify the piqa.yaml file
echo "Modifying piqa.yaml file..."
SITE_PACKAGES=$(python -c "import site; print(site.getsitepackages()[0])")
PIQA_YAML="$SITE_PACKAGES/lm_eval/tasks/piqa/piqa.yaml"
sed -i '2s/dataset_path: piqa/dataset_path: baber\/piqa/' "$PIQA_YAML"
echo "piqa.yaml file modified successfully."


echo "Running agent_training.py..."
python agent_training.py

echo "Running agent_policy.py..."
python agent_policy.py

echo "Running agent_pruning.py..."
python agent_pruning.py

echo "Running agent_benchmark.py..."
python agent_benchmark.py

echo "All scripts executed successfully."
