# GDLNN

This artifact contains the code and data to reproduce the experiments in our paper: "GDLNN: Marriage of Programming Language and Neural Networks for Accurate and Easy-to-Explain Graph Classifications"
For example, this artifact include the source code of our technique GDLNN that was used in Table 1 (Accuracy comparison).

## Requirements

Detailed requirements are listed in `environment.yml`.


## Datasets
In the folder `datasets`, we provide the datasets and splits used in our experiments.
For instance, `datasets/Mutagenicity` contains the Mutagenicity dataset.
In each dataset folder, the trained GDL programs used in our evaluation are included in each dataset folder.


## How to use

To measure the accuracy of GDLNN on a dataset, run the following command:
```
python GDLNN_eval.py -d {dataset} -lr {learning_rate} -p {portion}
```
where `{dataset}` is one of the following datasets:
```
MUTAG, Mutagenicity, PTC_MR, PROTEINS, NCI1, BA2Motif, ENZYMES, BBBP, BACE
```

The learning rate (i.e., `-lr`) and portion ('-p') are hyperparameters of GDLNN. 
In our evaluation, we chose the ones that yield the best accuracy on the validation set.
The used hyperparameters are as follows:

| Dataset      | Learning Rate | Portion |
|--------------|---------------|---------|
| MUTAG        | 0.01          | 0.2     |
| BBBP         | 0.0005        | 0.4     |
| BACE         | 0.005         | 0.4     |
| Mutagenicity | 0.01          | 0.4     |
| ENZYMES      | 0.0005        | 1.0     |
| PROTEINS     | 0.0005        | 0.6     |
| PTC_MR       | 0.005         | 0.6     |
| NCI1         | 0.005         | 0.6     |
| BA2Motif     | 0.01          | 0.2     |

The hyperparameters are also presented in `run_all.sh`.


To run explainability analysis (e.g., GDLNN in Figure 8), run the following command:
```
python -u GDLNN_topk_explain_lime.py -d {dataset} -lr {learning_rate} -p {portion} -k {topk}
```
The above command first runs GDLNN on the dataset and then runs LIME for explaining the predictions of GDLNN.
The argument `-k` is the number of important nodes that will be figured out by LIME.
It prints the fidelity and sparsity score of the explanations.


## Mining GDL programs

As mining GDL programs is time-consuming, we provide the mined GDL programs in the artifact.
If you want to mine GDL programs by yourself, run the following command:
```
python learn_programs.py -d {dataset} -c {num_cores} -e {epsilon}
```
where `-c` determines the number of cores used for mining, and `-e` is the epsilon parameter of the mining algorithm.
For instance, `python learn_programs.py -d MUTAG -c 30 -e 0.01` mines GDL programs for the MUTAG dataset using 30 cores and epsilon=0.01*|train_graphs|.