# Python script to sort indices in BA2Motif files

# Function to sort and overwrite a file
def sort_and_overwrite(filename):
    with open(filename, 'r') as file:
        lines = file.readlines()
    
    # Convert lines to integers, sort them, and convert back to strings
    sorted_lines = sorted(map(int, lines))
    sorted_lines = list(map(str, sorted_lines))

    # Write the sorted lines back to the file
    with open(filename, 'w') as file:
        file.write("\n".join(sorted_lines) + "\n")

# Function to check for intersection and print set sizes
def check_intersection_and_print_sizes(files):
    sets = []
    for filename in files:
        with open(filename, 'r') as file:
            lines = file.readlines()
            sets.append(set(map(int, lines)))
            print(f"Size of {filename}: {len(lines)}")
    
    # Check for intersection
    intersection = sets[0].intersection(sets[1], sets[2])
    if intersection:
        print("Intersection found:", intersection)
    else:
        print("No intersection found.")

# List of files to sort
files = ['BA2Motif_train.txt', 'BA2Motif_val.txt', 'BA2Motif_test.txt']

# Sort each file
for file in files:
    sort_and_overwrite(file)

# Call the function after sorting
check_intersection_and_print_sizes(files)

print("Files sorted successfully.")
