# Graph Dataset Structure

Each folder in this dataset contains several text files that describe different aspects of the graph data. Below is a description of each file and its purpose:






### Required Files

- **A.txt**: This file describes the adjacency relationships between nodes. Each line represents an edge between two nodes, indicating which nodes are adjacent to each other. We assume the index of the first node is 1 in "A.txt" and use ', ' to separate two nodes.

- **graph_indicator.txt**: This file maps each node to the graph it belongs to. Each line corresponds to a node and indicates the graph ID to which the node is associated.

- **graph_labels.txt**: This file provides labels for each graph in the dataset. These labels can be used for classification tasks or to identify different types of graphs.


- **readme.txt**: This file offers a rough description of the dataset, including the meaning of each node feature value. It serves as a guide to understanding the dataset's structure and content.

- **train.txt**: This file contains the indices of the graphs that are used for training purposes. It helps in segregating the dataset into a training set.

- **val.txt**: This file lists the indices of the graphs that are used for validation. It is useful for tuning the model and preventing overfitting.

- **test.txt**: This file includes the indices of the graphs that are used for testing. It allows for the evaluation of the model's performance on unseen data.

### Optional Files (if available)

- **node_labels.txt**: This file contains the features or labels for each node. These features can describe properties or categories of the nodes. If there is no node feature, this file is not required.

- **node_attrubutes.txt**: This file contains the attributes for each node. These features can describe properties or categories of the nodes. If there is no node attributes, this file is not required.

- **edge_labels.txt**: This file contains the features or labels associated with each edge in the graph. These features can represent various characteristics or weights of the edges. If there is no edge feature, this file is not required.

- **edge_attrubutes.txt**: This file contains the attributes for each edge. These features can describe properties or categories of the edges. If there is no edge attributes, this file is not required.

This README provides an overview of how the graph dataset is organized, helping users understand the relationships and features of the data contained within each folder.
