import pickle
from data_loader import * 
from dsl.gdl import *
import argparse
import datetime
import os, sys
import datetime


# learn a GDL program from a target graph (target_graph)
def evaluate(data):
  gdl_pgm = GDL()  
  gdl_pgm.nodeVars = [{0: (4.0, 4.0)}, {0: (3.0, 3.0)}, {0: (-99, 2.0)}, {0: (-99, 2.0)}]
  gdl_pgm.edgeVars = [({}, 0, 3), ({}, 2, 3), ({}, 1, 2)]

  chosen_graphs = eval_GDL_program_on_graphs_GC(gdl_pgm, data)
  print(len(chosen_graphs))
  print(len(data.label_to_graphs[1]))
  print(len(chosen_graphs & data.label_to_graphs[1]))

  #subgraph = [[24770, 24771, 24773, 24774], [50480, 50481, 50482, 50483, 50485, 50488, 50490, 50491]]
  #            #[24770, 24771, 24773, 24774, 24772]  
  #print(eval_GDL_program_DFS(gdl_pgm, subgraph, data))
  #for _, val in enumerate(subgraph[1]):
  #  print(val)
  #  print(data.A[val])
  #  print()


if __name__ == '__main__':
  parser = argparse.ArgumentParser()
  parser.add_argument("-d", "--dataset", default="MUTAG", help="Input dataset")  
  args = parser.parse_args()
  dataset = args.dataset

  if dataset == 'BBBP':
    data = load_BBBP()
  elif dataset == 'BACE':
    data = load_BACE()
  else:
    data = load_Data(dataset)


  evaluate(data)

 
