"""Appendix utilities package.

This package provides numerical, monitoring, and analysis helpers aligned with
the theory components: HVP/Lanczos, curvature estimators, mollifiers, safety
margin utilities, monitoring and plotting tools, and various convenience APIs.
"""

from . import hvp as hvp_mod
from . import lanczos as lanczos_mod
from . import mollifier as mollifier_mod
from . import subriemannian as subriemannian_mod
from . import curvature_estimators as curvature_mod
from . import estimation as estimation_mod
from . import monitoring as monitoring_mod
from . import plots as plots_mod
from . import dynamic_controller as dynamic_mod
from . import predictor as predictor_mod
from . import safety_margin as safety_mod
from . import validation as validation_mod
from . import hutchinson as hutchinson_mod
from . import finite_diff as finite_diff_mod
from . import ablation as ablation_mod
from . import datasets as datasets_mod
from . import eval_tools as eval_tools_mod
from . import spectral as spectral_mod
from . import logging_helpers as logging_helpers_mod


__all__ = [
    "hvp_mod",
    "lanczos_mod",
    "mollifier_mod",
    "subriemannian_mod",
    "curvature_mod",
    "estimation_mod",
    "monitoring_mod",
    "plots_mod",
    "dynamic_mod",
    "predictor_mod",
    "safety_mod",
    "validation_mod",
    "hutchinson_mod",
    "finite_diff_mod",
    "ablation_mod",
    "datasets_mod",
    "eval_tools_mod",
    "spectral_mod",
    "logging_helpers_mod",
]


def list_modules():
    return __all__.copy()


def _demo():
    print("appendix modules:", list_modules())


if __name__ == "__main__":
    _demo()
                                                      
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
