from __future__ import annotations

from typing import Any, Dict


def flatten_dict(d: Dict[str, Any], prefix: str = "") -> Dict[str, float]:
    out: Dict[str, float] = {}
    for k, v in d.items():
        key = f"{prefix}{k}" if prefix else k
        if isinstance(v, dict):
            out.update(flatten_dict(v, prefix=key + "/"))
        else:
            try:
                out[key] = float(v)
            except Exception:
                continue
    return out


def merge_dicts(*ds: Dict[str, float]) -> Dict[str, float]:
    out: Dict[str, float] = {}
    for d in ds:
        out.update(d)
    return out


def select_keys(d: Dict[str, float], prefix: str) -> Dict[str, float]:
    return {k: v for k, v in d.items() if k.startswith(prefix)}


def _demo():
    d = {"a": 1, "b": {"c": 2}}
    print(flatten_dict(d))


if __name__ == "__main__":
    _demo()
                
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
