from __future__ import annotations

from typing import Dict


def bound_distance_sq(delta_q_min: float, gamma: float, speed: float, L_grad: float, pred_err: float, lag_coeff: float, vmax: float, tau: float, approx_err: float = 0.0) -> float:
    denom = gamma * speed + L_grad * pred_err + lag_coeff * vmax * tau
    if denom <= 1e-12:
        return float("inf")
    num = 2.0 * (delta_q_min - approx_err)
    return max(0.0, num / denom)


def conservative_bound(delta_q_min: float, gamma: float, speed: float, L_grad: float, pred_err: float, lag_coeff: float, vmax: float, tau: float, slack: float = 0.0) -> float:
    return bound_distance_sq(delta_q_min - abs(slack), gamma, speed, L_grad, pred_err, lag_coeff, vmax, tau, approx_err=0.0)


def summarize_bound(delta_q_min: float, gamma: float, speed: float, L_grad: float, pred_err: float, lag_coeff: float, vmax: float, tau: float) -> Dict[str, float]:
    b = bound_distance_sq(delta_q_min, gamma, speed, L_grad, pred_err, lag_coeff, vmax, tau)
    bc = conservative_bound(delta_q_min, gamma, speed, L_grad, pred_err, lag_coeff, vmax, tau, slack=0.1 * abs(delta_q_min))
    return {"bound/nominal": b, "bound/conservative": bc}


def _demo():
    print(summarize_bound(1.0, 0.99, 0.5, 1.0, 0.1, 1.0, 1.0, 0.05))


if __name__ == "__main__":
    _demo()
                
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
