from __future__ import annotations

import numpy as np

from .optimal_trap import OptimalTrapEnv


class DynamicOptimalTrapEnv(OptimalTrapEnv):
    """
    Dynamic variant where the trap center moves slowly in a sinusoidal pattern.
    This tests the dynamic-aware A-GDC scheduling (not implemented here; only environment).
    """

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self._t = 0.0

    def step(self, action):
                          
        self._t += self.dt
                                             
        r = 0.5
        self.trap_center = np.array([r * np.cos(0.25 * self._t), r * np.sin(0.25 * self._t)], dtype=np.float32)
        return super().step(action)
