from __future__ import annotations

import numpy as np


class OUNoise:
    def __init__(self, size: int, mu: float = 0.0, theta: float = 0.15, sigma: float = 0.2):
        self.size = size
        self.mu = mu
        self.theta = theta
        self.sigma = sigma
        self.state = np.zeros(size, dtype=np.float32)

    def reset(self):
        self.state = np.zeros(self.size, dtype=np.float32)

    def sample(self) -> np.ndarray:
        dx = self.theta * (self.mu - self.state) + self.sigma * np.random.randn(self.size)
        self.state = self.state + dx
        return self.state.astype(np.float32)

