from __future__ import annotations


class AGDCScheduler:
    def __init__(self, kappa0: float = 0.0, eta: float = 0.05, beta: float = 0.05, target_cost: float = 0.01):
        self.kappa0 = kappa0
        self.eta = eta
        self.beta = beta
        self.target_cost = target_cost
        self.cost_ema = 0.0

    def update(self, batch_cost_mean: float) -> float:
        self.cost_ema = (1 - self.beta) * self.cost_ema + self.beta * batch_cost_mean
        self.kappa0 = max(0.0, self.kappa0 + self.eta * (self.cost_ema - self.target_cost))
        return self.kappa0

