from __future__ import annotations

import argparse
import os
import subprocess


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--agents", type=str, nargs="+", default=["sac", "pcpo", "focops", "a_gdc_sac"])
    parser.add_argument("--seeds", type=int, nargs="+", default=[0, 1, 2])
    parser.add_argument("--logdir", type=str, default="runs/gdc")
    args = parser.parse_args()

    config_map = {
        "sac": "gdc_project/configs/algos/sac.yaml",
        "pcpo": "gdc_project/configs/algos/pcpo.yaml",
        "focops": "gdc_project/configs/algos/focops.yaml",
        "a_gdc_sac": "gdc_project/configs/algos/a_gdc_sac.yaml",
    }

    for agent in args.agents:
        cfg = config_map[agent]
        for seed in args.seeds:
            cmd = [
                "python",
                "-m",
                "gdc_project.scripts.train",
                "--config",
                cfg,
                "--logdir",
                os.path.join(args.logdir, f"{agent}_seed{seed}"),
            ]
            env = os.environ.copy()
            env["PYTHONHASHSEED"] = str(seed)
            print("RUN:", " ".join(cmd))
            subprocess.run(cmd, env=env, check=False)


if __name__ == "__main__":
    main()

