from __future__ import annotations

import argparse
import itertools
import os
import subprocess


def grid(items):
    keys = sorted(items.keys())
    for values in itertools.product(*[items[k] for k in keys]):
        yield dict(zip(keys, values))


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", type=str, required=True)
    parser.add_argument("--logdir", type=str, default="runs/sweeps")
    parser.add_argument("--seeds", type=int, nargs="+", default=[0, 1, 2])
    parser.add_argument("--overrides", type=str, nargs="*", default=[], help="key=value pairs")
    args = parser.parse_args()

                                                                            
    space = {}
    for ov in args.overrides:
        k, v = ov.split("=", 1)
        vals = v.split(",")
        space[k] = vals

    for cfg in grid(space) if space else [{}]:
        for seed in args.seeds:
            name = "_".join([f"{k}{v}" for k, v in cfg.items()]) or "base"
            run_dir = os.path.join(args.logdir, f"{name}_seed{seed}")
            cmd = [
                "python", "-m", "gdc_project.scripts.train",
                "--config", args.config,
                "--logdir", run_dir,
                "--seed", str(seed),
            ]
            if cfg:
                                     
                env = os.environ.copy()
                for k, v in cfg.items():
                    env[k.upper()] = str(v)
            else:
                env = None
            print("RUN:", " ".join(cmd))
            subprocess.run(cmd, env=env, check=False)


if __name__ == "__main__":
    main()

