from __future__ import annotations

import copy
import os
from typing import Any, Dict

import yaml


def load_yaml(path: str) -> Dict[str, Any]:
    with open(path, "r") as f:
        return yaml.safe_load(f) or {}


def resolve_config(path: str) -> Dict[str, Any]:
    cfg = load_yaml(path)
    if "inherit" in cfg and cfg["inherit"]:
        base = resolve_config(cfg["inherit"]) if os.path.isabs(cfg["inherit"]) else load_yaml(cfg["inherit"])                     
        merged = copy.deepcopy(base)
        merged.update({k: v for k, v in cfg.items() if k != "inherit"})
        return merged
    return cfg


def validate_config(cfg: Dict[str, Any], required_keys: Dict[str, type] | None = None) -> None:
    if not required_keys:
        return
    for k, t in required_keys.items():
        if k not in cfg:
            raise KeyError(f"Missing required key: {k}")
        if not isinstance(cfg[k], t):
                                   
            if t is float and isinstance(cfg[k], int):
                continue
            raise TypeError(f"Key {k} expected {t}, got {type(cfg[k])}")

