import importlib
import random
from typing import Any

import numpy as np


def set_seed(seed: int):
    import torch
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)


def _try_import_gymnasium():
    try:
        return importlib.import_module("gymnasium")
    except ImportError:
        return importlib.import_module("gym")


def make_env(env_id: str, seed: int):
                                                        
    if env_id == "OptimalTrap-v0":
        from gdc_project.envs.optimal_trap import OptimalTrapEnv
        env = OptimalTrapEnv()
    elif env_id == "DynamicOptimalTrap-v0":
        from gdc_project.envs.dynamic_optimal_trap import DynamicOptimalTrapEnv
        env = DynamicOptimalTrapEnv()
    else:
                                                                           
        try:
                                        
            import safety_gymnasium as sg                
            env = sg.make(env_id)
        except Exception:
            gym = _try_import_gymnasium()
            env = gym.make(env_id)

               
    try:
        env.reset(seed=seed)
    except TypeError:
                       
        env.seed(seed)
    return env
