from __future__ import annotations

from dataclasses import dataclass
from typing import Dict


@dataclass
class MovingAverage:
    decay: float = 0.99
    value: float = 0.0
    inited: bool = False

    def update(self, x: float) -> float:
        if not self.inited:
            self.value = x
            self.inited = True
        else:
            self.value = self.decay * self.value + (1 - self.decay) * x
        return self.value


def safety_metrics(total_cost: float, steps: int) -> Dict[str, float]:
    rate = total_cost / max(steps, 1)
    return {"safety/cost_rate": rate}

