from __future__ import annotations

from typing import Callable


def linear_schedule(start: float, end: float, total_steps: int) -> Callable[[int], float]:
    def fn(t: int) -> float:
        if total_steps <= 0:
            return end
        alpha = min(max(t, 0), total_steps) / total_steps
        return (1 - alpha) * start + alpha * end
    return fn


def exponential_schedule(start: float, factor: float) -> Callable[[int], float]:
    def fn(t: int) -> float:
        return start * (factor ** t)
    return fn

