export 'PYTORCH_CUDA_ALLOC_CONF=max_split_size_mb:256'
WANDB_PROJECT=llama2-comet accelerate launch src/train_bash.py \
    --stage sft \
    --model_name_or_path meta-llama/Llama-2-7b-chat-hf \
    --do_train \
    --dataset atomic2020_trn \
    --template llama2 \
    --finetuning_type lora \
    --lora_target q_proj,v_proj \
    --output_dir output/lr1e-4_linear_e3 \
    --overwrite_cache \
    --per_device_train_batch_size 32 \
    --gradient_accumulation_steps 1 \
    --cutoff_len 500 \
    --lr_scheduler_type linear \
    --logging_steps 10 \
    --save_steps 1000 \
    --learning_rate 1e-4 \
    --warmup_steps 7000 \
    --num_train_epochs 3 \
    --plot_loss \
    --fp16 --overwrite_output