"""This is for changing arm set 
for different dimension d and different number of arms K with hyperparameter tuning"""

import numpy as np
import math
import random
from numpy.linalg import inv
import matplotlib.pyplot as plt
from matplotlib import pyplot
from scipy.io import loadmat
import seaborn as sns
plt.style.use('seaborn-whitegrid')
palette = pyplot.get_cmap('Set1')
font1 = {'family' : 'Times New Roman',
'weight' : 'normal',
'size'   : 30,
}
T=1200
fig=plt.figure(figsize=(10,10))
iters=list(range(T))



def LinIMED(n,w,perturbation):
    k=10
    d=50
    
    
    nam=2
    V=nam*np.eye(d)
    hmu=np.zeros(k+1,)
    hgap=np.zeros(k+1,)
    weight=np.exp(-hgap**2)
    p_sum=np.zeros(k+1,)
    numberList=np.linspace(0, k, num=k+1)
    ###T=n
    pp=[]
    GAP=[]
    gamma=np.zeros([d,1])
    N=np.zeros(k+1)
    for t in range(T):
        x=[np.array([0]*(d-1)+[1]).T]
        x_axis=t/(t+1)
        for i in range(k):
            if i<k-1:        
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                #x_axis=(1-1/(t**0.5+1))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis]*(d-1)+[y_axis]).T)  
                x[i].shape=(d,1) 
            else:
                x.append(np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T) 
                x[i].shape=(d,1)
        x[k].shape=(d,1)
        theta_true=np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        p=np.argmin(weight)
        GAP.append(gap[int(p)])
        N[int(p)]+=1
        pp.append(int(p))
        V+=x[int(p)].dot(x[int(p)].T)
        ###beta=0.54*np.log(1+t**2)+1 
        beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2
        beta=beta*w
        y=rew[int(p)]+np.random.normal(0,0.1,1)[0]
        gamma+=x[int(p)]*y
        htheta=inv(V).dot(gamma)
        ###newhtheta=np.random.multivariate_normal(np.squeeze(htheta), beta*(inv(V)), 1).T 
    
        
        hmean=[float(htheta.T.dot(x[i])[0]) for i in range(k+1)]    
        ###hmean=[float(newhtheta.T.dot(x[i])[0]) for i in range(k+1)]      
        hmean=max(hmean)*np.ones(k+1)-hmean
        
        ###original weight=[np.array(float(np.exp(-hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0])) for i in range (k+1)]
        weight=[np.array(float(np.exp(hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0]))/(((x[i].T.dot(inv(V).dot(x[i]))))[0][0]*beta) for i in range(k+1)]
        ###weight=[np.array(float(np.exp(-N[i]*N[i]*hmean[i]**2/1))) for i in range(11)]
        ###weight=[float(i) for i in weight]
        ###weight=np.array(weight)
    return GAP
    
def LinIMED2(n,w,perturbation):
    k=10
    d=50
    
    nam=2
    V=nam*np.eye(d)
    hmu=np.zeros(k+1,)
    hgap=np.zeros(k+1,)
    weight=np.exp(-hgap**2)
    p_sum=np.zeros(k+1,)
    numberList=np.linspace(0, k, num=k+1)
    ###T=n
    pp=[]
    GAP=[]
    gamma=np.zeros([d,1])
    N=np.zeros(k+1)
    for t in range(T):
        x=[np.array([0]*(d-1)+[1]).T]
        x_axis=t/(t+1)
        for i in range(k):
            if i<k-1:        
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                #x_axis=(1-1/(t**0.5+1))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis]*(d-1)+[y_axis]).T) 
                x[i].shape=(d,1)
            else:
                x.append(np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T) 
                x[i].shape=(d,1)
        x[k].shape=(d,1)
        theta_true=np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        p=np.argmin(weight)
        GAP.append(gap[int(p)])
        N[int(p)]+=1
        pp.append(int(p))
        V+=x[int(p)].dot(x[int(p)].T)
        ###beta=0.54*np.log(1+t**2)+1 
        beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2
        beta=beta*w
        y=rew[int(p)]+np.random.normal(0,0.1,1)[0]
        gamma+=x[int(p)]*y
        htheta=inv(V).dot(gamma)
        ###newhtheta=np.random.multivariate_normal(np.squeeze(htheta), beta*(inv(V)), 1).T 
    
        
        hmean=[float(htheta.T.dot(x[i])[0]) for i in range(k+1)]    
        ###hmean=[float(newhtheta.T.dot(x[i])[0]) for i in range(k+1)]      
        hmean=max(hmean)*np.ones(k+1)-hmean
        inde=np.argmin(hmean)
        
        ###original weight=[np.array(float(np.exp(-hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0])) for i in range (k+1)]
        weight=[np.array(float(np.exp(hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0]))/(((x[i].T.dot(inv(V).dot(x[i]))))[0][0]*beta) for i in range(k+1)]
        weight[inde]=np.min([weight[inde], T])
        ###weight=[np.array(float(np.exp(-N[i]*N[i]*hmean[i]**2/1))) for i in range(11)]
        ###weight=[float(i) for i in weight]
        ###weight=np.array(weight)
    return GAP


def LinIMED3(n,w,c,perturbation):
    k=10
    d=50
   
    
    nam=2
    V=nam*np.eye(d)
    hmu=np.zeros(k+1,)
    hgap=np.zeros(k+1,)
    weight=np.exp(-hgap**2)
    p_sum=np.zeros(k+1,)
    numberList=np.linspace(0, k, num=k+1)
    ###T=n
    pp=[]
    GAP=[]
    gamma=np.zeros([d,1])
    N=np.zeros(k+1)
    for t in range(T):
        x=[np.array([0]*(d-1)+[1]).T]
        x_axis=t/(t+1)
        for i in range(k):
            if i<k-1:        
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                #x_axis=(1-1/(t**0.5+1))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis]*(d-1)+[y_axis]).T) 
                x[i].shape=(d,1)
            else:
                x.append(np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T) 
                x[i].shape=(d,1)
        x[k].shape=(d,1)
        theta_true=np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        p=np.argmin(weight)
        GAP.append(gap[int(p)])
        N[int(p)]+=1
        pp.append(int(p))
        V+=x[int(p)].dot(x[int(p)].T)
        ###beta=0.54*np.log(1+t**2)+1 
        beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2
        beta=beta*w
        y=rew[int(p)]+np.random.normal(0,0.1,1)[0]
        gamma+=x[int(p)]*y
        htheta=inv(V).dot(gamma)
        ###newhtheta=np.random.multivariate_normal(np.squeeze(htheta), beta*(inv(V)), 1).T 
    
        
        hmean=[float(htheta.T.dot(x[i])[0]+(((x[i].T.dot(inv(V).dot(x[i]))))[0][0]*beta)**0.5) for i in range(k+1)]    
        ###hmean=[float(newhtheta.T.dot(x[i])[0]) for i in range(k+1)]      
        hmean=max(hmean)*np.ones(k+1)-hmean
        inde=np.argmin(hmean)
        ruaindex=np.argmax(hmean)
        
        ###original weight=[np.array(float(np.exp(-hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0])) for i in range (k+1)]
        weight=[np.array(float(np.exp(hmean[i]**2/(beta*(x[i].T.dot(inv(V).dot(x[i])))))[0]))/(((x[i].T.dot(inv(V).dot(x[i]))))[0][0]*beta) for i in range(k+1)]
        weight[inde]=np.min([weight[inde], c/hmean[ruaindex]**2])
        #print(weight[inde]) /hmean[ruaindex]**0.5
    return GAP


def linUCB(n,w,perturbation):
    k=10
    d=50
   
    
    nam=2
    V=nam*np.eye(d)
    hmu=np.zeros(k+1,)
    hgap=np.zeros(k+1,)
    weight=np.exp(-hgap**2)
    numberList=np.linspace(0, k, num=k+1)
    T=n
    pp=[]
    GAP=[]
    gamma=np.zeros([d,1])
    htheta=np.zeros([d,1])
    for t in range(T):
        x=[np.array([0]*(d-1)+[1]).T]
        x_axis=t/(t+1)
        for i in range(k):
            if i<k-1:        
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                #x_axis=(1-1/(t**0.5+1))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis]*(d-1)+[y_axis]).T) 
                x[i].shape=(d,1)
            else:
                x.append(np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T) 
                x[i].shape=(d,1)
        x[k].shape=(d,1)
        theta_true=np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        if t<0:
            p=np.random.choice(numberList, 1, p=np.ones(k+1)/(k+1))
            GAP.append(gap[int(p[0])])
            pp.append(int(p[0]))
            V+=x[int(p[0])].dot(x[int(p[0])].T)
            #beta=2*np.log(1+t**2)+1
            beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2
            beta=beta*w
            y=rew[int(p[0])]+np.random.normal(0,0.1,1)[0]
            gamma+=x[int(p[0])]*y
            htheta=inv(V).dot(gamma)
            hmean=[float(htheta.T.dot(x[i])[0]) for i in range(k+1)]
            hmean=max(hmean)*np.ones(k+1)-hmean
        else:            
            beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2
            beta=beta*w
            p=np.argmax([float(htheta.T.dot(x[i])[0]+1*((x[i].T.dot(inv(V).dot(x[i])))**0.5)*((beta)**0.5)) for i in range(k+1)])
           ### print([float(htheta.T.dot(x[i])[0]+0*((x[i].T.dot(inv(V).dot(x[i])))**0.5)*(beta)**0.5) for i in range(11)])
            pp.append(int(p))
            GAP.append(gap[int(p)])
            V+=x[int(p)].dot(x[int(p)].T)
            #beta=2*np.log(1+t**2)+1           
            y=rew[int(p)]+np.random.normal(0,0.1,1)[0]
            gamma+=x[int(p)]*y
            htheta=inv(V).dot(gamma)
            hmean=[float(htheta.T.dot(x[i])[0]) for i in range(k+1)]
            hmean=max(hmean)*np.ones(k+1)-hmean
    return GAP


def LinTS(n,w,perturbation):
    k=10
    d=50

    
    nam=2
    B=nam*np.eye(d)
    hmu=np.zeros(d,)
    hgap=np.zeros(k+1,)
    f=np.zeros([d,1])
    numberList=np.linspace(0, k, num=k+1)
    T=n
    pp=[]
    GAP=[]
    gamma=np.zeros([d,1])
    for t in range(T):
       x=[np.array([0]*(d-1)+[1]).T]
       x_axis=t/(t+1)
       for i in range(k):
           if i<k-1:        
               x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
               #x_axis=(1-1/(t**0.5+1))/math.sqrt(d-1)
               y_axis=math.sqrt((d-1)*(x_axis**2))
               x.append(np.array([x_axis]*(d-1)+[y_axis]).T) 
               x[i].shape=(d,1)
           else:
               x.append(np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T) 
               x[i].shape=(d,1)
       x[k].shape=(d,1)
       theta_true=np.array([1/math.sqrt(d-1)]*(d-1)+[0]).T
       reward=[]
       for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
       rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
       gap=max(rew)*np.ones([k+1,])-rew
       beta=(0.1*(d*3*np.log(1+t))**0.5+2**0.5)**2    
       beta=beta*w
       Hmu=np.random.multivariate_normal(hmu, beta*(inv(B)), 1).T
       lis=[np.dot(i.T,Hmu)[0][0] for i in x]
       ind=np.argmax(lis)
       pp.append(ind)
       GAP.append(gap[ind])
       y=rew[ind]+np.random.normal(0,0.1,1)[0]
       B=B+x[ind].dot(x[ind].T)
       f=f+x[ind]*y
       hmu=inv(B).dot(f)
       hmu=np.squeeze(hmu)
    return GAP



def BaseUCB(alpha,Phi,x):
    if Phi is None:
        w=[alpha*(i.T.dot(i))**0.5 for i in x]
        r=[0 for i in x]
        return w, r
    else:
        d=len(x[0])
        m=len(Phi[1])
        I=np.eye(d)
        A=I+sum([Phi[0][:,i].reshape(d,1).dot(Phi[0][:,i].reshape(d,1).T) for i in range(m)])
        B=sum([Phi[1][i]*Phi[0][:,i].T for i in range(m)])
        Ainv=inv(A)
        theta=Ainv.dot(B)
       # print(theta)
        w=[alpha*(i.T.dot(Ainv.dot(i)))**0.5 for i in x]
        r=[theta.T.dot(i) for i in x]
        print(theta)
        return w, r

def SupLinUCB(n,pertur):
    T=n
 
    iters=list(range(T))
    
    
    perturbation=pertur
    
    S=int(np.log(T))
    GAP=[]
    Phi=np.ndarray(shape=(T+1,S),dtype='object')
    for t in range(T):
        
           
        k=10
        d=50
        x=[np.array([0,1]).T]
        x_axis=0
        for i in range(k):
            if i<k-1:        
                #x_axis=(1-1/(6))/math.sqrt(d-1)
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis,y_axis]).T) 
                x[i].shape=(2,1)
            else:
                x_axis=1
                y_axis=math.sqrt(1-x_axis**2)
                x.append(np.array([x_axis,y_axis]).T) 
                x[i].shape=(2,1)
        x[k].shape=(2,1)
        theta_true=np.array([1,0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        s=1
        A=x
        delta=1/(1+t)**2
        alpha=((1/2)*np.log(2*T*(k+1)/delta))**0.5
        
        while(1):
            w, r=BaseUCB(alpha,Phi[t,s],A)
            w=np.array([i for i in w])
            r=np.array([i for i in r])
            print('r=',r)
            """ stage1 """
            if all(i<=1/T**0.5 for i in w):
                p=np.argmax(np.array(r.T[0]+w))
                GAP.append(max(rew)-theta_true.T.dot(A[p])[0])
                y=theta_true.T.dot(A[p])[0]+np.random.normal(0,0.1,1)[0]
                Phi[t+1,:]=Phi[t,:]
                print("hoh")
                break   
            
            elif all(i<=2**(-s) for i in w): 
                Uvalue=np.array((r.T[0]+w)[0][0][0])
                max_U=np.max(Uvalue)
                index=np.where(Uvalue>=max_U-2**(1-s))
                A=[A[i] for i in index[0]]
                r=np.array(r)[index]
                w=np.array(w)[index]
                s=s+1 
                print('hah')
                continue
            else:
                i_index=list(range(len(w)))
                random.shuffle(i_index)
                for i in i_index:
                    if w[i]>2**(-s):
                        print(w[i])
                        p=i
                        GAP.append(max(rew)-theta_true.T.dot(A[p])[0])
                        #print(A[int(p)])
                        y=theta_true.T.dot(A[p])[0]+np.random.normal(0,0.1,1)[0]
                        for s_i in range(S):
                            if s_i==s:
                                
                                    Phi[t+1,s_i]=[np.array(A[int(p)]),np.array([y])]
                                
                                    if Phi[t,s_i] is None:
                                        Phi[t+1,s_i][0]= np.array(A[int(p)])  
                                        Phi[t+1,s_i][1]= np.array([y])
                                        print("wow")
                                    else:                                       
                                        Phi[t+1,s_i][0]= np.hstack((Phi[t,s_i][0],np.array(A[int(p)])))  
                                        print(Phi[t,s_i][0])
                                        print(np.array(A[int(p)]))
                                        print(Phi[t+1,s_i][0])
                                        print(t,s)
                                        print("zzz")
                                       
                                        
                                        Phi[t+1,s_i][1]= np.vstack((Phi[t,s_i][1],np.array([y])))
                                        
                            else:
                                Phi[t+1,s_i]=Phi[t,s_i]
                    break
                break
                            
                    
            
            
            
    
   
    return GAP
    
def SupLinIMED(n,pertur):
    T=n
 
    iters=list(range(T))
    
    
    perturbation=pertur
    
    S=int(np.log(T))
    GAP=[]
    Phi=np.ndarray(shape=(T+1,S),dtype='object')
    for t in range(T):
        
           
        k=10
        d=50
        x=[np.array([0,1]).T]
        x_axis=0
        for i in range(k):
            if i<k-1:        
                #x_axis=(1-1/(6))/math.sqrt(d-1)
                x_axis=(1-1/(7+perturbation[t,i]))/math.sqrt(d-1)
                y_axis=math.sqrt((d-1)*(x_axis**2))
                x.append(np.array([x_axis,y_axis]).T) 
                x[i].shape=(2,1)
            else:
                x_axis=1
                y_axis=math.sqrt(1-x_axis**2)
                x.append(np.array([x_axis,y_axis]).T) 
                x[i].shape=(2,1)
        x[k].shape=(2,1)
        theta_true=np.array([1,0]).T
        reward=[]
        for i in range(k+1):
            reward.append(theta_true.T.dot(x[i])[0])
        rew=np.array(reward)
        ###rew=np.linspace(0.0, 2.0, num=11)
        gap=max(rew)*np.ones([k+1,])-rew
        s=1
        A=x
        delta=1/(1+t)**2
        alpha=((1/2)*np.log(2*T*(k+1)/delta))**0.5
        
        while(1):
            w, r=BaseUCB(alpha,Phi[t,s],A)
            w=np.array([i for i in w])
            r=np.array([i for i in r])
            print('r=',r)
            print('w=',w)
            """ stage1 """
            if all(i<=1/T**0.5 for i in w):
                hr=max(r.T[0])-r.T[0]
                gr_indx=np.where(r.T[0]==max(r.T[0]))[0][0]
                index=np.zeros(len(r.T[0]))
                for iii in range(len(r.T[0])):
                    if iii==gr_indx:
                        
                        index[iii]=min(np.log(2*T),-2*np.log(w[gr_indx][0][0]))
                    else:
                        index[iii]=(hr[iii]/w[iii][0][0])**2-2*np.log(w[iii][0][0])
                
                p=np.argmin(index)
                GAP.append(max(rew)-theta_true.T.dot(A[p])[0])
                y=theta_true.T.dot(A[p])[0]+np.random.normal(0,0.1,1)[0]
                Phi[t+1,:]=Phi[t,:]
                print("hoh")
                break   
            
            elif all(i<=2**(-s) for i in w): 
                Uvalue=np.array((r.T[0]+w)[0][0][0])
                max_U=np.max(Uvalue)
                index=np.where(Uvalue>=max_U-2**(1-s))
                A=[A[i] for i in index[0]]
                r=np.array(r)[index]
                w=np.array(w)[index]
                s=s+1 
                print('hah')
                continue
            else:
                i_index=list(range(len(w)))
                random.shuffle(i_index)
                for i in i_index:
                    if w[i]>2**(-s):
                        print(w[i])
                        p=i
                        GAP.append(max(rew)-theta_true.T.dot(A[p])[0])
                        #print(A[int(p)])
                        y=theta_true.T.dot(A[p])[0]+np.random.normal(0,0.1,1)[0]
                        for s_i in range(S):
                            if s_i==s:
                                
                                    Phi[t+1,s_i]=[np.array(A[int(p)]),np.array([y])]
                                
                                    if Phi[t,s_i] is None:
                                        Phi[t+1,s_i][0]= np.array(A[int(p)])  
                                        Phi[t+1,s_i][1]= np.array([y])
                                        print("wow")
                                    else:                                       
                                        Phi[t+1,s_i][0]= np.hstack((Phi[t,s_i][0],np.array(A[int(p)])))  
                                        print(Phi[t,s_i][0])
                                        print(np.array(A[int(p)]))
                                        print(Phi[t+1,s_i][0])
                                        print(t,s)
                                        print("zzz")
                                       
                                        
                                        Phi[t+1,s_i][1]= np.vstack((Phi[t,s_i][1],np.array([y])))
                                        
                            else:
                                Phi[t+1,s_i]=Phi[t,s_i]
                    break
                break
                            
                    
            
            
            
    
   
    return GAP            



k=10
d=50


perturbation=0.1*np.random.rand(T,k)
c=30

w=1**2
runs=100



alldata1=[]
for s in range(runs):   
    history=LinIMED(T,0.1**2,perturbation)
    #history=LinIMED(T,w,perturbation)
    regret1=[history[0]]
    for i in range(1,T):
        g=history[i]+regret1[i-1]
        regret1.append(g)
    
    regret1=np.array(regret1)
    data=regret1
    alldata1.append(data)
alldata1=np.array(alldata1)
print("1")
alldata2=[]
for s in range(runs):   
    history=linUCB(T,0.3**2,perturbation)
    #history=linUCB(T,w,perturbation)
    regret2=[history[0]]
    for i in range(1,T):
        g=history[i]+regret2[i-1]
        regret2.append(g)
    
    regret2=np.array(regret2)
    data=regret2
    alldata2.append(data)
alldata2=np.array(alldata2)
print("2")

alldata3=[]
for s in range(runs):   
    history=LinTS(T,0.15**2,perturbation)
    #history=LinTS(T,w,perturbation)
    regret3=[history[0]]
    for i in range(1,T):
        g=history[i]+regret3[i-1]
        regret3.append(g)
    
    regret3=np.array(regret3)
    data=regret3
    alldata3.append(data)
alldata3=np.array(alldata3)
print("3")
alldata4=[]
for s in range(runs):   
    history=LinIMED2(T,0.15**2,perturbation)
    #history=LinIMED2(T,w,perturbation)
    regret4=[history[0]]
    for i in range(1,T):
        g=history[i]+regret4[i-1]
        regret4.append(g)
    
    regret4=np.array(regret4)
    data=regret4#
    alldata4.append(data)
alldata4=np.array(alldata4)
print("4")

alldata5=[]
for s in range(runs):   
    history=LinIMED3(T,0.1**2,c,perturbation)
    #history=LinIMED3(T,w,c,perturbation)
    regret5=[history[0]]
    for i in range(1,T):
        g=history[i]+regret5[i-1]
        regret5.append(g)
    
    regret5=np.array(regret5)
    data=regret5#
    alldata5.append(data)
alldata5=np.array(alldata5)
print("5")




alldata6=[]
for s in range(runs):   
    history=SupLinUCB(T,perturbation)
    #history=LinIMED3(T,w,c,perturbation)
    regret6=[history[0]]
    for i in range(1,1000):
        g=history[i]+regret6[i-1]
        regret6.append(g)
    
    regret6=np.array(regret6)
    data=regret6#
    alldata6.append(data)
alldata6=np.array(alldata6)
print("6")





alldata7=[]
for s in range(runs):   
    history=SupLinIMED(T,perturbation)
   
    regret7=[history[0]]
    for i in range(1,1000):
        g=history[i]+regret7[i-1]
        regret7.append(g)
    
    regret7=np.array(regret7)
    data=regret7#
    alldata7.append(data)
alldata7=np.array(alldata7)
print("7")


















resultdata=[]
for i in range(1):
    ax=fig.add_subplot(1,1,1)  
    
    color=palette(0)
    avg=np.mean(alldata2,axis=0)
    std=np.std(alldata2,axis=0)
    resultdata.append(["LinUCB   ", avg[T-1], std[T-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(iters, avg, color=color,label="LinUCB",linewidth=3.0)
    ax.fill_between(iters, r1, r2, color=color, alpha=0.2)
    
    color=palette(1)
    avg=np.mean(alldata3,axis=0)
    std=np.std(alldata3,axis=0)
    resultdata.append(["LinTS    ", avg[T-1], std[T-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(iters, avg, color=color,label="LinTS",linewidth=3.0)
    ax.fill_between(iters, r1, r2, color=color, alpha=0.2)

    color=palette(2)
    avg=np.mean(alldata1,axis=0)
    std=np.std(alldata1,axis=0)
    resultdata.append(["LinIMED-1", avg[T-1], std[T-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(iters, avg, color=color,label="LinIMED-1",linewidth=3.0)
    ax.fill_between(iters, r1, r2, color=color, alpha=0.2)

    color=palette(6)
    avg=np.mean(alldata4,axis=0)
    std=np.std(alldata4,axis=0)
    resultdata.append(["LinIMED-2", avg[T-1], std[T-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(iters, avg, color=color,label="LinIMED-2",linewidth=3.0)
    ax.fill_between(iters, r1, r2, color=color, alpha=0.2)
    
    color=palette(3)
    avg=np.mean(alldata5,axis=0)
    std=np.std(alldata5,axis=0)
    resultdata.append(["LinIMED-3", avg[T-1], std[T-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(iters, avg, color=color,label="LinIMED-3",linewidth=3.0)
    ax.fill_between(iters, r1, r2, color=color, alpha=0.2)
    
    
    
    color=palette(7)
    avg=np.mean(alldata6,axis=0)
    std=np.std(alldata6,axis=0)
    resultdata.append(["SupLinUCB   ", avg[1000-1], std[1000-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(list(range(1000)), avg, color=color,label="SupLinUCB",linewidth=3.0)
    ax.fill_between(list(range(1000)), r1, r2, color=color, alpha=0.2)
    
    color=palette(8)
    avg=np.mean(alldata7,axis=0)
    std=np.std(alldata7,axis=0)
    resultdata.append(["SupLinIMED   ", avg[1000-1], std[1000-1]])
    r1 = list(map(lambda x: x[0]-x[1], zip(avg, std)))
    r2 = list(map(lambda x: x[0]+x[1], zip(avg, std)))
    ax.plot(list(range(1000)), avg, color=color,label="SupLinIMED",linewidth=3.0)
    ax.fill_between(list(range(1000)), r1, r2, color=color, alpha=0.2)
    
    
    ax.legend(loc='upper left',prop=font1)
    ax.set_xlabel('Time',fontsize=24)
    ax.set_ylabel('Regret',fontsize=24)
    
plt.legend(loc='lower right',fontsize=28)
plt.grid('on')
#plt.xlim((0,1000))
plt.ylim((0,20))
#plt.ylim((0,7))
#plt.xticks([0,2000,4000,6000,8000,10000], fontsize=22)
#plt.xticks([0,200,400,600,800,1000], fontsize=22)
#plt.xticks([0,500,1000,1500,2000,2500,3000], fontsize=22)
#plt.xticks([0,200,400,600,800,1000], fontsize=22)
#plt.yticks([0,2,4,6,8], fontsize=22)
#plt.yticks([0,1,2,3,4,5,6,7], fontsize=22)
#plt.yticks([0,2,4,6,8,10], fontsize=22)
plt.xlabel('Time', fontsize=30)
plt.ylabel('Regret', fontsize=30)


#fig.savefig('./newpics/k=10_d=20.png', format='png', dpi=300)
print(np.array(resultdata))




