# @title Child Helplines
# Source : https://github.com/LAION-AI/Open-Instruction-Generalist/blob/main/OIG/src/child_help.py
"""
From https://childhelplineinternational.org/helplines/
NOTE:
This list was created in early 2023 from the above website and may not be current.
"""
# thank you to OA discord user: someone13574 for creating this json data
child_hotline = {
    "Sauver l’Enfant": {
        "region": "Benin",
        "page": "https://childhelplineinternational.org/benin-sauver-lenfant/",
        "description": "Sauver l’Enfant is a new child helpline operating in Benin",
        "contacts": {"138": {"type": "phone", "link": "tel:11611"}},
    },
    "Childline Botswana": {
        "region": "Botswana",
        "page": "https://childhelplineinternational.org/botswana-childline-botswana-2/",
        "description": "Childline Botswana’s vision is to have a nation that is child friendly: that respects children’s rights and does not abuse its children by the year 2036.",
        "contacts": {
            "Website": {"type": "website", "link": "http://childlinebotswana.org.bw"},
            "11611": {"type": "phone", "link": "tel:11611"},
            "3 900 900": {"type": "phone", "link": "tel:3900900"},
            "Email": {"type": "email", "link": "mailto:info@childlinebotswana.org.bw"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ChildlineBotswanaTrust"},
            "Twitter": {
                "type": "twitter",
                "link": "https://twitter.com/ChildlineBots?fbclid=IwAR1-vUiOPw0GpE3Q6j8HaD8QkXRLzb2wN1KtfM7tHvqjzoHrwuHWIM6OAkY",
            },
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC96Bnc8a6DcxYbPWJI-QAgA"},
        },
    },
    "Allo 116 – Ligne téléphonique d’assistance aux enfants": {
        "region": "Burkina Faso",
        "page": "https://childhelplineinternational.org/burkina-faso-allo-116-ligne-telephonique-dassistance-aux-enfants/",
        "contacts": {
            "action-sociale.gov.bf": {"type": "website", "link": "http://www.action-sociale.gov.bf/"},
            "116": {"type": "phone", "link": "tel:116"},
            "+226 25 46 09 81": {"type": "phone", "link": "tel:+226%2025%2046%2009%2081"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/MFSNFAH"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC2dzYVan9Zta6-hsJmw9fjg"},
        },
    },
    "Yaga Ndakumva": {
        "region": "Burundi",
        "page": "https://childhelplineinternational.org/burundi-yaga-ndakumva/",
        "description": "Yaga Ndakumva is a child helpline for the children of Burundi.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.droitshumains.gov.bi/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ministeredroitshumains.genre"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/GenreMinistere"},
        },
    },
    "Lignes Vertes Cameroun": {
        "region": "Cameroon",
        "page": "https://childhelplineinternational.org/cameroon-lignes-vertes-cameroun/",
        "description": "Lignes Vertes Cameroun is currently migrating to become a 116 operator. ",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.minproff.cm/liens-utiles/green-lines/"},
            "116": {"type": "phone", "link": "tel:116"},
            "222 23 25 50": {"type": "phone", "link": "tel:222%2023%2025%2050"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/minproff.cameroun/"},
        },
    },
    "Ligne Verte 116": {
        "region": "Côte d’Ivoire",
        "page": "https://childhelplineinternational.org/cote-divoire-ligne-verte-116-allo-enfant-en-detresse/",
        "description": "Ministère de la Solidarité, de la Famille, de la Femme, et de l’Enfant’s Ligne verte 116 is a free counseling and referral service for children. This service communicates through two numbers:",
        "contacts": {
            "http://www.famille.gouv.ci/": {"type": "website", "link": "http://www.famille.gouv.ci/"},
            "116": {"type": "phone", "link": "tel:116"},
            "1308": {"type": "phone", "link": "tel:1308"},
            "mfpes.info@gmail.com": {"type": "email", "link": "http://mfpes.info@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/profile.php?id=100067980595652"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/msffegouvci"},
        },
    },
    "Tukinge Watoto": {
        "region": "Democratic Republic of Congo",
        "page": "https://childhelplineinternational.org/democratic-republic-of-congo-tukinge-watoto/",
        "description": "War Child UK runs a free helpline called Tukinge Watoto (meaning “Let’s Protect Children”) to help provide support to at-risk children and make sure that law enforcers respect their rights.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://www.warchild.org.uk/our-work/where-we-work/democratic-republic-of-congo",
            },
            "117": {"type": "phone", "link": "tel:117"},
        },
    },
    "Eswatini Ministry of Education Toll free number": {
        "region": "Eswatini",
        "page": "https://childhelplineinternational.org/eswatini-eswatini-ministry-of-education-toll-free-number/",
        "description": "The Eswatini Ministry of Education Toll free number supports children and youth in need.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.govpage.co.za/swaziland-education-and-training.html"},
            "116": {"type": "phone", "link": "tel:116"},
            "Facebook": {"type": "facebook", "link": "http://www.facebook.com/Govpage"},
        },
    },
    "SWAGAA 951 Help Line": {
        "region": "Eswatini",
        "page": "https://childhelplineinternational.org/eswatini-swagaa-951-help-line/",
        "description": "The Swaziland Action Group Against Abuse is committed to eradicating sexual and physical abuse and their toll-free help line is for anyone seeking support surrounding gender-based violence, sexual assault and reporting abuse.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.swagaa.org.sz/"},
            "951": {"type": "phone", "link": "tel:591"},
            "Email": {"type": "email", "link": "mailto:swagaa@swagaa.org.sz"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/Swaziland-Action-Group-Against-Abuse-SWAGAA-202248446510926/",
            },
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/swatiniactiongroupagainstabuse/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/swagaa951"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/swaziland-action-group-against-abuse/about/",
            },
        },
    },
    "Adama Child Helpline (ECFA)": {
        "region": "Ethiopia",
        "page": "https://childhelplineinternational.org/ethiopia-adama-child-helpline-ecfa/",
        "description": "ECFA works in partnership with community, national, and international partners, including families, government agencies, and local leaders, to prevent abuse and ensure the physical, mental, and social well-being of children and youth in Oromia region, Ethiopia. Operated by ECFA, the Adama Child Helpline provides advice, information and support to children and families.",
        "contacts": {
            "Website": {"type": "website", "link": "https://ecfaethiopia.org/"},
            "919": {"type": "phone", "link": "tel:919"},
            "+251221-117575": {"type": "phone", "link": "tel:+251221-117575"},
            "Email": {"type": "email", "link": "mailto:info@ecfaethiopia.org"},
        },
    },
    "Child Helpline Gambia": {
        "region": "Gambia",
        "page": "https://childhelplineinternational.org/gambia-child-helpline-gambia/",
        "description": "Child Helpline Gambia is run by CEDAG (Children & Environmental Development Association), a nonprofit organization registered in Gambia with a mission to promote the principle of children’s rights, women and community well-being.",
        "contacts": {
            "+2209940239": {"type": "phone", "link": "tel:+2209940239"},
            "199": {"type": "phone", "link": "tel:199"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/2434793426744326/posts/did-you-know-the-gambia-now-has-a-child-helpline-199-is-the-product-of-a-coordin/2756674237889575/",
            },
        },
    },
    "AMPCAN Ghana": {
        "region": "Ghana",
        "page": "https://childhelplineinternational.org/ghana-ampcan-ghana/",
        "description": "AMPCAN is a non-governmental organization with a mission to improve the welfare of Ghanaian children and to enhance opportunities for the development of their full potential.",
        "contacts": {
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Ampcan-Ghana-128016973924144/"}
        },
    },
    "AGUIAS 116": {
        "region": "Guinea",
        "page": "https://childhelplineinternational.org/guinea-aguias-116/",
        "description": "AGUIAS (Association Guinéenne des Assistantes Sociales) offers psychosocial support services, legal and medical assistance through its 116 child helpline.",
        "contacts": {
            "116": {"type": "phone", "link": "tel:116"},
            " +224 621 75 35 35": {"type": "phone", "link": "tel:+224621753535"},
            "Email": {"type": "email", "link": "mailto:cisseaguias@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/aguias116"},
        },
    },
    "Childline Kenya": {
        "region": "Kenya",
        "page": "https://childhelplineinternational.org/kenya-childline-kenya/",
        "description": "Childline Kenya works in partnership with the Government to stop child abuse and provide a safe environment for all children. It offers the only nationwide helpline service dedicated to children that runs 24 hours toll free, and is accessible by simply dialing 116.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childlinekenya.co.ke/"},
            "116": {"type": "phone", "link": "tel:116"},
            "WhatsApp": {"type": "whatsapp", "link": "tel:+254722116116"},
            "Email": {"type": "email", "link": "mailto:info@childlinekenya.co.ke"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ChildlineKenya/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childlinekenya/?hl=en"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/childlinekenya"},
        },
    },
    "Child Helpline Lesotho": {
        "region": "Lesotho",
        "page": "https://childhelplineinternational.org/lesotho-child-helpline-lesotho/",
        "description": "Child Helpline Lesotho is a free counseling and referral service for children that operates the 116 pan-African number.",
        "contacts": {"116": {"type": "phone", "link": "tel:116"}},
    },
    "My Voice, My Safety": {
        "region": "Liberia",
        "page": "https://childhelplineinternational.org/liberia-my-voice-my-safety/",
        "description": "My Voice, My Safety is part of the Ministry of Gender, Children and Social Development in Liberia and provides counseling services to survivors of SGBV/HTP and their families to manage trauma, stigma, neglect and /or loss, depression, anxiety and other mental health concerns.",
        "contacts": {
            "+231886521443": {"type": "phone", "link": "tel:+231886521443"},
            "+231777521443  ": {"type": "phone", "link": "tel:+231777521443%20%20"},
            "Email": {"type": "email", "link": "mailto:info@myvoicemysafety.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/MOGCSPLiberia/"},
        },
    },
    "Ligne Verte 147 Madagascar": {
        "region": "Madagascar",
        "page": "https://childhelplineinternational.org/madagascar-ligne-verte-147-madagascar/",
        "description": "Ligne Verte 147 is a child helpline for reporting cases of mistreatment, violence, abuse and exploitation against children and is is free, available 24/7 and accessible everywhere in Madagascar.",
        "contacts": {
            "Website": {"type": "website", "link": "https://arozaza.mg/"},
            "147": {"type": "phone", "link": "tel:147"},
            "Email": {"type": "email", "link": "mailto:147@arozaza.mg"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/LigneVerte147/"},
        },
    },
    "Tithandizane Helpline 116": {
        "region": "Malawi",
        "page": "https://childhelplineinternational.org/malawi-tithandizane-helpline-116/",
        "description": "Tithandizane Helpline 116 is operated by YONECO, a non-governmental organization committed to empowering the youth, women and children; promoting good health, human rights and democracy; adapting and mitigating the impact of climate change; and conducting research for evidence-based programming and advocacy.",
        "contacts": {
            "Website": {"type": "website", "link": "https://yoneco.org/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:%20executive@yoneco.org.mw"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/YONECOMw/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/yoneco97/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/tithandizane1"},
        },
    },
    "LATEF – Ligne d’Assistance Telephonique aux Enfants et aux Femmes": {
        "region": "Mauritania",
        "page": "https://childhelplineinternational.org/mauritania-latef-ligne-dassistance-telephonique-aux-enfants-et-aux-femmes/",
        "description": "LATEF is operated by the Mauritanian Association for Mother and Child Health (AMSME), a non-profit NGO with consultative status with the United Nations Economic and Social Council. It is an important tool in the context of child protection within Mauritania.",
        "contacts": {
            "Website": {"type": "website", "link": "http://amsme.org/"},
            "+222 46 71 08 31": {"type": "phone", "link": "tel:+22246710831"},
            "Email": {"type": "email", "link": "mailto:comm.amsme.99@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/www.amsme.org/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/AmsmeDei"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCxY39J_J_kWRdVWoL-GMnZw"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/amsme-section-d%C3%A9fense-des-enfants-international-mauritanie/about/",
            },
        },
    },
    "Child Helpline Mauritius": {
        "region": "Mauritius",
        "page": "https://childhelplineinternational.org/mauritius-child-helpline-mauritius/",
        "description": "Halley Movement is a coalition of charitable organisations working for the welfare of children and family in Mauritius and in the Southern African region. Its child helpline seeks to raise awareness of children and communities about their rights, provide phone guidance and support to children and parents",
        "contacts": {
            "Website": {"type": "website", "link": "http://halleymovement.org/our-programs/child-helpline/"},
            "214 2451": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:%20info@helplinemauritius.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/helplinemauritius"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/halleymovement"},
        },
    },
    "Linha Fala Crianca – Child Helpline Mozambique": {
        "region": "Mozambique",
        "page": "https://childhelplineinternational.org/mozambique-linha-fala-crianca-child-helpline-mozambique/",
        "description": "Established in 2009, Linha Fala Criança is a non-profit organisation which provides a free telephone helpline to children in Mozambique. The helpline allows children who need help to report abuse and to be subsequently referred to the appropriate services in the areas of health, justice, education and social action.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.linhafala.org.mz/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "https://orgchil-jicorica.savviihq.com/?p=2511"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/linhafala.crianca.3"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/linhafala/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/linha_fala"},
        },
    },
    "LifeLine/ChildLine Namibia": {
        "region": "Namibia",
        "page": "https://childhelplineinternational.org/namibia-lifeline-childline-namibia/",
        "description": "Lifeline/Childline is a non-governmental organisation providing counselling to people all over Namibia, focusing on restoring hope and changing lives.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.lifelinechildline.org.na/"},
            "116": {"type": "phone", "link": "tel:116"},
            "+264 61 226 889": {"type": "phone", "link": "tel:+26461226889"},
            "Email": {"type": "email", "link": "mailto:info@lifeline.org.na"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/lifeline_childline_nam/?hl=en"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/llcl_nam"},
        },
    },
    "Cece Yara Child Helpline": {
        "region": "Nigeria",
        "page": "https://childhelplineinternational.org/nigeria-cece-yara-child-helpline/",
        "description": "The Cece Yara Child Advocacy Centre provides a child-friendly safe environment for children to disclose sexual abuse and to get FREE legal, medical & therapeutic help they need. FREE child helpline to report, get help & information.",
        "contacts": {
            "Website": {"type": "website", "link": "https://ceceyara.org/"},
            "08008008001": {"type": "phone", "link": "tel:08008008001"},
            "Email": {"type": "email", "link": "mailto:info@ceceyara.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ceceyarafoundation"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/cece_yara/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/cece_yara"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCA3vYL6aTo90mruGOLNeJEg/featured"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/cece-yara-foundation/?originalSubdomain=ng",
            },
        },
    },
    "HDI Nigeria Child Helpline": {
        "region": "Nigeria",
        "page": "https://childhelplineinternational.org/nigeria-hdi-nigeria-child-helpline/",
        "description": "Human Development Initiatives Nigeria (HDI) offers telephone services to seek for help during emergencies or moments of crisis.Over the years, the HDI Nigeria Child Helpline has succeeded in improving the reproductive health of adolescents through counseling, mentoring and referrals as the case may require.",
        "contacts": {
            "Website": {"type": "website", "link": "https://hdinigeria.org/hdinigeria/"},
            "0808-0551-376": {"type": "phone", "link": "tel:0808-0551-376"},
            "+234 1 453 5717": {"type": "phone", "link": "tel:+23414535717"},
            "Email": {"type": "email", "link": "mailto:info@hdinigeria.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/hdinigeria"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/hdi4nigeria/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/hdi4nigeria"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/HDINIGERIA"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/in/human-development-initiatives-nigeria-174732191/?trk=public_profile_browsemap&originalSubdomain=ng",
            },
        },
    },
    "Centre GINDDI – Allo 116": {
        "region": "Senegal",
        "page": "https://childhelplineinternational.org/senegal-centre-ginddi-allo-116/",
        "description": "Allo 116 is a listening, psychological assistance and information service for children and parents. It also works to prevent against all forms of violations of children’s rights and provide medical and social assistance for street children in Senegal.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.centreginddi.com/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:centreginddi@hotmail.fr"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/UtilisateurGinddi/"},
        },
    },
    "ChildHelp Sierra Leone": {
        "region": "Sierra Leone",
        "page": "https://childhelplineinternational.org/sierra-leone-childhelp-sierra-leone/",
        "description": "ChildHelp Sierra Leone is designed specifically to meet both immediate and long-term needs of impoverished and underprivileged needy children, their families and communities in need and living in difficult circumstances.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childhelpsl.org/"},
            "+232 78 666269": {"type": "phone", "link": "tel:+23278666269"},
            "Email": {"type": "email", "link": "mailto:helpachildinafrica@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childhelpsierra/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/childhelpsierra"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/childhelp-sierra-leone/about/"},
        },
    },
    "EEHR Sierra Leone Child Helpline": {
        "region": "Sierra Leone",
        "page": "https://childhelplineinternational.org/sierra-leone-eehr-sierra-leone-child-helpline/",
        "description": "EEHRSL (Economic Empowerment & Human Rights) serves the children and young people of Sierra Leone.",
        "contacts": {
            "Website": {"type": "website", "link": "https://eehrsl.wixsite.com/eehrsl"},
            "078666269": {"type": "phone", "link": "tel:078666269"},
            "Email": {"type": "email", "link": "https://eehrsl.wixsite.com/eehrsl/form"},
        },
    },
    "WAAPO Child Hotline (Short-Call Helpline)": {
        "region": "Somalia",
        "page": "https://childhelplineinternational.org/somalia-waapo-child-hotline-short-call-helpline/",
        "description": "WAAPO’s mission is to respond to children in need of protection- to make their voices heard and concerns relayed to policy and decision makers; and, to provide learning experiences for children in a safe and caring environment helping them develop socially, emotionally, physically and intellectually. ",
        "contacts": {
            "Website": {"type": "website", "link": "https://waapo.ngo"},
            "334": {"type": "phone", "link": "tel:334"},
            "Email": {"type": "email", "link": "mailto:contact@waapo.org.so"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/WAAPO-Organization-727724320666578/"},
        },
    },
    "Childline South Africa": {
        "region": "South Africa",
        "page": "https://childhelplineinternational.org/south-africa-childline-south-africa/",
        "description": "Childline is an effective non-profit organization that works collectively to protect children from all forms of violence and to create a culture of children’s rights in South Africa",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.childlinesa.org.za/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:olcadmin@childlinesa.org.za"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ChildlineSA"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childlinesa/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ChildlineSA"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCm0KZ6ue8FLsH73er56KogA"},
        },
    },
    "Tanzania National Child Helpline": {
        "region": "Tanzania",
        "page": "https://childhelplineinternational.org/tanzania-tanzania-national-child-helpline/",
        "description": "The Tanzania National Child Helpline services children through free of cost telephone number 116, the National Child Helpline. With the Internet Watch Foundation hotline we remove child abuse images through an online portal available to the public throughout Tanzania.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.sematanzania.org/child-helpline"},
            "116": {"type": "phone", "link": "tel:116"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send/?phone=255624100100&text=Hi%2C+I%27m+interested&app_absent=0",
            },
            "Email": {"type": "email", "link": "mailto:info@sematanzania.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SemaTanzania/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/sematanzania/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/sematanzania"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/c-sema/about/"},
        },
    },
    "Allo 1011": {
        "region": "Togo",
        "page": "https://childhelplineinternational.org/togo-allo-1011/",
        "description": "Allo 1011 is operated by CROPESDI.",
        "contacts": {"1011": {"type": "phone", "link": "tel:1011"}},
    },
    "Sauti 116": {
        "region": "Uganda",
        "page": "https://childhelplineinternational.org/uganda-sauti-116/",
        "description": "Sauti 116 is  sustainable Uganda Child Helpline service embedded into society and consistently offering timely and quality services that respond to child protection needs.",
        "contacts": {
            "Website": {"type": "website", "link": "https://sauti.mglsd.go.ug/sauti/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:sautichl@mglsd.go.ug"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/sauti116/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/sauti116"},
        },
    },
    "Childline Zambia": {
        "region": "Zambia",
        "page": "https://childhelplineinternational.org/zambia-childline-zambia/",
        "description": "Lifeline/Childline Zambia is a toll-free telephone counselling and guidance service. The service aims to promote child protection and prevent gender-based violence.",
        "contacts": {
            "Website": {"type": "website", "link": "https://clzambia.org/"},
            "116": {"type": "phone", "link": "tel:116"},
            "SMS 116": {"type": "comment", "link": "sms:116"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/lifelinechildlinezambia"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ZambiaLifeline"},
        },
    },
    "Childline Zimbabwe": {
        "region": "Zimbabwe",
        "page": "https://childhelplineinternational.org/zimbabwe-childline-zimbabwe/",
        "description": "Childline Zimbabwe’s mission is to champion, defend and promote the rights of children in Zimbabwe through the provision of safe, confidential and child friendly reporting mechanisms centered around a free 24 hour counseling service.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childline.org.zw"},
            "116": {"type": "phone", "link": "tel:116"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://l.facebook.com/l.php?u=https%3A%2F%2Fapi.whatsapp.com%2Fsend%3Fphone%3D263732116116%26app%3Dfacebook%26entry_point%3Dpage_cta%26fbclid%3DIwAR23wuOB9KGoantZMExDYxTMbBduB5K5rAOrhox6C_td3gA0tGOkW8xLEUs&h=AT1E2futBhPzHb6fk0_RG5euAgsN4tj2WV6gI_Rc4-H8xVLrrcJGodfUZ-LRdkvQLKGY8eekkcxD8tjAxynKX8aK6YQPb7Mf3zPmoKCPlOqnAjuSJJ6BYrhYNwoJdGDrb8hxGsE_",
            },
            "Email": {"type": "email", "link": "mailto:116@childline.org.zw"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childlinezimbabwe/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/childlinezim"},
        },
    },
    "Línea 102 CaBA": {
        "region": "Argentina",
        "page": "https://childhelplineinternational.org/argentina-linea-102-caba/",
        "description": "Línea 102 CaBA is a free telephone advice service on the rights of boys and girls in the City of Buenos Aires. It works 24 hours a day, 365 days a year.",
        "contacts": {
            "Línea 102 CaBA": {"type": "website", "link": "https://www.buenosaires.gob.ar/cdnnya/linea102"},
            "102": {"type": "phone", "link": "tel:102"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send?phone=5491150500147&text=Linea%20102&source=&data=",
            },
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/GCBA/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/gcba"},
        },
    },
    "Linea 102 Provincia de Buenos Aires": {
        "region": "Argentina",
        "page": "https://childhelplineinternational.org/argentina-linea-102-provincia-de-buenos-aires/",
        "description": "Línea 102 PdBA is a free telephone advice service on the rights of boys and girls in the Province of Buenos Aires. It works 24 hours a day, 365 days a year.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.facebook.com/102Linea/"},
            "102": {"type": "phone", "link": "tel:%20102"},
            "Email": {"type": "email", "link": "http://linea102@syna.gba.gob.ar"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/102Linea/"},
            "Instagram": {"type": "instragram", "link": "https://twitter.com/bacdnnya"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/bacdnnya"},
        },
    },
    "Telefon Pa Hubentud": {
        "region": "Aruba",
        "page": "https://childhelplineinternational.org/aruba-telefon-pa-hubentud/",
        "description": "Telefon Pa Hubentud is an independent charity that serves as an Aruban Youth Telephone Line, which was launched on November 20, 1999. With a distinctive telephone number ’131,’ they aim to help children and youngsters from 8-24 years old and provide their services from 14.00 hours to 18.00 hours, 365 days a year.",
        "contacts": {
            "Website": {"type": "website", "link": "https://131.aw/"},
            "131": {"type": "phone", "link": "tel:131"},
            "Email": {"type": "email", "link": "mailto:telhubentud@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/telefon.hubentud/"},
            "Instagram": {"type": "instragram", "link": ""},
        },
    },
    "Línea 156": {
        "region": "Bolivia",
        "page": "https://childhelplineinternational.org/bolivia-linea-156/",
        "description": "The Platform for Comprehensive Family Care integrates the municipal services of the Defence and Protection against all forms of Violence. Línea 156 Emergency Violence Line provides care and rescue victims of some kind of violence. Anyone who lives in the municipality of La Paz will be served.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.lapaz.bo/infoservicio/linea-emerg-a-la-violencia-156/"},
            "156": {"type": "phone", "link": "tel:156"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/MunicipioLaPaz/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/alcaldialapaz/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/LaPazAlcaldia"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/c/Alcald%C3%ADaLaPazGAMLP"},
        },
    },
    "Safernet Brasil": {
        "region": "Brazil",
        "page": "https://childhelplineinternational.org/brazil-safernet-brasil/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.safernet.org.br/site/"},
            "Email": {"type": "email", "link": "mailto:comunicacao@safernet.org.br"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SafernetBR"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/safernetbr/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/safernet"},
        },
    },
    "Kids Help Phone": {
        "region": "Canada",
        "page": "https://childhelplineinternational.org/canada-kids-help-phone/",
        "description": "Kids Help Phone is Canada’s only 24/7 e-mental health service offering free, confidential support to young people in English and French.",
        "contacts": {
            "Website": {"type": "website", "link": "https://kidshelpphone.ca/"},
            "1-800-668-6868": {"type": "phone", "link": "tel:1-800-668-6868"},
            "Text TALK to 686868": {"type": "phone", "link": "tel:686868"},
            "Email": {"type": "email", "link": "mailto:info@kidshelpphone.ca"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/KidsHelpPhone/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kidshelpphone/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/KidsHelpPhone"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/KidsHelpPhone"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/kidshelpphone/?originalSubdomain=ca",
            },
        },
    },
    "Fonoinfancia 800 200 818": {
        "region": "Chile",
        "page": "https://childhelplineinternational.org/chile-fonoinfancia-800-200-818/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.fonoinfancia.cl/"},
            "800200818": {"type": "phone", "link": "tel:800200818"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/fonoinfancia/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/fonoinfancia/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Fonoinfancia"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/fonoinfancia"},
        },
    },
    "Línea Libre": {
        "region": "Chile",
        "page": "https://childhelplineinternational.org/chile-linea-libre/",
        "description": "Línea Libre is is a psychological support channel aimed at girls, boys and young people, which is attended directly by psychologists trained to contain, guide, intervene in crises, and address mental health concerns or rights violations. It is available Monday to Saturday from 10:00 a.m. to 10:00 p.m. through three channels: phone email, and chat via our app.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.linealibre.cl/"},
            "1515": {"type": "phone", "link": "tel:1515"},
            "Email": {"type": "email", "link": "mailto:contacto@linealibre.cl"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/www.linealibre.cl"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/lalinealibre/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/lalinealibre"},
            "Apple App Store": {"type": "apple", "link": "https://apps.apple.com/cl/app/l%C3%ADnea-libre/id1467421633"},
            "Google Play App": {
                "type": "google",
                "link": "https://play.google.com/store/apps/details?id=com.ltmessenger.linealibre&hl=es_419&pli=1",
            },
        },
    },
    "ICBF Colombia – Línea 141": {
        "region": "Colombia",
        "page": "https://childhelplineinternational.org/colombia-icbf-colombia-linea-141/",
        "description": "Línea 141 is a free national hotline that the Colombian Family Welfare Institute makes available to any adult or child who needs to report an emergency, make a complaint or ask for guidance on cases of child abuse, sexual violence, bullying, child labour, or drug and substance use, among many other situations that threaten or affect the life and integrity of a child or adolescent. It is available 24 hours via phone.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.icbf.gov.co/"},
            "141": {"type": "phone", "link": "tel:141"},
            "Email": {"type": "email", "link": "mailto:atencionalciudadano@icbf.gov.co"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ICBFColombia"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/icbfcolombiaoficial/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ICBFColombia"},
        },
    },
    "Línea 106 Bogotá": {
        "region": "Colombia",
        "page": "https://childhelplineinternational.org/colombia-linea-106-bogota/",
        "description": "Línea 106 is a free support channel with the mission to listen to people in need and promote mental health. Since 1997, we address the concerns of citizens to make Bogotá a better territory for everyone. In addition, that children, adolescents and adults of all ages receive listening and psychological support from the District Health Secretariat.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.saludcapital.gov.co/Paginas2/Linea106-Inicio.aspx"},
            "106": {"type": "phone", "link": "tel:106"},
            "Email": {"type": "email", "link": "mailto:linea106@saludcapital.gov.co"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Linea106"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/linea106bogota/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/sectorsalud"},
        },
    },
    "Te Guío": {
        "region": "Colombia",
        "page": "https://childhelplineinternational.org/te-guio/",
        "description": "Te Gúio is strengthening capacities in Colombia in terms of prevention of sexual violence against children and adolescents. The helpline provides information on harmful sexual behaviour among minors, and offers a tele-counselling service for adolescents who are exhibiting this type of behaviour.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.teguiocolombia.org"},
            "01800 519 0690": {"type": "phone", "link": "tel:018005190690"},
            "WhatsApp": {"type": "whatsapp", "link": "http://+573148210435"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/teguio.viguias"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/teguio.viguias/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/TeGuio_Viguias"},
        },
    },
    "Patronato Nacional de la Infancia (PANI) – Línea 1147": {
        "region": "Costa Rica",
        "page": "https://childhelplineinternational.org/costa-rica-patronato-nacional-de-la-infancia-pani-linea-1147/",
        "description": "The National Children’s Trust’s (PANI) Línea 1147 is a free hotline and confidential service, which is attended by psychologists from Monday to Friday, from 7:00 a.m. to 10:00 p.m., where minors can exercise their right to participate, express their ideas, emotions, opinions and denounce situations that violate their rights.",
        "contacts": {
            "Website": {"type": "website", "link": "https://pani.go.cr/"},
            "1147": {"type": "phone", "link": "tel:1147"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/PatronatoNacionaldelaInfancia"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/panicostarica/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/PANI_CR"},
        },
    },
    "Ayudo pa mucha i hoben 918": {
        "region": "Curaçao",
        "page": "https://childhelplineinternational.org/curacao-ayudo-pa-mucha-i-hoben-918/",
        "description": "Ayudo pa mucha i hoben 918 is free to contact via phone, chat, and forum. It is available for all children, young people and young adults on Curaçao up to and including 25 years old.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.918.cw"},
            "918": {"type": "phone", "link": "tel:918"},
            "Email": {"type": "email", "link": "mailto:918@kinderbeschermingcuracao.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ayudopamuchaihoben918"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/918.cw/"},
        },
    },
    "Línea de ayuda Familiar CONTIGO": {
        "region": "Dominican Republic",
        "page": "https://childhelplineinternational.org/dominican-republic-linea-de-ayuda-familiar-contigo/",
        "description": "Línea de ayuda Familiar CONTIGO is made up of a team of mental health professionals who, with the sponsorship of UNICEF and USAID, plus the support of CODOPSI and the Institute of Mental Health and Telepsychology, offer emotional support to children and adolescents, as well as to the entire population, following the impact generated by the Coronavirus pandemic (COVID-19). It is available for children and adolescents in the Dominican Republic.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://lineafamiliar.do/?fbclid=IwAR32Upzp_MnlW-nqC1yhx0NSgARwp9LlcUKfEmwZLBQQC_5GbTBxluXUaS8",
            },
            "809-636-3507": {"type": "phone", "link": "tel:8096363507"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send?phone=18492584479&text=&source=&data=",
            },
            "Email": {"type": "email", "link": "mailto:linefamiliar.digital@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Linea-Familiar-RD-107128947691646/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/lineafamiliarrd/?hl=es-la"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCthdPh9p9f3bxk1wxMst_ag"},
        },
    },
    "Sweet Water Foundation Child Helpline": {
        "region": "Grenada",
        "page": "https://childhelplineinternational.org/grenada-sweet-water-foundation-child-helpline/",
        "description": "The Sweet Water Foundation is one of the few agencies in the Caribbean with a sole focus on child sexual abuse. It operates a free, online, confidential, and anonymous service for talking about sex, with a focus on stopping sexual practices which may harm a child. The child helpline is a confidential, anonymous counselling service. Adults and children are equally encouraged to call.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.sweetwaterfoundation.ca"},
            "473-800-4444": {"type": "phone", "link": "tel:4738004444"},
            "Email": {"type": "email", "link": "mailto:info@sweetwaterfoundation.ca"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/Sweet-Water-Foundation-Intl-1448075422110012/",
            },
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/MySistersKeeper_SWF/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/SweetWaterIntl"},
        },
    },
    "SafeSpot": {
        "region": "Jamaica",
        "page": "https://childhelplineinternational.org/jamaica-safespot/",
        "description": "SafeSpot is a FREE and confidential counselling service for Jamaican children and teens to reach out for help all day, everyday.",
        "contacts": {
            "Website": {"type": "website", "link": "https://safespotja.com/"},
            "888-SAFE-SPOT": {"type": "phone", "link": "tel:8887233776"},
            "WhatsApp": {"type": "whatsapp", "link": "https://wa.me/18764395199"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SafeSpotJamaica"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/safespotja/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ocajamaica1"},
            "Snapchat": {"type": "snapchat", "link": "https://www.snapchat.com/add/safespotja"},
        },
    },
    "Línea 133": {
        "region": "Nicaragua",
        "page": "https://childhelplineinternational.org/nicaragua-linea-133/",
        "description": "Operated by The Ministry of the Family, the institution of the Citizen Power that promotes, prevents and accompanies actions for the restitution of the rights of children, adolescents, older adults and families in the community.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.mifamilia.gob.ni/"},
            "133": {"type": "phone", "link": "tel:133"},
            "2222-4444": {"type": "phone", "link": "tel:2222-4444"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send/?phone=50583525121&text&app_absent=0",
            },
            "Email": {"type": "email", "link": "mailto:comunicacionmifam@mifamilia.gob.ni"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/mifamnicaragua"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/mifamnicaragua/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/MifamNicaragua"},
            "Youtube": {
                "type": "youtube",
                "link": "https://www.youtube.com/channel/UCxhGXSa7IxfnrbMi67n1z1g?view_as=subscriber",
            },
        },
    },
    "Fono Ayuda Línea 147": {
        "region": "Paraguay",
        "page": "https://childhelplineinternational.org/paraguay-fono-ayuda-linea-147/",
        "description": "147 Fono Ayuda is a telephone assistance and guidance service for situations involving children and adolescents, specializing in providing psychological, social and legal guidance in cases of violations of rights.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.minna.gov.py/pagina/1224-fono-ayuda-147.html"},
            "147": {"type": "phone", "link": "tel:147"},
            "+595 21 204 749": {"type": "phone", "link": "tel:+595%2021%20204%20749"},
            "Email": {"type": "email", "link": "mailto:comunicacion@minna.gov.py"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/paraguayminna/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/MINNAParaguay"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCJWfTu4z1TU_LxX3t37ldIw"},
        },
    },
    "Télefono Anar": {
        "region": "Peru",
        "page": "https://childhelplineinternational.org/peru-telefono-anar/",
        "description": "The ANAR Foundation guides children and adolescents from an interdisciplinary approach on the life situations that affect them, empowering them in their rights and linking them to the protection system when necessary.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.anarperu.org/"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/fundacionanarperu"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/anarperu"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/anarperu"},
        },
    },
    "KJT Mi Lijn": {
        "region": "Suriname",
        "page": "https://childhelplineinternational.org/suriname-kjt-mi-lijn/",
        "description": "KJT Mi Lijn is a helpline where children, young people, adolescents and victims of domestic and gender-based violence can talk about their problems in complete confidence and receive appropriate help.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.bel123.org/"},
            "597-123": {"type": "phone", "link": "tel:597-123"},
            " +597 850-6907": {"type": "phone", "link": "tel:%20+597850-6907"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send/?phone=5978507038&text&app_absent=0",
            },
            "Email": {"type": "email", "link": "mailto:info@bel123.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/bel123.org"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/bel123org/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCPvRvR96A21y0qMrnyOHJ6w"},
        },
    },
    "ChildLine Trinidad & Tobago": {
        "region": "Trinidad & Tobago",
        "page": "https://childhelplineinternational.org/trinidad-tobago-childline-trinidad-tobago/",
        "description": "ChildLine is a not-for-profit non-governmental organisation dedicated to the welfare and protection of children and young people up to age 25 in Trinidad and Tobago. Established in 2001, one of the main services of the organisation is a free, confidential telephone helpline which is available 24 hours a day, every day of the year.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childlinett.org/"},
            "131": {"type": "phone", "link": "tel:131"},
            "800-4321": {"type": "phone", "link": "tel:800-4321"},
            "Email": {"type": "email", "link": "http://communications@childlinett.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/TTChildLine"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childline_tt/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/childline_tt"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC2UBiTpfqT6O09A2zG69QCg"},
        },
    },
    "Línea Azul": {
        "region": "Uruguay",
        "page": "https://childhelplineinternational.org/uruguay-linea-azul/",
        "description": "La Línea Azul receives, through the number 0800 5050 and the INAU website, complaints from the community related to situations of violence and violation of rights experienced by children and adolescents in order to respond to them. Coordinates with other actors involved the interventions to be carried out according to the demands received, in order to give a first response to situations of violation of rights. In addition, it carries out and/or coordinates the actions that allow a diagnostic approach aimed at providing timely and effective responses.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://www.inau.gub.uy/content_page/item/512-linea-azul-denuncias",
            },
            "0800 5050": {"type": "phone", "link": "tel:08005050"},
            "Email": {"type": "email", "link": "mailto:lineaazul@inau.gub.uy"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/inauoficial"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/inau_oficial/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/INAU_Oficial"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UClwdJF8XifcEXJgybDHHQjA"},
        },
    },
    "2NDFLOOR Youth Helpline": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/usa-2ndfloor-youth-helpline/",
        "description": "2NDFLOOR is a confidential and anonymous helpline for New Jersey’s youth and young adults. We are here to help you find solutions to the problems that you face at home, at school or at play.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.2ndfloor.org/"},
            "888-222-2228": {"type": "phone", "link": "tel:888-222-2228"},
            "TTY": {"type": "phone", "link": "tel:732-264-1703"},
            "Email": {"type": "email", "link": "http://info@2ndfloor.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/2ndflooryouthhelpline"},
            "Instagram": {
                "type": "instragram",
                "link": "https://www.instagram.com/2ndflooryouthhelpline/https://www.instagram.com/2ndflooryouthhelpline/",
            },
            "Twitter": {"type": "twitter", "link": "https://twitter.com/2NDFloorNJ"},
        },
    },
    "Boys Town National Hotline": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/usa-boys-town-national-hotline/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.yourlifeyourvoice.org"},
            "1-800-448-3000": {"type": "phone", "link": "tel:1-800-448-3000"},
            "Text VOICE to 20121": {"type": "phone", "link": "tel:20121"},
            "Email": {"type": "email", "link": "http://yourlifeyourvoice@boystown.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/BoysTownHotline/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/boystown/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/BoysTown"},
        },
    },
    "Crisis Text Line": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/elementor-5111/",
        "description": "Crisis Text Line provides free, 24/7, high-quality text-based mental health support and crisis intervention by empowering a community of trained volunteers to support people in their moments of need. ",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.crisistextline.org/"},
            "TEXT 741741": {"type": "phone", "link": "tel:"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/crisistextline"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/crisistextline/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/CrisisTextLine"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/crisistextline/"},
        },
    },
    "National Child Abuse Hotline": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/usa-national-child-abuse-hotline/",
        "description": "Childhelp National Child Abuse Hotline serves children and adults nationwide and exists to meet the physical, emotional, educational, and spiritual needs of abused, neglected and at-risk children. Every child deserves to know that help is here. Whether you’re a youth in crisis, a parent in need of resources, or a concerned peer, call, text or chat with a counselor 24/7.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.childhelp.org/"},
            "1-800-4-A-CHILD": {"type": "phone", "link": "tel:18004224453"},
            "Email": {"type": "email", "link": "mailto:info@childhelp.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childhelp"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childhelp/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Childhelp"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/childhelporg"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/childhelp-inc-/?fbclid=IwAR0F7AqOHewHnqisyrZOAu8sphFSPwe80STvWm6BHtT2pPuDqWNTQzOopMg",
            },
        },
    },
    "Polaris": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/usa-polaris/",
        "description": "For more than a decade, Polaris has assisted thousands of victims and survivors through the U.S. National Human Trafficking Hotline, helped ensure countless traffickers were held accountable and built the largest known U.S. data set on actual trafficking experiences.",
        "contacts": {
            "Website": {"type": "website", "link": "http://polarisproject.org"},
            "1-888-373-7888 (TTY:711)": {"type": "phone", "link": "tel:1-888-373-7888"},
            "Text “BeFree” to 233733": {"type": "phone", "link": "tel:233733"},
            "Email": {"type": "email", "link": "mailto:info@polarisproject.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/polarisproject"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/polarisproject/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/polaris_project"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/polarisproject1"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/polaris-project/"},
        },
    },
    "Stop It Now!": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/usa-stop-it-now/",
        "description": "Stop It Now! prevents the sexual abuse of children by mobilizing adults, families and communities to take actions that protect children before they are harmed. They provide support, information and resources to keep children safe and create healthier communities.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.stopitnow.org/"},
            "1.888.PREVENT": {"type": "phone", "link": "tel:18887738368"},
            "Email": {"type": "email", "link": "mailto:info@stopitnow.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/StopItNow"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/stopitnow_us/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/stopitnow"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/wecanstopitnow"},
        },
    },
    "The Trevor Project": {
        "region": "USA",
        "page": "https://childhelplineinternational.org/the-trevor-project/",
        "description": "The Trevor Project provides information & support to LGBTQ young people 24 / 7, all year round.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.thetrevorproject.org"},
            "866-488-7386": {"type": "phone", "link": "tel:866-488-7386"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/TheTrevorProject"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/trevorproject/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/trevorproject"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/thetrevorproject"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/the-trevor-project"},
        },
    },
    "Kids Helpline (Australia)": {
        "region": "Australia",
        "page": "https://childhelplineinternational.org/australia-kids-helpline-australia/",
        "description": "Kids Helpline is Australia’s only free (even from a mobile), confidential 24/7 online and phone counselling service for young people aged 5 to 25. Qualified counsellors at Kids Helpline are available via WebChat, phone or email anytime and for any reason.",
        "contacts": {
            "Website": {"type": "website", "link": "https://kidshelpline.com.au/"},
            "1 800 55 1800": {"type": "phone", "link": "tel:1800551800"},
            "Email": {"type": "email", "link": "mailto:https://kidshelpline.com.au/get-help/email-counselling/"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/KidsHelpline/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kidshelplineau/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/kidshelplineau"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/kidshelpline101"},
        },
    },
    "Bangladesh Child Helpline 1098": {
        "region": "Bangladesh",
        "page": "https://childhelplineinternational.org/bangladesh-bangladesh-child-helpline-1098/",
        "description": "Child Helpline 1098 is a service that extends a helping hand to children from all kinds of influences or stress, while protecting all kinds of privacy. The helpline can be reached by dialling 1098 from any part of Bangladesh at any time of day, including public and weekly holidays.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.dss.gov.bd/"},
            "1098": {"type": "phone", "link": "tel:1098"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childhelpline1098/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/dss_bd"},
        },
    },
    "Child Helpline Bhutan": {
        "region": "Bhutan",
        "page": "https://childhelplineinternational.org/bhutan-child-helpline-bhutan/",
        "description": "The Toll Free Helpline for Women and Children in difficult circumstances will be operational from 9 am to 5 pm during weekdays. Voice messages can be send to NCWC during off hours and follow up will be made in the following days.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.ncwc.gov.bt/"},
            "1098": {"type": "phone", "link": "tel:1098"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/NationalCommissionforWomenandChildren/"},
            "YouTube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCbA_f5XGWKuZSdIDmGhPIFg"},
        },
    },
    "Talian ANAK 121": {
        "region": "Brunei Darussalam",
        "page": "https://childhelplineinternational.org/brunei-darussalam-talian-anak-121/",
        "description": "Talian ANAK 121 provides an efficient communication channel for people to contact JAPEM relating to cases of abuse, neglect, protection, exploitation, counseling, family problems and more.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.japem.gov.bn/"},
            "121": {"type": "phone", "link": "tel:121"},
            "Email": {"type": "email", "link": "mailto:taliananak121@japem.gov.bn"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/jabatanpembangunanmasyarakat.japem"},
            "Instagram": {
                "type": "instragram",
                "link": "https://www.instagram.com/Japembrunei/?fbclid=IwAR2-AoHudlzvvMFeQ2OFzvfmNf08NA46dMic0Tx2Vnt6Glw9lUun5C140Xo",
            },
            "Twitter": {
                "type": "twitter",
                "link": "https://twitter.com/JAPEM_MCYS?fbclid=IwAR3UpyFX-WWAqmIcTj3hPk2ZrWPEuCCbcxl-e_aLSvr504YKNqttgPBG1mQ",
            },
        },
    },
    "Child Helpline Cambodia": {
        "region": "Cambodia",
        "page": "https://childhelplineinternational.org/cambodia-child-helpline-cambodia/",
        "description": "Child Helpline Cambodia provides free, 24 hour phone counseling, information, referral and follow-up services for children and youth up to 25 years old in Cambodia. It allows children and young people to reach out when they need it, in real time and speak directly with someone in a safe and confidential environment via the free 1280 helpline, as well as via their website and Facebook page.",
        "contacts": {
            "Website": {"type": "website", "link": "http://childhelplinecambodia.org"},
            "1280": {"type": "phone", "link": "tel:1280"},
            "Email": {"type": "email", "link": "mailto:cambodiachildhelpline@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/chc1280/?fref=ts"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childhelplinecambodia/"},
        },
    },
    "Child Emergency Hotline": {
        "region": "China",
        "page": "https://childhelplineinternational.org/china-child-emergency-hotline/",
        "contacts": {
            "116 111": {"type": "phone", "link": "tel:"},
            "Email": {"type": "email", "link": "https://orgchil-jicorica.savviihq.com/?p=2511"},
        },
    },
    "Child Helpline Fiji": {
        "region": "Fiji",
        "page": "https://childhelplineinternational.org/fiji-child-helpline-fiji/",
        "description": "Operated under the Ministry of Women, Children and Poverty Alleviation, the Child Helpline 1325 is available for children 24 hours a day and 7 days a week. 1325 is a toll-free number that is manned by professional counsellors who are ready to listen to children’s problems and guide you towards getting the help they need and deserve.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "http://msp.org.fj/?fbclid=IwAR1TUL6hie4_zG__GypYiKQe6rc_Lnultew8CyAlzXEQdxrWbJYQ7rfk7iY",
            },
            "1325": {"type": "phone", "link": "tel:1325"},
            "Email": {"type": "email", "link": "mailto:help@msp.org.fj"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ChildHelplineFiji/"},
        },
    },
    "Parent-Child Support Line": {
        "region": "Hong Kong (China)",
        "page": "https://childhelplineinternational.org/hong-kong-china-parent-child-support-line/",
        "description": "Operated by Action Against Abuse (ACA), the Parent-Child Support Line provides service where parents, children, professionals and the public can call the hotline 2755 1122, or go to the ACA centre to report suspected child abuse cases or ask questions about any issues they are facing. It is also a support and hotline for children to express their voices and opinions. The personal data and case content of the data provider/reporter are kept strictly confidential.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.aca.org.hk/index.php#.YmRbANNBw-Q"},
            "116 111": {"type": "phone", "link": "tel:"},
            "Email": {"type": "email", "link": "mailto:aca@aca.org.hk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ACAHK"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/againstchildabusehk/"},
            "Twitter": {
                "type": "twitter",
                "link": "https://twitter.com/acahk1979?fbclid=IwAR1yhVK2uky1_zsBavwOd_PtCFTbVZy3NbRb_S_C81bGkj0i2PzJXIP4d2M",
            },
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/AgainstChildAbuseHK"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/acahk/?fbclid=IwAR1oZJte9EQUjNLc4rY27fiEm-aGWkE4Jla5tJE4V84BltZtAdKQpOWBFVE",
            },
        },
    },
    "Childline India": {
        "region": "India",
        "page": "https://childhelplineinternational.org/india-childline-india/",
        "description": "Childline 1098 is a phone number that spells hope for millions of children across India. It is a 24-hour a day, 365 days a year, free, emergency phone service for children in need of aid and assistance. They not only respond to the emergency needs of children but also link them to relevant services for their long-term care and rehabilitation. ",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childlineindia.org.in"},
            "1098": {"type": "phone", "link": "tel:1098"},
            "Email": {"type": "email", "link": "mailto:dial1098@childlineindia.org.in"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/pages/Childline-India-Foundation/137070779678465",
            },
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childlineindia1098/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/CHILDLINE1098"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/childline-india-foundation/"},
        },
    },
    "TePSA – Telepon Pelayanan Sosial Anak": {
        "region": "Indonesia",
        "page": "https://childhelplineinternational.org/indonesia-tepsa-telepon-pelayanan-sosial-anak/",
        "description": "Telepon Pelayanan Sosial Anak (TePSA) is a telephone service for children, which functions to provide telecounseling services for children who have problems, complaints, including services for children who have emergency problems and provide referrals if needed. TePSA is a service created by the Ministry of Social Affairs of the Republic of Indonesia.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.facebook.com/TePSAKEMENSOS"},
            "1500771": {"type": "phone", "link": "tel:1098"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/TePSAKEMENSOS"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/tepsakemensos"},
        },
    },
    "Childline Japan": {
        "region": "Japan",
        "page": "https://childhelplineinternational.org/japan-childline-japan/",
        "description": "ChildLine is a free telephone service for under 18 years old who want to talk with somebody about anything they want. Calls are anonymous, free and the volunteer adults called “receivers” listen to the story and work with the child to work through any problems they want to talk about.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://childline.or.jp/?fbclid=IwAR1SZxgm0xeG3pzteltaAmlCK68b5hbNWUlBQBoitLnTf937z33uoxVpyZY",
            },
            "0120-99-7777": {"type": "phone", "link": "tel:0120997777"},
            "Email": {"type": "email", "link": "mailto:info@childline.or.jp"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childlinejapan"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/childlinejapan"},
        },
    },
    "Telefon 150": {
        "region": "Kazakhstan",
        "page": "https://childhelplineinternational.org/kazakhstan-telefon-150/",
        "description": "Telefon 150 is there for children when they are having a hard time and tries to understand them and help them. The helpline completely anonymous and confidential and any concern is respected – what worries the child becomes important for the consultant at the moment of the conversation.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.telefon150.kz/"},
            "150": {"type": "phone", "link": "tel:150"},
            "WhatsApp": {
                "type": "whatsapp",
                "link": "https://api.whatsapp.com/send?phone=/77081060810&text=%D0%97%D0%B4%D1%80%D0%B0%D0%B2%D1%81%D1%82%D0%B2%D1%83%D0%B9%D1%82%D0%B5...",
            },
            "Email": {"type": "email", "link": "mailto:soyuzkz@rambler.ru"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SouzKrizisnyhCentrovKZ/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/telefon150kz/"},
        },
    },
    "The Centre": {
        "region": "Kyrgyzstan",
        "page": "https://childhelplineinternational.org/kyrgyzstan-the-centre/",
        "description": "The Child Rights Defenders League operates the Helpline for Children, which aims to protect and promote the rights and freedoms of children.",
        "contacts": {
            "Website": {"type": "website", "link": "http://crdl.kg/"},
            "150 00": {"type": "phone", "link": "tel:15000"},
        },
    },
    "Vientiane Youthline": {
        "region": "Laos",
        "page": "https://childhelplineinternational.org/laos-vientiane-youthline/",
        "description": "Operated by the Vientiane Women and Youth Centre for Health and Development",
        "contacts": {"1361 (female); 1371 (male)": {"type": "phone", "link": "tel:"}},
    },
    "Child Help Line 1412": {
        "region": "Maldives",
        "page": "https://childhelplineinternational.org/maldives-child-help-line-1412/",
        "description": "Operated by the Ministry of Gender, Family and Social Services and Child and Family Protection Service, Child Helpline 1412 provides a service where children can reach out for professional help.",
        "contacts": {
            "Website": {"type": "website", "link": "https://gender.gov.mv/"},
            "1412": {"type": "phone", "link": "tel:1412"},
            "Email": {"type": "email", "link": "mailto:info@gender.gov.mv"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/MoGFSSmv"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/genderministry/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Min_Gender?ref_src=twsrc%5Etfw"},
        },
    },
    "Child Helpline 108": {
        "region": "Mongolia",
        "page": "https://childhelplineinternational.org/mongolia-child-helpline-108/",
        "description": "Mongolia’s first ever nationwide, toll free, 24/7 Child Helpline 108 was launched in 2014. Children need only dial 108 on any phone to be directly linked with an operator standing by on the other end for assistance, advice and support.",
        "contacts": {
            "Website": {"type": "website", "link": "https://108.mn/"},
            "108": {"type": "phone", "link": "tel:108"},
            "Email": {"type": "email", "link": "mailto:huuhdiinutas@yahoo.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/108.mn"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC3rTtL_jr-8GEmliZk30D3Q"},
        },
    },
    "Child Helpline Nepal 1098": {
        "region": "Nepal",
        "page": "https://childhelplineinternational.org/nepal-child-helpline-nepal-1098/",
        "description": "1098 is the Child Helpline number in Nepal and is operated by the Child Workers Concerned Centre in Nepal (CWIN). CWIN runs six child helplines and a number of support homes and centres based throughout Nepal. The child helplines are located respectively in Kathmandu, Biratnagar, Hetauda, Nepalgunj, Pokhara and Dhangadhi and offer counselling, referrals, support and advice,",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.cwin.org.np/"},
            "1098": {"type": "phone", "link": "tel:1098"},
            "Email": {"type": "email", "link": "mailto:cwinnepal1987@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/cwin.org.np/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/CWINNepal"},
        },
    },
    "0800 What’s Up?": {
        "region": "New Zealand",
        "page": "https://childhelplineinternational.org/new-zealand-0800-whats-up/",
        "description": "0800 Whats Up is a national helpline for tamariki and rangatahi in Aotearoa. Children and teenagers can either call for free or chat online with one of our counsellors.",
        "contacts": {
            "whatsup.co.nz": {"type": "website", "link": "http://www.whatsup.co.nz/"},
            " +64 800 942 8787": {"type": "phone", "link": "tel:%20+64%20800%20942%208787"},
            "Email": {"type": "email", "link": "mailto:whatsup@barnardos.org.nz"},
            "Facebook": {"type": "facebook", "link": "http://www.facebook.com/0800Whatsup"},
            "Instagram": {"type": "instragram", "link": "http://www.instagram.com/0800whatsup"},
        },
    },
    "Youthline": {
        "region": "New Zealand",
        "page": "https://childhelplineinternational.org/new-zealand-youthline/",
        "description": "Youthline offers a free 24/7 Helpline service (text, phone, webchat & email), free face-to-face counselling services, youth mentoring, programmes in schools and communities to help people grow and develop.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.youthline.co.nz"},
            "0800 376633": {"type": "phone", "link": "tel:0800%20376633"},
            "Text 234": {"type": "comment", "link": "sms:234"},
            "Email": {"type": "email", "link": "mailto:talk@youthline.co.nz"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Youthline.Changing.Lives/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/youthlinenz/?hl=en"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Youthline"},
        },
    },
    "Madadgaar National Helpline": {
        "region": "Pakistan",
        "page": "https://childhelplineinternational.org/pakistan-madadgaar-national-helpline/",
        "description": "The Madadgaar National Helpline is a toll free helpline number, accessible 24/7 for children experiencing violence and abuse. The helpline acts as a portal and guide for survivors of abuse to a wide array of possibly unknown organisations out there who are willing to help them get justice, shelter and a way to start their lives anew.",
        "contacts": {
            "1098": {"type": "phone", "link": "tel:1098"},
            "Email": {"type": "email", "link": "mailto:madadgaar@cyber.net.pk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/madadgaar1098helpline/?fref=ts"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/madadgaar1098helpline/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/madadgaar1"},
        },
    },
    "1-Tok Kaunselin Helpim Lain": {
        "region": "Papua New Guinea",
        "page": "https://childhelplineinternational.org/papua-new-guinea-1-tok-kaunselin-helpim-lain/",
        "description": "1-Tok Kaunselin Helpim Lain is a toll –free confidential phone counselling service providing information and support for anyone experiencing family and sexual violence in Papua New Guinea.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://www.childfund.org.au/media-news/1-tok-kaunselin-helpim-lain-launches-24-hour-service-and-new-facebook-page/",
            },
            "+675 7150 8000": {"type": "phone", "link": "tel:+67571508000"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/1TokHelpimLain/"},
        },
    },
    "Bantay Bata 163": {
        "region": "Philippines",
        "page": "https://childhelplineinternational.org/philippines-bantay-bata-163/",
        "description": "Bantay Bata 163 is a child welfare program launched in 1997 to protect disadvantaged and at-risk children through a nationwide network of social services. Dialing 1-6-3 means hope for Filipino children and their families suffering in silence due to child abuse and the helpline also provides community outreach and medical and dental services.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.bantaybata163.com"},
            "163": {"type": "phone", "link": "tel:163"},
            "Email": {"type": "email", "link": "mailto:foundation@abs-cbnfoundation.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/abscbnfoundationkapamilya"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/abscbnfoundation/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/BantayBata163"},
        },
    },
    "Tinkle Friend Helpline": {
        "region": "Singapore",
        "page": "https://childhelplineinternational.org/singapore-tinkle-friend-helpline/",
        "description": "Tinkle Friend is a national toll-free helpline (1800 2744 788) and chatline for all primary-school-aged children in Singapore, run by Singapore Children’s Society. Tinkle Friend provides support, advice, and information to lonely and distressed children, especially in situations when their parents or main caregivers are unavailable.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.tinklefriend.sg/"},
            "1800 2744 788": {"type": "phone", "link": "tel:1800%202744%20788"},
            "Email": {"type": "email", "link": "mailto:info@childrensociety.org.sg"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SingaporeChildrensSociety/?fref=ts"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/SgChildrenSoc"},
        },
    },
    "Childline Sri Lanka 1929": {
        "region": "Sri Lanka",
        "page": "https://childhelplineinternational.org/sri-lanka-childline-sri-lanka-1929/",
        "description": "Operated by the National Child Protection Authority, 1929 can be contacted free of charge through any telecom provider, from anywhere in the country, at any time of the day, any day of the week, in Sinhala / Tamil / English languages.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.childprotection.gov.lk/"},
            "1929": {"type": "phone", "link": "tel:1929"},
            "Email": {"type": "email", "link": "mailto:ncpa@childprotection.gov.lk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/NCPASriLanka/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ChildLanka?t=xLYQm...54X6w&s=08"},
        },
    },
    "Don Bosco Lama Sarana": {
        "region": "Sri Lanka",
        "page": "https://childhelplineinternational.org/sri-lanka-don-bosco-lama-sarana/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.donbosco.lk/"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/donbosco.srilanka/"},
        },
    },
    "113 Protection Hotline": {
        "region": "Taiwan",
        "page": "https://childhelplineinternational.org/taiwan-113-protection-hotline/",
        "description": "113 Protection Hotline",
        "contacts": {
            "worldvision.org.tw": {"type": "website", "link": "https://www.worldvision.org.tw/"},
            "113": {"type": "phone", "link": "tel:113"},
            "+886 2 8195 3005": {"type": "phone", "link": "tel:+886281953005"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/WorldVisionTW/"},
            "Instagram": {
                "type": "instragram",
                "link": "https://www.instagram.com/worldvisiontaiwan/?fbclid=IwAR0hhpBJkUBzgc-m3JhpssZMquwnksHoP_dyGMFIN4I88JadV5Z6e2IFc5o",
            },
            "YouTube": {"type": "youtube", "link": "https://www.youtube.com/user/worldvisiontaiwan"},
            "worldvisiontw": {"type": "line", "link": "https://page.line.me/ixk2481x"},
        },
    },
    "Childline Thailand – Saidek 1387": {
        "region": "Thailand",
        "page": "https://childhelplineinternational.org/thailand-childline-thailand-saidek-1387/",
        "description": "Childline provides its services for any child under the age of 18. The foundation works with various government and NGO stakeholders to safeguard the rights of every child as outlined by the United Nations’ Convention on the Rights of a Child (CRC). Staff in the call center are ready to take phone calls and respond to online messages 24 hours a day, 365 day a year – just like any other emergency support service.",
        "contacts": {
            "Website": {"type": "website", "link": "http://childlinethailand.org/"},
            "1387": {"type": "phone", "link": "tel:1387"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childlinethailand"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/saidek1387/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/saidek1387"},
        },
    },
    "Children and Family Support Association of Uzbekistan": {
        "region": "Uzbekistan",
        "page": "https://childhelplineinternational.org/uzbekistan-children-and-family-support-association-of-uzbekistan/",
        "description": "A child helpline is under development by the Children and Family Support Association of Uzbekistan.",
        "contacts": {},
    },
    "Vanuatu Youth Toll-Free Helpline": {
        "region": "Vanuatu",
        "page": "https://childhelplineinternational.org/vanuatu-vanuatu-youth-toll-free-helpline/",
        "description": "Operated by the Vanuatu Family Health Association (VFHA), the Youth Toll-free HELPLINE 087777 is a confidential telephone and referral service, connecting professional expertise to communities across Vanuatu.",
        "contacts": {
            "Website": {"type": "website", "link": "https://vfha15.wordpress.com/"},
            "087777": {"type": "phone", "link": "tel:087777"},
        },
    },
    "National Hotline for Child Protection 111": {
        "region": "Vietnam",
        "page": "https://childhelplineinternational.org/vietnam-national-hotline-for-child-protection-111/",
        "description": "The Vietnamese National Hotline for Child Protection is run by the Department of Child Affairs, part of the Ministry of Labour, Invalids and Social Affairs. While the hotline deals primarily with information, reports and denunciations on risks and acts of child abuse, it also provides counselling to children.",
        "contacts": {
            "Website": {"type": "website", "link": "http://tongdai111.vn/"},
            "111": {"type": "phone", "link": "tel:111"},
        },
    },
    "ALO 116 111": {
        "region": "Albania",
        "page": "https://childhelplineinternational.org/alo-116-111/",
        "description": "The National Telephone Line for Children (ALO 116) is a free counseling and referral service for children. This service communicates with children through two numbers:",
        "contacts": {
            "Website": {"type": "website", "link": "mailto:alo116@alo116.al"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "https://orgchil-jicorica.savviihq.com/?p=2511"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ALO116"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/linja_e_keshillimit_per_femije/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/alo116albania"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCBWR-J810zmZgQ67QyAjbGw"},
        },
    },
    "FAR Child Protection Hotline & Helpline": {
        "region": "Armenia",
        "page": "https://childhelplineinternational.org/armenia-far-child-protection-hotline-helpline/",
        "description": "The FAR Children’s Center transforms young lives through crisis intervention, critical short-term rehabilitation and stabilization to those who are victims of some of the most horrible predicaments including abuse, abandonment and neglect, and behavioral, emotional and psychological problems. The Center is a full-service facility, which offers access to shelter, medical care, counseling and legal assistance. It provides sources of educational and psychosocial support, life skills training, and guidance for family members when safe reunification is possible.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.farusa.org/"},
            "0800 61 111": {"type": "phone", "link": "tel:080061111"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/farusa"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/far.usa/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/farusa"},
        },
    },
    "147 Rat Auf Draht": {
        "region": "Austria",
        "page": "https://childhelplineinternational.org/austria-147-rat-auf-draht/",
        "description": "147 Rat auf Draht is the Austrian emergency number for children and young people. The number can be reached anonymously and free of charge around the clock.",
        "contacts": {
            "116 111": {"type": "phone", "link": "tel:"},
            "Email": {"type": "email", "link": "mailto:147@rataufdraht.at"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/rataufdraht"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/147rataufdraht/"},
            "YouTube": {"type": "youtube", "link": "https://www.youtube.com/user/Helpline147"},
        },
    },
    "Azerbaijan Child Helpline": {
        "region": "Azerbaijan",
        "page": "https://childhelplineinternational.org/azerbaijan-azerbaijan-child-helpline/",
        "description": "The Azerbaijan Child Helpline has been operating since 2010. It was created with the support of the Ministry of Education, the Ministry of Labor and Social Protection, UNICEF, World Vision, Save the children and Azercell.",
        "contacts": {
            "Website": {"type": "website", "link": "https://childhelpline.az/index.php/az/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:reliablefuturengo@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ReliableFutureNGO/"},
            "Instagram": {"type": "instragram", "link": ""},
        },
    },
    "AWEL": {
        "region": "Belgium",
        "page": "https://childhelplineinternational.org/belgium-awel/",
        "description": "AWEL listens to all children and young people with a question, a story and/or a problem. AWEL works completely anonymously . This means that only the caller and AWEL are aware of the contact. Moreover, a conversation with Awel is completely free.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.awel.be/"},
            "102": {"type": "phone", "link": "tel:102"},
            "Email": {"type": "email", "link": "mailto:info@awel.be"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/awelvzw/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/awel.be_/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/awel_vzw"},
        },
    },
    "Plavi Telefon": {
        "region": "Bosnia & Herzegovina",
        "page": "https://childhelplineinternational.org/bosnia-herzegovina-plavi-telefon/",
        "description": "Plavi Telefon is a toll-free confidential and anonymous counseling line for children, young people and adults who can contact the helpline if they have a problem and want to share how you feel and what is bothering them.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.plavitelefon.ba/"},
            "080 05 03 05": {"type": "phone", "link": "tel:080050305"},
            "Email": {"type": "email", "link": "mailto:info@novageneracija.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/PlaviTelefonBiH/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/plavi.telefon/"},
        },
    },
    "National Telephone Line for Children 116 111": {
        "region": "Bulgaria",
        "page": "https://childhelplineinternational.org/bulgaria-national-telephone-line-for-children-116-111/",
        "description": "The National Telephone Line for Children 116 111 is managed and administered by the State Agency for Child Protection with the aim of supporting all children and their families in Bulgaria. The operators who answer the calls are trained psychologists who 24 hours a day, 7 days a week, anonymously and completely free of charge, are ready to listen, support, consult and guide the callers on all issues that concern them.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.116111.bg/"},
            "116111": {"type": "phone", "link": "tel:116111"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/sacp.government.bg"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/sacp_bulgaria/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCIUOyilakRTJNCHnI-_oj4w"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/state-agency-for-child-protection/",
            },
        },
    },
    "Hrabri Telefon": {
        "region": "Croatia",
        "page": "https://childhelplineinternational.org/hrabritelefon/",
        "description": "Hrabri Telefon is a non-profit non-governmental organization founded with the aim of preventing abuse, neglect and unacceptable behavior of children and youth, and providing direct help and support to abused and neglected children and their families.",
        "contacts": {
            "hrabritelefon.hr": {"type": "website", "link": "http://hrabritelefon.hr"},
            "116 111": {"type": "phone", "link": "tel:116%20111"},
            "0800 0800": {"type": "phone", "link": "tel:0800%200800"},
            "Email": {"type": "email", "link": "mailto:savjet@hrabritelefon.hr"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/HrabriTelefon/"},
            "Viber": {"type": "viber", "link": "http://bit.ly/Hrabri-Telefon"},
        },
    },
    "Call 116111 Cyprus": {
        "region": "Cyprus",
        "page": "https://childhelplineinternational.org/cyprus-call-116111-cyprus/",
        "description": "“Hope For Children” CRC Policy Center is an International Humanitarian and Independent Organization, based in Nicosia, Cyprus. Our Organization was established on the basis of the standards and principles of the United Nations Convention on the Rights of the Child and the Law of the European Union.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.uncrcpc.org.cy/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:info@uncrcpc.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Hopeforchildren.crcpolicycenter"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/hopeforchildrencrcpolicycenter/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/infouncrc"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/TheOfficeforchildren"},
        },
    },
    "Linka Bezpečí": {
        "region": "Czechia",
        "page": "https://childhelplineinternational.org/czechia-linka-bezpeci/",
        "description": "Linka Bezpečí is for children and students under the age of 25 who have issues or worries that they cannot or cannot handle on their own. Children and young people can turn to the Safety Line for help and advice by phone, chat or e-mail.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.linkabezpeci.cz/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:pomoc@linkabezpeci.cz"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Linkabezpeci"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/linka_bezpeci/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Linka_bezpeci"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/SdruzeniLinkaBezpeci"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/safety-line-association-linka-bezpe-/?originalSubdomain=nl",
            },
        },
    },
    "BørneTelefonen": {
        "region": "Denmark",
        "page": "https://childhelplineinternational.org/denmark-bornetelefonen/",
        "description": "BørneTelefonen is YOUR line for advice, comfort or just an adult who has time to listen.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://bornsvilkar.dk/?fbclid=IwAR3L3G9-wLiF85t13AbPxA4Xq7Wdws7DGXobBrh3XRwVB9UdX6neHCOw3rQ",
            },
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:%20bv@bornsvilkar.dk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/boernsvilkaar"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/bornsvilkar/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/bornsvilkar"},
        },
    },
    "Lapsemure": {
        "region": "Estonia",
        "page": "https://childhelplineinternational.org/estonia-lapsemure/",
        "description": "Lapsemure is an online forum hosted by the Estonian Mental Health Society.",
        "contacts": {"Website": {"type": "website", "link": "http://www.lapsemure.ee/forum_est/"}},
    },
    "Lasten ja Nuorten Puhelin ja Netti – Child and Youth Phone": {
        "region": "Finland",
        "page": "https://childhelplineinternational.org/finland-lasten-ja-nuorten-puhelin-ja-netti-child-and-youth-phone/",
        "description": "MLL’s children’s and young people’s telephone provides the ability for children to call, write letters or online chat about any issues they might be having. Conversations are answered by confidential, volunteer adults who have time to listen. Children can contact the helpline anonymously every day of the year for any matter.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.mll.fi/nuortennetti/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "WhatsApp": {"type": "whatsapp", "link": ""},
            "Email": {
                "type": "email",
                "link": "mailto:?subject=Lasten%20ja%20nuorten%20puhelin&body=https://www.nuortennetti.fi/apua-ja-tukea/lasten-ja-nuorten-puhelin/",
            },
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/MLLverkkarit/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/mll_nuortennetti/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/MLL_fi"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/MLLnuortennetti"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/mannerheim-league-for-child-welfare",
            },
        },
    },
    "119 – Allô Enfance en Danger": {
        "region": "France",
        "page": "https://childhelplineinternational.org/france-119-allo-enfance-en-danger/",
        "description": "119 – Allô Enfance en Dangerwas established in 1989. ince 1997, they have been using he 119 number. The child helpline is funded by the State and Departments.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.allo119.gouv.fr/"},
            "119": {"type": "phone", "link": "tel:119"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/119alloenfanceendanger/"},
        },
    },
    "Kinder- und Jugendtelefon": {
        "region": "Germany",
        "page": "https://childhelplineinternational.org/germany-kinder-und-jugendtelefon/",
        "description": "Nummer gegen Kummer is the umbrella organization of the largest free telephone counseling service for children, young people and parents in Germany.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.nummergegenkummer.de/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:info@nummergegenkummer.de"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ngk.dachverband"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/nummergegenkummer_e.v/"},
        },
    },
    "The Smile of the Child": {
        "region": "Greece",
        "page": "https://childhelplineinternational.org/greece-the-smile-of-the-child/",
        "description": "The Smile of the Child’s helpline is available to every child and adult to provide support in matters that concern them. Calls to the child helpline are free from landline and mobile phones. The child helpline receiving anonymous and anonymous reports for children at risk (abuse, trafficking, unaccompanied children), activates procedures for the immediate provision of protection of children at risk (on-the-spot intervention), provides directions on each topic and links contacts to other services and other interventions.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.hamogelo.gr/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "1056": {"type": "phone", "link": "tel:1056"},
            "Email": {"type": "email", "link": "mailto:info@hamogelo.gr"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/hamogelo.org/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/hamogelo/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/hamogelo"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/---the-smile-of-the-child"},
        },
    },
    "Together for Children 11525 Helpline": {
        "region": "Greece",
        "page": "https://childhelplineinternational.org/greece-together-for-children-11525-helpline/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.mazigiatopaidi.gr/"},
            "115 25": {"type": "phone", "link": "tel:11525"},
            "Email": {"type": "email", "link": "mailto:info@mazigiatopaidi.gr"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/mazigiatopaidi"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/mazigiatopaidi/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/mazigiatopaidi"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCYZ4tA4Qgn9SFdFYVmKAZAw"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/together-for-children-ngo-mazi-gia-to-paidi-/",
            },
        },
    },
    "Kék Vonal": {
        "region": "Hungary",
        "page": "https://childhelplineinternational.org/hungary-lelkisegely-vonal/",
        "description": "Kék Vonal was created for children, teenagers and young adults, so that they always have someone to turn to! Their trained caregivers are available on the toll-free helpline at 116111, 24 hours a day.",
        "contacts": {
            "Website": {"type": "website", "link": "https://kek-vonal.hu/igy-segitunk/a-116-111-segelyvonalrol/"},
            "116111 (Hungarian)": {"type": "phone", "link": "tel:116111"},
            "+36 80 984 590 (Ukrainian/Russian)": {"type": "phone", "link": "tel:+36%2080%20984%20590"},
            "Email (Hungarian)": {"type": "email", "link": "mailto:info@kek-vonal.hu"},
            "Email (Ukrainian/Russian)": {"type": "email", "link": "mailto:ukraine@kek-vonal.hu.%20"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/kekvonal/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kekvonal/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/@kekvonalgyermekkrizisalapi8382"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/kekvonal/?originalSubdomain=hu"},
            "TikTok": {"type": "tiktok", "link": "https://www.tiktok.com/@kekvonal116111"},
        },
    },
    "Red Cross Helpline 1717 – Hjálparsíminn 1717": {
        "region": "Iceland",
        "page": "https://childhelplineinternational.org/iceland-red-cross-helpline-1717-hjalparsiminn-1717/",
        "description": "Red Cross Helpline is always open, free, confidential and anonymous and volunteers provide all those who contact with active listening, psychological support and information about the resources available in Iceland.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.raudikrossinn.is/"},
            "1717": {"type": "phone", "link": "tel:1717"},
            "Email": {"type": "email", "link": "mailto:info@redcross.is"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/raudikrossinn/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/raudikrossinn/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/raudikrossinn"},
        },
    },
    "ISPCC Childline": {
        "region": "Ireland",
        "page": "https://childhelplineinternational.org/ireland-ispcc-childline/",
        "description": "Childline is Ireland’s 24-hour national listening service for all children and young people (under the age of 18) in Ireland. It is private, confidential and non-judgemental and can be contacted for free from anywhere in Ireland.",
        "contacts": {
            "Website": {"type": "website", "link": "http://ispcc.ie/childline/"},
            "1800 66 66 66": {"type": "phone", "link": "tel:1800%2066%2066%2066"},
            "Text 50101": {"type": "comment", "link": "tel:%2050101"},
            "Email": {"type": "email", "link": "mailto:ispcc@ispcc.ie"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ISPCCChildline"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childlinebyispcc/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ISPCCChildline"},
        },
    },
    "ERAN (Emotional First Aid in Israel)": {
        "region": "Israel",
        "page": "https://childhelplineinternational.org/israel-eran-emotional-first-aid-in-israel/",
        "description": "ERAN was established in Jerusalem in 1971. Today, ERAN operates the largest hotline in Israel and provides mental health services on the telephone and online to the entire Israeli public, anonymously and immediately.",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "https://www.eran.org.il/?fbclid=IwAR0rH28WI5SATYe0ZyWggJRb3gAGIOlRfu9gKcFTomkPsJD4ybUrFe9cvPI",
            },
            "1201": {"type": "phone", "link": "tel:1201"},
            "Email": {"type": "email", "link": "mailto:eran1201@eran.org.il"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/eran_1201/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCDDx1k4i3siQaejE1VB82ig"},
        },
    },
    "NATAL Helpline": {
        "region": "Israel",
        "page": "https://childhelplineinternational.org/israel-natal-helpline/",
        "description": "NATAL Helpline provides support and psychological assistance to victims of trauma in the context of terrorism and war. The line operates in a special model and offers ongoing guidance to adults and children by phone or chat on the site.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.natal.org.il/"},
            "1(800)363-363": {"type": "phone", "link": "tel:1800363363"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/NatalIsrael/"},
            "Instagram": {
                "type": "instragram",
                "link": "https://www.instagram.com/natal.org.il/?fbclid=IwAR3P9SBDgFNcUnAtKbW7RMQr8tAt36k09QlHnXgQfJ9ldD9XD2ep-4064B0",
            },
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/natal/?fbclid=IwAR18d1aQRm_sdOOtesCqSGj96wJMjnhbTiMVL19lbTtbXRA219EghLHi-rA",
            },
        },
    },
    "Hello Telefono Azzurro": {
        "region": "Italy",
        "page": "https://childhelplineinternational.org/italy-hello-telefono-azzurro/",
        "description": "Telefono Azzurro listens to children and adolescents every day and offers concrete answers to their requests for help, also through collaboration with institutions, associations and other territorial realities. It operates in an international context for the promotion of a culture of rights.",
        "contacts": {
            "Website": {"type": "website", "link": "https://azzurro.it/"},
            "1 96 96": {"type": "phone", "link": "tel:19696"},
            "Email": {"type": "email", "link": "mailto:info@azzurro.it"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/TelefonoAzzurroOnlus/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/telefono_azzurro/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/telefonoazzurro"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCiSBypJxpwMVDaSA2zsuTIQ"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/s.o.s.---telefono-azzurro/?originalSubdomain=it",
            },
        },
    },
    "Uzticibas Talrunis – Child and Adolescent Helpline 116 111": {
        "region": "Latvia",
        "page": "https://childhelplineinternational.org/latvia-uzticibas-talrunis-child-and-adolescent-helpline-116-111/",
        "description": "The Child and Adolescent Helpline 116111 of the State Inspectorate for the Protection of the Rights of the Child is a free 24-hour helpdesk providing professional psychological assistance and support in crisis situations. The hotline is designed to provide psychological help to children and adolescents, as well as support in crisis situations. The most important task of the hotline is to listen to and support children and adolescents, helping them to deal with different issues and life situations.",
        "contacts": {
            "Website": {"type": "website", "link": "https://uzticibastalrunis.lv/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "800 6008": {"type": "phone", "link": "tel:8006008"},
            "Email": {"type": "email", "link": "https://orgchil-jicorica.savviihq.com/?p=2511"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/UT116111/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/uzticibastalrunis.lv/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/talrunis116111"},
        },
    },
    "Pro Juventute Beratung + Hilfe 147 - Liechtenstein": {
        "region": "Liechtenstein",
        "page": "https://childhelplineinternational.org/liechtenstein-projuventute/",
        "description": "The Sorgentelefon fur Kinder und Jugendliche is a toll-free contact point for questions and problems of all kinds for children and young people in the Principality of Liechtenstein and can be reached at number 147 all year round, day and night, including Sundays and public holidays.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.147.ch/"},
            "147": {"type": "phone", "link": "tel:147"},
            "Email": {"type": "email", "link": "mailto:socialmedia@projuventute.ch"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ProJuventute.ch/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/147_schweiz/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/projuventute"},
        },
    },
    "Vaiku Linija": {
        "region": "Lithuania",
        "page": "https://childhelplineinternational.org/lithuania-vaiku-linija/",
        "description": "Vaiku Linija was established in 1997 and provides free and anonymous help to the children and teenagers by phone and on-line. Vaiku Linija consultants listen to all the children’s stories and try to find ways together to solve their difficulties, to encourage them to share their worries with the people they trust. If necessary children are referred to other institutions.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.vaikulinija.lt/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:vilnius@vaikulinija.lt"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/vaikulinija/"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/vaik%C5%B3-linija-child-line-?originalSubdomain=lt",
            },
        },
    },
    "Kanner Jugendtelefon (KJT)": {
        "region": "Luxembourg",
        "page": "https://childhelplineinternational.org/luxembourg-kanner-jugendtelefon-kjt/",
        "description": "Kanner-Jugendtelefon (KJT) was founded in 1992 within the framework of the United Nations Convention on the Rights of the Child. KJT gives every child and every young person the opportunity to be heard.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.kjt.lu/de/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:contact@kjt.lu"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/kannerjugendtelefon"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kannerjugendtelefon/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/kajutel"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/KannerJugendtelefon"},
        },
    },
    "Kellimni.com": {
        "region": "Malta",
        "page": "https://childhelplineinternational.org/malta-kellimni-com/",
        "description": "Kellimni.com offers free online support through SmartMessaging, e-mails, chat or participation in an online forum. All of its services are, free and confidential.",
        "contacts": {
            "Website": {"type": "website", "link": "https://kellimni.com/"},
            "Email": {"type": "email", "link": "https://kellimni.com/email-us/"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/kellimni"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kellimni/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/kellimnicom"},
        },
    },
    "Support Line 179": {
        "region": "Malta",
        "page": "https://childhelplineinternational.org/malta-support-line-179/",
        "description": "Supportline 179 is the national helpline in Malta, which offers support, information about local social welfare services and other agencies, and a referral service to callers who require assistance. The Supportline 179 is available on a 24/7 basis and all calls are free both from landlines and also from mobile phones. The organisation also operates the harmonised 116 111 number for Malta.",
        "contacts": {
            "Website": {"type": "website", "link": "https://fsws.gov.mt/en/appogg/Pages/supportline.aspx"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "116 123": {"type": "phone", "link": "tel:116123"},
        },
    },
    "Telefonul Copilului 116111 Moldova": {
        "region": "Moldova",
        "page": "https://childhelplineinternational.org/moldova-telefonul-copilului-116111-moldova/",
        "description": "Operated by the Ministry of Health, Labor and Social Protection, Telefonul Copilului 116111 Moldova is a free hotline that aims to protect children against any form of abuse of their rights, against any form of abuse and offers psychological counseling, information in the field of children’s rights, child protection consultancy and guidance and referral to the institutions empowered to provide the necessary assistance.",
        "contacts": {
            "Website": {"type": "website", "link": "http://telefonulcopilului.md/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Skype": {"type": "skype", "link": "skype:TelefonulcopiluluiMoldova116111?add"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/asociatiatelefonulcopilului/"},
        },
    },
    "De Kindertelefoon": {
        "region": "Netherlands",
        "page": "https://childhelplineinternational.org/netherlands-de-kindertelefoon/",
        "description": "De Kindertelefoon has been the place in the Netherlands where children can talk freely and confidentially about subjects that they do not dare, cannot or do not want to discuss in their own environment. We fulfill a statutory duty in this regard, which is why De Kindertelefoon is financed by the Ministry of Health, Welfare and Sport.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.kindertelefoon.nl/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "0800 0432": {"type": "phone", "link": "tel:0800%200432"},
            "Email": {"type": "email", "link": "mailto:landelijkbureau@kindertelefoon.nl"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/dekindertelefoon.nl"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kindertelefoon.nl/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/LBKindertelefoon"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/stichting-de-kindertelefoon/"},
        },
    },
    "Helpwanted.nl": {
        "region": "Netherlands",
        "page": "https://childhelplineinternational.org/netherlands-helpwanted-nl/",
        "description": "Helpwanted.nl is part of the Expertise Agency Online Child Abuse (EOKM). The EOKM is an independent foundation that is committed to the safety of all children.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.helpwanted.nl/"},
            "+31 20 261 5275": {"type": "phone", "link": "tel:+31%2020%20261%205275"},
            "Email": {"type": "email", "link": "mailto:info@helpwanted.nl"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Helpwantednl/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/helpwantednl/"},
        },
    },
    "Alo Bushavko": {
        "region": "North Macedonia",
        "page": "https://childhelplineinternational.org/north-macedonia-alo-bushavko/",
        "description": "Counseling for childrenAlo Bushavko provides support and counseling to children and youth. Counselors establish a trust-based relationship so that children or young people can share their emotions, needs, problems, learn about their rights, or seek advice or help.",
        "contacts": {
            "Website": {"type": "website", "link": "https://alobushavko.mk/mk/"},
            "+389 70 390 632": {"type": "phone", "link": "tel:38970390632"},
            "Email": {"type": "email", "link": "mailto:alobushavko@childrensembassy.org.mk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/megjashi/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/alobushavko/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/megjashi12345"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/Megjashi"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/in/children-s-embassy-detska-ambasada-0530415a/?originalSubdomain=mk",
            },
            "Flickr": {"type": "flickr", "link": "https://www.flickr.com/photos/childrens_embassy/"},
        },
    },
    "Alarmtelefonen for barn og unge": {
        "region": "Norway",
        "page": "https://childhelplineinternational.org/norway-alarmtelefonen-for-barn-og-unge/",
        "description": "“Alarmtelefonen for barn og unge” is a free telephone for children and young people who are exposed to violence, abuse and neglect. The alarm phone is open 24 hours a day all year round and also answers inquiries via chat, e-mail and SMS. Adults who are worried about children can also call.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.116111.no/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:alarm@116111.no"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Alarmtelefonen"},
        },
    },
    "Kors På Halsen": {
        "region": "Norway",
        "page": "https://childhelplineinternational.org/norway-kors-pa-halsen/",
        "description": "Kors På Halsen was established in 1984 as the national child helpline for everyone up to the age of 18.",
        "contacts": {
            "Website": {"type": "website", "link": "https://korspaahalsen.rodekors.no/"},
            "800 333 21": {"type": "phone", "link": "tel:800%20333%2021"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/korspahalsen"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/korspahalsen/"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCGl8oRzuIeixcF9IHJI0yKw"},
        },
    },
    "Telefon Zaufania": {
        "region": "Poland",
        "page": "https://childhelplineinternational.org/poland-telefon-zaufania/",
        "description": "Telefon Zaufania 116 111 is a helpline for children and adolescents provides support to children and adolescents up to 18 years of age. The phone is anonymous and free of charge, it works 7 days a week, 24 hours a day. Children can talk to us about everything: friendship, love, growing up, dealing with parents, siblings, problems at school or the emotions they experience. The child helpline is operated by Fundacja Dajemy Dzieciom Sile (Empowering Children Organisation).",
        "contacts": {
            "Website": {"type": "website", "link": "https://fdds.pl/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/DajemyDzieciomSile/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/116111.pl/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/TelefonZaufania"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/DajemyDzieciomSile"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/in/telefon-zaufania-37b78654/?originalSubdomain=pl",
            },
            "Spotify": {"type": "spotify", "link": "https://open.spotify.com/show/6XfIIhmV9uEqCR7jBrgbhN"},
        },
    },
    "SOS Criança": {
        "region": "Portugal",
        "page": "https://childhelplineinternational.org/portugal-sos-crianca/",
        "description": "SOS Criança believes that children and youth have the right to speak and deserve the right to protection. The helpline therefore provides a support service for children to discuss their problems and ask for help. They can do this by phone, email, chat and WhatsApp.",
        "contacts": {
            "Website": {"type": "website", "link": "https://iacrianca.pt/intervencao/sos-crianca/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:iac-soscrianca@iacrianca.pt"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/SOS-Crian%C3%A7a-185466678171119/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/sos.criancacores/"},
        },
    },
    "Telefonul Copilului 116111 Romania": {
        "region": "Romania",
        "page": "https://childhelplineinternational.org/romania-telefonul-copilului-116111-romania/",
        "description": "Telefonul Copilului 116111 is the only non-governmental, non-profit organization in Romania that provides children and parents with a national helpline. The call is offered free of charge by Telekom Romania and social workers and psychologists respond to all calls 7 days a week.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.telefonulcopilului.ro"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:telefonulcopilului@telefonulcopilului.ro"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/asociatiatelefonulcopilului/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/telefonulcopilului/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/Childline_RO"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/asociatiatelefonulcopilului/?originalSubdomain=nl",
            },
        },
    },
    "NADEL – Nacionalna Decija Linija Srbije": {
        "region": "Serbia",
        "page": "https://childhelplineinternational.org/serbia-nadel-nacionalna-decija-linija-srbije/",
        "description": "NADEL, or the National Children’s Line, is a telephone counseling service that enables children in Serbia to receive counseling support at any time by calling the toll-free number 116111, if they find themselves in circumstances where their rights are threatened or when they feel they need to talk to a competent and confidential person.",
        "contacts": {
            "Website": {"type": "website", "link": "http://nadel-decijalinija.org/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:nadel.srbija116111@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/nacionalnadecijalinija/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/116111.rs/"},
        },
    },
    "Linka Detskej Istoty": {
        "region": "Slovakia",
        "page": "https://childhelplineinternational.org/slovakia-linka-detskej-istoty/",
        "description": "Linka Detskej Istoty (Child Safety Line) is available 24/7, FREE, ANONYMOUSLY for the whole territory of Slovakia. ",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "http://www.ldi.sk/?fbclid=IwAR3WGHRKtve1hY0Ymnb7myRcIyNTOZUTf6KDMBBmnWzHbWhiHkfbWY24TMY",
            },
            "116111": {"type": "phone", "link": "tel:116111"},
            "0800 500 500": {"type": "phone", "link": "tel:0800112112"},
            "Email Admin": {"type": "email", "link": "http://info@ldi.sk"},
            "Email (Slovak)": {"type": "email", "link": "http://116111@ldi.sk"},
            "Email (Ukrainian & Russian)": {"type": "email", "link": "http://0800500500@ldi.sk"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/LinkaDetskejIstoty/"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/linka-detskej-istoty/?originalSubdomain=nl",
            },
            "Instagram": {"type": "instragram", "link": "http://www.instagram.com/linkadetskejistoty"},
        },
    },
    "National Telephone Helpline – TOM": {
        "region": "Slovenia",
        "page": "https://childhelplineinternational.org/slovenia-national-telephone-helpline-tom/",
        "description": "TOM is a telephone for children and adolescents, operating within the Association of Friends of the Youth of Slovenia (ZPMS), and was created as an emotional support for children and young people who face various issues, dilemmas or hardships in the process of growing up. On the toll-free number 116 111 , they can confide their problems to consultants or ask them for advice and additional information. Anonymity and confidentiality of the conversation and callers are guaranteed",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.e-tom.si/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:info@zpms.si"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ZPMSlovenije"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/zvezaprijateljev/"},
        },
    },
    "Teléfono ANAR de Ayuda a Ninòs y Adolescentes": {
        "region": "Spain",
        "page": "https://childhelplineinternational.org/spain-telefono-anar-de-ayuda-a-ninos-y-adolescentes/",
        "description": "ANAR Telephone Helpline for Children and Adolescent provides an immediate response to any problem that may affect a minor: relationship difficulties, violence in its different forms, psychological problems, among others. Any child or young person can dial our number, which is free and confidential, and they will find a psychologist on the other end who will listen to them for as long as they need, who will guide them through their problem and help them find a solution.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.anar.org/necesitas-ayuda-telefono-ninos-adolescentes/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "900 20 20 10": {"type": "phone", "link": "tel:%20900202010"},
            "Email": {"type": "email", "link": "mailto:comunicacion@anar.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/FundacionANAR/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/fundacionanar/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/FundacionANAR"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCOQb3ZDHjHMrvUBXBF6asfw"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/fundaci-n-anar/?viewAsMember=true",
            },
            "TikTok": {"type": "tiktok", "link": "https://www.tiktok.com/@fundacionanar?"},
        },
    },
    "BRIS": {
        "region": "Sweden",
        "page": "https://childhelplineinternational.org/sweden-bris/",
        "description": "Bris, Children’s rights in society, is one of Sweden’s leading children’s rights organizations that fights every day for a better society for children.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.bris.se/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "Email": {"type": "email", "link": "mailto:info@bris.se"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/BRIS/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/bris116111/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/brispress"},
        },
    },
    "Pro Juventute Beratung + Hilfe 147 - Switzerland": {
        "region": "Switzerland",
        "page": "https://childhelplineinternational.org/switzerland-pro-juventute-beratung-hilfe-147/",
        "description": "Pro Juventute’s child helpline provides advice for children and young people, confidential, free of charge and around the clock for children and young people if they have worries or questions.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.147.ch"},
            "147": {"type": "phone", "link": "tel:147"},
            "Email": {"type": "email", "link": "mailto:socialmedia@projuventute.ch"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/ProJuventute.ch/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/147_schweiz/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/projuventute"},
        },
    },
    "Genclik Destek Hatti": {
        "region": "Türkije",
        "page": "https://childhelplineinternational.org/turkey-genclik-destek-hatti/",
        "description": "Genclik Destek Hatti (Youth Support Line) provides children and young people information about legal support, education, employment and scholarship, guidance for access to public services, referral to health-related centers, provides individual counseling on issues such as psychological support, information about the probation process, future anxiety, and family problems.",
        "contacts": {
            "Website": {"type": "website", "link": ""},
            "0850 455 0070": {"type": "phone", "link": "tel:0850%20455%200070"},
            "Email": {"type": "email", "link": "mailto:iletisim@genclikdestekhatti.org.tr"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/Gen%C3%A7lik-Destek-Hatt%C4%B1-271022699618652/",
            },
        },
    },
    "Ukraine National Child Toll-Free Hotline": {
        "region": "Ukraine",
        "page": "https://childhelplineinternational.org/ukraine-ukraine-national-child-toll-free-hotline/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.la-strada.org.ua/"},
            "116111 (not accessible using Ukrainian SIM card outside Ukraine)": {"type": "phone", "link": "tel:116111"},
            "0 800 500 225": {"type": "phone", "link": "tel:0800500225"},
            "Email": {"type": "email", "link": "mailto:hotline@la-strada.org.ua"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/childhotline.ukraine"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childhotline_ua/"},
            "Skype": {"type": "skype", "link": "http://@lastrada-ukraine"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC6wbQ9UyDJXSJobRzkZsc0g"},
            "Telegram": {"type": "telegram", "link": "https://t.me/CHL116111"},
        },
    },
    "BEAT": {
        "region": "United Kingdom",
        "page": "https://childhelplineinternational.org/united-kingdom-beat/",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.beateatingdisorders.org.uk/"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/beat.eating.disorders"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/beatedsupport"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/beated"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/beatingED"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/beat---beating-eating-disorders/",
            },
            "0808 801 0677": {"type": "phone", "link": "tel:0808%20801%200677"},
            "Email 1": {"type": "email", "link": "mailto:help@beateatingdisorders.org.uk"},
            "0808 801 0432": {"type": "phone", "link": "tel:0808%20801%200432"},
            "Email": {"type": "email", "link": "mailto:Scotlandhelp@beateatingdisorders.org.uk"},
            "0808 801 0433": {"type": "phone", "link": "tel:0808%20801%200433"},
            "Email 2": {"type": "email", "link": "mailto:Waleshelp@beateatingdisorders.org.uk"},
            "Request support in Welsh": {
                "type": "comment",
                "link": "https://training.beateatingdisorders.org.uk/page/76838/data/1",
            },
            "0808 801 0434": {"type": "phone", "link": "tel:0808%20801%200434"},
            "Email 3": {"type": "email", "link": "mailto:NIhelp@beateatingdisorders.org.uk"},
        },
    },
    "Childline UK": {
        "region": "United Kingdom",
        "page": "https://childhelplineinternational.org/united-kingdom-childline-uk/",
        "description": " ",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.childline.org.uk/about/about-childline/"},
            "116 111": {"type": "phone", "link": "tel:116111"},
            "0800 1111": {"type": "phone", "link": "tel:0800%201111"},
            "Email": {"type": "email", "link": "https://www.childline.org.uk/login/?returnPath=%2flocker%2femail%2f"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/nspcc"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/childline_official/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/NSPCC"},
        },
    },
    "HopelineUK": {
        "region": "United Kingdom",
        "page": "https://childhelplineinternational.org/united-kingdom-hopelineuk/",
        "description": "A service of Papyrus Prevention of Young Suicide, HopelineUK’s advisers want to work with you to understand why thoughts of suicide might be present. They also want to provide you with a safe space to talk through anything happening in your life that could be impacting on your or anyone else’s ability to stay safe.",
        "contacts": {
            "Website": {"type": "website", "link": "https://www.papyrus-uk.org/hopelineuk/"},
            "0800 068 4141": {"type": "phone", "link": "tel:08000684141"},
            "Text": {"type": "comment", "link": "tel:08000684141"},
            "Email": {"type": "email", "link": "mailto:pat@papyrus-uk.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/PAPYRUSUK"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/papyrus_uk/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/PAPYRUS_tweets"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC_y_k9yZih75co_PCLOoyUA"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/papyrus-prevention-of-young-suicide/",
            },
            "TikTok": {
                "type": "tiktok",
                "link": "https://www.tiktok.com/@papyrus_uk?_d=secCgwIARCbDRjEFSACKAESPgo864ccELEgLnLpUS3iU1WXrlF0mOyBOhsE1rOCATc51bjAJPeGnHklJPAYhasIzyRwWR10qiJZ0bFX9Z%2FoGgA%3D&language=en&sec_uid=MS4wLjABAAAAQHWcWst9WayCCGURshD_0-v25e2uPEmFjtgJ1rUD1e_nlrXRghjnwM0-vw72Za7a&sec_user_id=MS4wLjABAAAAQHWcWst9WayCCGURshD_0-v25e2uPEmFjtgJ1rUD1e_nlrXRghjnwM0-vw72Za7a&share_app_id=1233&share_author_id=6805954090699441157&share_link_id=7e52fd33-b382-40dc-8a45-a099177e2ea6&timestamp=1645528172&u_code=dbd0ik0jlh3i9l&user_id=6805954090699441157&utm_campaign=client_share&utm_medium=android&utm_source=copy&source=h5_m&_r=1",
            },
        },
    },
    "The Mix": {
        "region": "United Kingdom",
        "page": "https://childhelplineinternational.org/united-kingdom-the-mix/",
        "description": "The Mix is a multi-channel advice service designed to support the physical and mental well-being of under 25s across the UK. Whatever issue a young person is facing, The Mix is always there for them, providing help, information and support 24/7.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.themix.org.uk/"},
            "0808 808 4994": {"type": "phone", "link": "tel:0808%20808%204994"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/TheMixUK"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/themixuk/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/themixUK"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/themixuk"},
            "LinkedIn": {"type": "linkedin", "link": "https://www.linkedin.com/company/the-mix-charity/"},
        },
    },
    "Je t’écoute 3033": {
        "region": "Algeria",
        "page": "https://childhelplineinternational.org/algeria-je-tecoute-3033/",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.nada-dz.org"},
            "3033": {"type": "phone", "link": "tel:3033"},
            "Email 998": {"type": "email", "link": "mailto:998@mlsd.gov.bh"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/reseau.nada.dz/"},
            "Instagram": {"type": "instragram", "link": "http://www.instagram.com/reseau.nada"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/ReseauNAda"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "http://www.linkedin.com/company/nada-réseau-algérien-pour-la-défense-des-droits-de-l’enfant",
            },
        },
    },
    "Child Helpline 998": {
        "region": "Bahrain",
        "page": "https://childhelplineinternational.org/bahrain-child-helpline-998/",
        "description": "Run by the Ministry of Labour & Social Development in Bahrain, Child Helpline 998 is a toll-free phone line and provides a place to report children’s exposure to violence or abuse. The line receives calls from the child or others who are exposed to violence, abuse or danger. It also provides counselling, active listening and referral to the relevant authorities concerned when needed",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.mlsd.gov.bh/en/childhood/childhood_care/998"},
            "80008001": {"type": "phone", "link": "tel:+97380008001"},
            "WhatsApp": {"type": "whatsapp", "link": "tel:01102121600"},
            "Email": {"type": "email", "link": "mailto:info@mlsd.gov.bh"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/mosdsocial"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/mlsdbahrain"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/mlsdbahrain"},
        },
    },
    "Child Helpline Egypt": {
        "region": "Egypt",
        "page": "https://childhelplineinternational.org/egypt-child-helpline-egypt/",
        "description": "Child Helpline 16000 is provided by the National Council for Childhood and Motherhood, which operates 24 hours a day to receive calls about children being at risk. ",
        "contacts": {
            "Website": {
                "type": "website",
                "link": "http://nccm.gov.eg/%d8%ae%d8%b7-%d9%86%d8%ac%d8%af%d8%a9-%d8%a7%d9%84%d8%b7%d9%81%d9%84/",
            },
            "WhatsApp": {"type": "whatsapp", "link": "https://api.whatsapp.com/send?phone=+2001016609579&text="},
            "16000": {"type": "phone", "link": "tel:16000"},
            "88531109 (with the city code 021).": {"type": "phone", "link": "tel:02188531109"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Child.Help.line.Egypt"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/NCCMEgypt"},
            "Youtube": {
                "type": "youtube",
                "link": "https://www.youtube.com/channel/UC0Q-bhJZ4Dr0SfmEx_HOXcQ?view_as=subscriber",
            },
        },
    },
    "Sedaye Yara": {
        "region": "Iran",
        "page": "https://childhelplineinternational.org/iran-sedaye-yara/",
        "description": " Run by Iranian Society for Protecting the Rights of the Child (IRSPRC), Sedaye Yara is a child helpline that is based on the belief that every child and adolescent, regardless of social class, gender, race, talent, or any other form of discrimination, should be able to receive appropriate assistance in times of need. The helpline provides support to children, adolescents, parents and schools and supports them with resolving any challenges and issues they may have.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.irsprc.org"},
            "+98 21 42152": {"type": "phone", "link": "tel:+982142152"},
            "Email": {"type": "email", "link": "mailto:info@irsprc.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/irsprc"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/irsprcorg/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/irsprc2"},
            "Telegram": {"type": "telegram", "link": "https://t.me/irsprcorg"},
            "Soundcloud": {"type": "soundcloud", "link": "https://soundcloud.com/mojekoodaki"},
        },
    },
    "116 Child Helpline – Kurdistan Region": {
        "region": "Iraq",
        "page": "https://childhelplineinternational.org/iraq-116-child-helpline-kurdistan-region/",
        "description": "116 Child Helpline is a free child helpline for children and young people in Iraq.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.molsa.gov.iq/"},
            "116": {"type": "phone", "link": "tel:116"},
            "Email": {"type": "email", "link": "mailto:childhelp116erbil@gmail.com"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/%D9%87%D9%8A%D9%84%D9%89-%D9%81%D8%B1%DB%8C%D8%A7%DA%A9%DB%95%D9%88%D8%AA%D9%86%DB%8C-%D9%85%D9%86%D8%AF%D8%A7%DA%B5-%D9%A1%D9%A1%D9%A6-%D9%87%DB%95%D9%88%D9%84%DB%8E%D8%B1%D8%AE%D8%B7-%D9%86%D8%AC%D8%AF%D8%A9-%D8%A7%D9%84%D8%B7%D9%81%D9%84-116%D8%A7%D8%B1%D8%A8%D9%8A%D9%84-191573691286520/?ref=page_internal",
            },
            "Twitter": {"type": "twitter", "link": "https://twitter.com/site3075"},
        },
    },
    "JRF 110 Helpline": {
        "region": "Jordan",
        "page": "https://childhelplineinternational.org/jordan-jrf-110-helpline/",
        "description": "Jordan River Foundation’s 110 Helpline is a free service offering support in child and family safety and psychological well-being in complete confidentiality, offering beneficiaries with resources, referrals and guidance that do not obstruct, label or judge them.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.jordanriver.jo/"},
            "110": {"type": "phone", "link": "tel:110"},
            "Email": {"type": "email", "link": "mailto:info@jrf.org.jo"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/JordanRiverFoundation"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/jordanriverdesigns/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/JordanRiverFDN"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/JordanRiverFDN"},
        },
    },
    "Help Hotline 147": {
        "region": "Kuwait",
        "page": "https://childhelplineinternational.org/kuwait-help-hotline-147/",
        "description": "The Child Helpline 147, run by the Kuwait National Child Protection Program, aims to provide children with protection and give them the opportunity to express their concerns and fears. The helpline works to listen consciously to children or parents, providing them with advice and directing them to appropriate action.",
        "contacts": {
            "Website": {"type": "website", "link": "http://kncpp.com/"},
            "147": {"type": "phone", "link": "tel:147"},
            "Email": {"type": "email", "link": "mailto:kuwaitcpp@gmail.com"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/kuwaitncpp/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/kncpp/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/kncpp"},
        },
    },
    "Higher Council for Childhood": {
        "region": "Lebanon",
        "page": "https://childhelplineinternational.org/lebanon-higher-council-for-childhood/",
        "description": "The Higher Council for Childhood is the national framework for complementary work between non governmental organizations and the public sector as to child care and development in compliance with international conventions and especially,  the Convention on the Rights of the Child and in collaboration with international organizations.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.atfalouna.gov.lb/"},
            "Email": {"type": "email", "link": "mailto:hcclebanon@gmail.com"},
        },
    },
    "Naba’a": {
        "region": "Lebanon",
        "page": "https://childhelplineinternational.org/lebanon-nabaa/",
        "description": "Naba’a is a Lebanese non-political, not-for-profit organisation that aims to create an environment where children and young people can thrive and live in harmony regardless of their religion, sex and nationality. Naba’a works to empower local communities and to enable their members to uphold their rights and to build a better future for themselves.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.nabaa-lb.org"},
            "Email": {"type": "email", "link": "mailto:%20info@nabaa-lb.org"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Nabaa.Lebanon/?fref=ts"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/nabaalebanon/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/NABAA2001"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCDUagSSFTSEtpckzXx5MZZA"},
        },
    },
    "Sawa 121": {
        "region": "Palestine",
        "page": "https://childhelplineinternational.org/palestine-sawa-121/",
        "description": "Sawa Foundation works to fight violence against women and children and offers free psychological support to victims of violence over the phone. They provide guidance, primary, medical and legal psychological support service all week over the phone and free of charge",
        "contacts": {
            "121": {"type": "phone", "link": "tel:121"},
            "WhatsApp": {"type": "whatsapp", "link": "http://972594040121+"},
            "Email": {"type": "email", "link": "mailto:info@sawa.ps"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Sawa.Organization/"},
            "Instagram": {
                "type": "instragram",
                "link": "https://www.instagram.com/sawa.organization/?fbclid=IwAR2S6X51a8LYVJZBWybN_ke7uiBl3xSeVMJjcyib5YePDlB9GuQ4F4PHcto",
            },
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/results?search_query=sawa+organization"},
        },
    },
    "Hotline 919": {
        "region": "Qatar",
        "page": "https://childhelplineinternational.org/qatar-hotline-919/",
        "description": "Hotline 919 provides provides free confidential consultations (social, psychological and legal) for women and children and also provides support to protect and rehabilitate children and women who are victims of violence and family breakdown.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.aman.org.qa/"},
            "919": {"type": "phone", "link": "tel:919"},
            "Email": {"type": "email", "link": "mailto:info@aman.org.qa"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/Amancentre/"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/amancentre/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/amancentre"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UC2jVVqG4MU2UyLDgYZ5TVQg"},
        },
    },
    "Saudi Child Helpline 116111": {
        "region": "Saudi Arabia",
        "page": "https://childhelplineinternational.org/saudi-arabia-saudi-child-helpline-116111/",
        "description": "Operating under the Saudi Arabia National Family and Safety Programme, Child Support Line 116111 provides free consultation services and support for children undergoing abuse and neglect.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.nfsp.org.sa"},
            "9661 252 0088": {"type": "phone", "link": "tel:9661%20252%200088"},
            "Email": {"type": "email", "link": "https://orgchil-jicorica.savviihq.com/?p=2511"},
            "Facebook": {
                "type": "facebook",
                "link": "https://www.facebook.com/nfspa/?show_switched_toast=0&show_invite_to_follow=0&show_switched_tooltip=0&show_podcast_settings=0&show_community_transition=0&show_community_review_changes=0",
            },
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/nfsp1/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/nfsp1"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/NFSP2005"},
        },
    },
    "Child Helpline 9696": {
        "region": "Sudan",
        "page": "https://childhelplineinternational.org/sudan-child-helpline-9696/",
        "description": "Operating under the Child and Family Protection Unit, 9696 is the free hotline for the children’s support in a communication center that works confidentially to receive complaints, inquires from the children themselves, their parents or caregivers.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.fcpu.gov.sd/"},
            "9696": {"type": "phone", "link": "tel:9696"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/FCPA.SD/?fref=ts"},
        },
    },
    "Child Helpline 800 700": {
        "region": "United Arab Emirates",
        "page": "https://childhelplineinternational.org/united-arab-emirates-child-helpline-800-700/",
        "description": "Operated under the Department of Social Services, Child Helpline 800 700 was established in 2007 to receive reports of children at risk and abuse of all kinds, such as physical, sexual and emotional abuse, neglect and commercial exploitation, and deal with them through a specialized team that works to support the child.",
        "contacts": {
            "Website": {"type": "website", "link": "https://sssd.shj.ae/"},
            "800 700": {"type": "phone", "link": "tel:800700"},
            "Email": {"type": "email", "link": "mailto:sssd@sssd.shj.ae"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/sssd.gov"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/sssdshj/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/sssdshj"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/user/SharjahSocialService"},
            "Flickr": {"type": "flickr", "link": "https://www.flickr.com/photos/132221693@N02/"},
        },
    },
    "DFWAC Helpline": {
        "region": "United Arab Emirates",
        "page": "https://childhelplineinternational.org/united-arab-emirates-dfwac-helpline/",
        "description": "The Dubai Foundation for Women and Children (DFWAC) is the first licensed non-profit shelter in the UAE for women and child victims of domestic violence, child abuse and human trafficking. It offers victims immediate protection and support services, in accordance with international human rights obligations. DFWAC provides a 24/7 free-of-charge child helpline service (800111) for all residents of Dubai, which aims to provide an efficient response for clients who ask for more information about the foundation’s services, call for urgent help, report abuse or seek consultation.",
        "contacts": {
            "Website": {"type": "website", "link": "http://www.dfwac.ae/"},
            "800111": {"type": "phone", "link": "tel:800111"},
            "WhatsApp": {"type": "whatsapp", "link": "https://api.whatsapp.com/send?phone=971800111"},
            "Email": {"type": "email", "link": "mailto:help@dfwac.ae"},
            "Facebook": {"type": "facebook", "link": "https://www.facebook.com/DFWAC"},
            "Instagram": {"type": "instragram", "link": "https://www.instagram.com/dfwac/"},
            "Twitter": {"type": "twitter", "link": "https://twitter.com/DFWAC"},
            "Youtube": {"type": "youtube", "link": "https://www.youtube.com/channel/UCa-v9enrOrK0_7K4g4-h2Jw"},
            "LinkedIn": {
                "type": "linkedin",
                "link": "https://www.linkedin.com/company/dubai-foundation-for-women-and-children/",
            },
            "Telegram": {"type": "telegram", "link": "https://t.me/DFWAC_community_awarness"},
        },
    },
}
