import os
import subprocess
from flaml import tune
import time
import sys

config_search_space = {
    "sz": tune.lograndint(lower=512, upper=10240),
}

full_datapath=sys.argv[1]
import json
with open(full_datapath) as fd:
    data = json.load(fd)

def evaluate_config(config: dict):
    # generate data subset
    sz = config["sz"]
    one_data = data[:sz]
    output_path=f"flaml_data/rule_{sz}.json"
    with open(output_path, "w") as fd:
        json.dump(one_data, fd, indent=1)
    exp_name=os.path.basename(output_path).replace(".json", "_exp")
    subprocess.run(["bash", "execute_flaml.sh", output_path])
    with open(f"exp_flaml/{exp_name}/one_number") as fd:
        line = list(fd.readlines())[0]
    score = float(line)
    # collect result
    evaluation_cost = sz
    return {"score": score, "evaluation_cost": evaluation_cost}

analysis = tune.run(
  evaluation_function=evaluate_config,
  config=config_search_space,
  metric="score",
  mode="min",
  num_samples=20,
)

print(analysis.best_config)  # the best config
print(analysis.best_trial.last_result)  # the best trial's result
