Generate_median <- function(N=2000){

  require(bindata)
  require(MASS)

  w1 <- rbinom(N, 1, prob = 0.3)
  w2 <- rbinom(N, 1, prob = 0.4)
  w3 <- rbinom(N, 1, prob = 0.5)
  w4 <- rbinom(N, 1, prob = 0.6)

  u1 <- rbinom(N, 1, prob = 0.7)


  ptr <- 0.15*(0.75*w1+0.25*(1-w1)) + 0.15*(0.75*w2+0.25*(1-w2)) + 0.15*(0.75*w3+0.25*(1-w3)) + 0.15*(0.75*w4+0.25*(1-w4)) + 0.4*(0.75*u1+0.25*(1-u1))
  t <- rbinom(N, 1, prob = ptr)

  em <- rnorm(N,mean=0,sd=1)

  cc <- rnorm(N,mean=5,sd=1)

  FD <- 10*t + cc*(w1+w2+w3+w4) + em

  x5 <- rnorm(N, mean = FD, sd = 0.01)
  x6 <- rnorm(N, mean = FD, sd = 0.1)
  x7 <- rnorm(N, mean = FD, sd = 1)
  x8 <- rnorm(N, mean = FD, sd = 10)

  c <- rnorm(N,mean=1,sd=1)
  ey <- rnorm(N,mean=0,sd=1)

  y <- c*(w1+w2+w3+w4) + 10*u1 + FD + ey

  dat<-cbind.data.frame(y,t,w1,w2,w3,w4,x5,x6,x7,x8,FD)

  return(dat)
}