import torch
import numpy as np


def load_data_CFDiVAE(path, N, num):
    path_data = path

    data = np.loadtxt(path_data + '/Syn_' + str(N) + '/Syn_' + str(N) + '_' + str(num + 1) + '.csv', delimiter=',',
                      skiprows=1)

    t, y = data[:, 1], data[:, 0][:, np.newaxis]  # t = {T}; y = {y}
    x = data[:, 1:10]  # x = {T, W, X}
    z = data[:, 10] # z = Zcfd (ground truth)

    x = torch.from_numpy(x)
    y = torch.from_numpy(y).squeeze()
    t = torch.from_numpy(t).squeeze()
    z = torch.from_numpy(z).squeeze()

    x = x.cuda()
    y = y.cuda()
    t = t.cuda()
    z = z.cuda()

    data = (x, t, y, z)

    return data
