# Generating synthetic datasets

source(".../Generatesyn.R")

Nsamples <- c('0.0','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6','1.8','2.0')

for (i in 1:length(Nsamples)) {
  N <- Nsamples[i]

  mainDir <- ".../Data"
  subDir <- as.character(paste0("Syn_",N))

  if (file.exists(subDir)){
    setwd(file.path(mainDir, subDir))
  } else {
    dir.create(file.path(mainDir, subDir))
    setwd(file.path(mainDir, subDir))
  }

  for (j in 1:30) {
    file_name = paste0("Syn_10000_",j)
    Synth_data<-Generate_median(as.double(N))
    write.csv(Synth_data, file = paste0(file_name,".csv"),row.names = FALSE)
  }
}