# python ./methods/VCD/experiments/eval/object_hallucination_vqa_qwenvl.py \
#     --model-path /code/pretrained_models/qwenvl-chat-7b\
#     --question-file ./data/pope/coco/coco_pope_random.json \
#     --image-folder ./data/pope/coco/images \
#     --answers-file ./outputs/pope/qwenvl/coco_random_sample.jsonl \
#     --use_cd \
#     --cd_alpha 1 \
#     --cd_beta 0.1 \
#     --noise_step 999 \
#     --seed 324418


datasets=(aokvqa gqa)
types=(random popular adversarial)

for dataset in ${datasets[@]}; do
  if [[ $dataset == 'coco' || $dataset == 'aokvqa' ]]; then
    image_folder=./data/pope/coco/images
  else
    image_folder=./data/pope/gqa/images
  fi

   for type in ${types[@]}; do
    python ./methods/VCD/experiments/eval/object_hallucination_vqa_qwenvl.py \
      --model-path /code/pretrained_models/qwenvl-chat-7b \
      --question-file ./data/pope/${dataset}/${dataset}_pope_${type}.json \
      --image-folder ${image_folder} \
      --answers-file ./outputs/pope/qwenvl/base_${dataset}_${type}_sample.jsonl \
      --cd_alpha 1 \
      --cd_beta 0.1 \
      --noise_step 700 \
      --seed 324418
  done
done