import torch
from torch import nn
import torch.nn.functional as F
torch.autograd.set_detect_anomaly(True)

class MLP(nn.Module):
    def __init__(self, dim_in, dim_hidden, dim_out):
        super(MLP, self).__init__()
        self.layer_input = nn.Linear(dim_in, dim_hidden)
        self.relu = nn.ReLU()
        self.dropout = nn.Dropout()
        self.layer_hidden = nn.Linear(dim_hidden, dim_out)

    def forward(self, x):
        x = x.view(-1, x.shape[1]*x.shape[-2]*x.shape[-1])
        x = self.layer_input(x)
        x = self.dropout(x)
        x = self.relu(x)
        x = self.layer_hidden(x)
        return x

# class CNNMnist(nn.Module):
#     def __init__(self, args):
#         super(CNNMnist, self).__init__()
#         self.conv1 = nn.Conv2d(args.num_channels, 10, kernel_size=5)
#         self.conv2 = nn.Conv2d(10, 20, kernel_size=5)
#         self.conv3 = nn.Conv2d(20, 40, kernel_size=3)
#         self.conv2_drop = nn.Dropout2d()
#         self.fc1 = nn.Linear(40, 20)
#         self.fc2 = nn.Linear(20, args.num_classes)

#     def forward(self, x):
#         x = F.relu(F.max_pool2d(self.conv1(x), 2))
#         x = F.relu(F.max_pool2d(self.conv2_drop(self.conv2(x)), 2))
#         x = F.relu(F.max_pool2d(self.conv3(x), 2))
#         x = x.view(-1, x.shape[1]*x.shape[2]*x.shape[3])
#         x = F.relu(self.fc1(x))
#         x = F.dropout(x, training=self.training)
#         x = self.fc2(x)
#         return x

class CNNMnist(nn.Module):
    def __init__(self, args):
        super(CNNMnist, self).__init__()
        self.conv1 = nn.Conv2d(args.num_channels, 32, kernel_size=5)
        self.conv2 = nn.Conv2d(32, 64, kernel_size=3)
        self.conv2_drop = nn.Dropout2d()
        self.fc1 = nn.Linear(1600, 50)
        self.fc2 = nn.Linear(50, args.num_classes)

    def forward(self, x):
        x = F.relu(F.max_pool2d(self.conv1(x), 2))
        x = F.relu(F.max_pool2d(self.conv2_drop(self.conv2(x)), 2))
        x = x.view(-1, x.shape[1]*x.shape[2]*x.shape[3])
        x = F.relu(self.fc1(x))
        x = F.dropout(x, training=self.training)
        x = self.fc2(x)
        return x
    
# class Fin_CNNMnist(nn.Module):
#     def __init__(self, args):
#         super(Fin_CNNMnist, self).__init__()
#         self.conv1 = nn.Conv2d(args.num_channels, 10, kernel_size=5)
#         self.conv2 = nn.Conv2d(10, 20, kernel_size=5)
#         self.conv3 = nn.Conv2d(20, 40, kernel_size=3)
#         self.conv2_drop = nn.Dropout2d()
#         self.fc1 = nn.Linear(40, 20)
#         self.fc2 = nn.Linear(20, args.num_classes)
#         self.fc3 = nn.Linear(40, 20)
#         self.fc4 = nn.Linear(20, args.num_classes)

#     def forward(self, x):
#         x = F.relu(F.max_pool2d(self.conv1(x), 2))
#         x = F.relu(F.max_pool2d(self.conv2_drop(self.conv2(x)), 2))
#         x = F.relu(F.max_pool2d(self.conv3(x), 2))
#         x = x.view(-1, x.shape[1]*x.shape[2]*x.shape[3])
        
#         x_g = self.fc1(x)
#         x_p = self.fc3(x)
        
#         x_g = F.relu(x_g)
#         x_g = F.dropout(x_g, training=self.training)
#         y_g = self.fc2(x_g)
        
#         x_p = F.relu(x_p)
#         x_p = F.dropout(x_p, training=self.training)
#         y_p = self.fc4(x_p)
        
#         return y_g, y_p

class Fin_CNNMnist(nn.Module):
    def __init__(self, args):
        super(Fin_CNNMnist, self).__init__()
        self.conv1 = nn.Conv2d(args.num_channels, 32, kernel_size=5)
        self.conv2 = nn.Conv2d(32, 64, kernel_size=3)
        self.conv2_drop = nn.Dropout2d()
        self.fc1 = nn.Linear(1600, 50)
        self.fc2 = nn.Linear(50, args.num_classes)
        self.fc3 = nn.Linear(50, args.num_classes)
        # self.fc3 = nn.Linear(1024, 50)
        # self.fc4 = nn.Linear(50, args.num_classes)

    # def forward(self, x):
    #     x = F.relu(F.max_pool2d(self.conv1(x), 2))
    #     x = F.relu(F.max_pool2d(self.conv2_drop(self.conv2(x)), 2))
        
    #     # x = self.conv2(x)
    #     # x = self.conv2_drop(x)
    #     # x = F.max_pool2d(x, 2)
    #     # x = F.relu(x)
        
    #     x = x.view(-1, x.shape[1]*x.shape[2]*x.shape[3])
    #     x_g = F.relu(self.fc1(x))
    #     x_g = F.dropout(x_g, training=self.training)
    #     y_g = self.fc2(x_g)
    #     x_p = F.relu(self.fc3(x))
    #     x_p = F.dropout(x_p, training=self.training)
    #     y_p = self.fc4(x_p)
    #     return y_g, y_p
    
    def forward(self, x):
        x = F.relu(F.max_pool2d(self.conv1(x), 2))
        x = F.relu(F.max_pool2d(self.conv2_drop(self.conv2(x)), 2))
        x = x.view(-1, x.shape[1]*x.shape[2]*x.shape[3])
        x = F.relu(self.fc1(x))
        x = F.dropout(x, training=self.training)
        y_g = self.fc2(x)
        y_p = self.fc3(x)
        return y_g, y_p


# class CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 6, 5)
#         self.pool = nn.MaxPool2d(2, 2)
#         self.conv2 = nn.Conv2d(6, 16, 5)
#         self.fc1 = nn.Linear(16 * 5 * 5, 120)
#         self.fc2 = nn.Linear(120, 84)
#         self.fc3 = nn.Linear(84, args.num_classes)

#     def forward(self, x):
#         x = self.pool(F.relu(self.conv1(x)))
#         x = self.pool(F.relu(self.conv2(x)))
#         x = x.view(-1, 16 * 5 * 5)
#         x = F.relu(self.fc1(x))
#         x = F.relu(self.fc2(x))
#         x = self.fc3(x)
#         return x



# class CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2)
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1)
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1)
#         self.fc1 = nn.Linear(64 * 4 * 4, 64) 
#         self.fc2 = nn.Linear(64, args.num_classes)

#     def forward(self, x):
#         x = self.pool(F.relu(self.conv1(x)))
#         x = self.pool(F.relu(self.conv2(x)))
#         x = self.pool(F.relu(self.conv3(x))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x = F.relu(self.fc1(x)) 
#         x = self.fc2(x) 
#         return x

# class CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2)
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1) 
#         self.bn2 = nn.BatchNorm2d(64) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1)
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64)
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.dropout = nn.Dropout(0.5)

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x))))
#         x = self.pool(F.relu(self.bn2(self.conv2(x)))) 
#         x = self.pool(F.relu(self.bn3(self.conv3(x)))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x = self.dropout(F.relu(self.fc1(x)))
#         x = self.fc2(x)
#         return x

# class CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2) 
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2)
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1)
#         self.bn2 = nn.BatchNorm2d(64)
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1) 
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64)  
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.dropout = nn.Dropout(0.5) 

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x)))) 
#         x = self.pool(F.relu(self.bn2(self.conv2(x))))
#         x = self.pool(F.relu(self.bn3(self.conv3(x)))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x = self.dropout(F.relu(self.fc1(x))) 
#         x = self.fc2(x)
#         return x

# class CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=3, padding=1) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64)  
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.dropout = nn.Dropout(0.5)

#     def forward(self, x):
#         x = self.pool(F.relu(self.conv1(x))) 
#         x = self.pool(F.relu(self.conv2(x))) 
#         x = self.pool(F.relu(self.conv3(x))) 
#         x = x.view(-1, 64 * 4 * 4)  # 展平为向量
#         x = self.dropout(F.relu(self.fc1(x))) 
#         x = self.fc2(x) 
#         return x

# class Fin_CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(Fin_CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2) 
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1) 
#         self.bn2 = nn.BatchNorm2d(64) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1) 
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64) 
#         self.fc2 = nn.Linear(64, args.num_classes)  
#         self.fc3 = nn.Linear(64 * 4 * 4, 64) 
#         self.fc4 = nn.Linear(64, args.num_classes)
#         self.dropout = nn.Dropout(0.5) 

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x)))) 
#         x = self.pool(F.relu(self.bn2(self.conv2(x)))) 
#         x = self.pool(F.relu(self.bn3(self.conv3(x)))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x_g = self.dropout(F.relu(self.fc1(x))) 
#         y_g = self.fc2(x_g) 
#         x_p = self.dropout(F.relu(self.fc3(x))) 
#         y_p = self.fc4(x_p) 
#         return y_g, y_p

# class Fin_CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(Fin_CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2) 
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2)  
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=5, padding=2) 
#         self.bn2 = nn.BatchNorm2d(64) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=5, padding=2)  
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64)  
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.fc3 = nn.Linear(64 * 4 * 4, 64) 
#         self.fc4 = nn.Linear(64, args.num_classes) 
#         self.dropout = nn.Dropout(0.5)

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x)))) 
#         x = self.pool(F.relu(self.bn2(self.conv2(x)))) 
#         x = self.pool(F.relu(self.bn3(self.conv3(x))))
#         x = x.view(-1, 64 * 4 * 4) 
#         x_g = self.dropout(F.relu(self.fc1(x))) 
#         y_g = self.fc2(x_g) 
#         x_p = self.dropout(F.relu(self.fc3(x))) 
#         y_p = self.fc4(x_p) 
#         return y_g, y_p

# # Cifar10线性层滤波器
# class Fin_CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(Fin_CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2) 
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1)
#         self.bn2 = nn.BatchNorm2d(64) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1) 
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64)
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.fc3 = nn.Linear(64, args.num_classes)  
#         self.dropout = nn.Dropout(0.5)

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x)))) 
#         x = self.pool(F.relu(self.bn2(self.conv2(x)))) 
#         x = self.pool(F.relu(self.bn3(self.conv3(x)))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x = self.dropout(F.relu(self.fc1(x))) 
#         y_g = self.fc2(x) 
#         y_p = self.fc3(x) 
#         return y_g, y_p

# # Cifar100线性层滤波器
# class Fin_CNNCifar(nn.Module):
#     def __init__(self, args):
#         super(Fin_CNNCifar, self).__init__()
#         self.conv1 = nn.Conv2d(3, 32, kernel_size=5, padding=2) 
#         self.bn1 = nn.BatchNorm2d(32) 
#         self.pool = nn.MaxPool2d(kernel_size=2, stride=2) 
#         self.conv2 = nn.Conv2d(32, 64, kernel_size=3, padding=1) 
#         self.bn2 = nn.BatchNorm2d(64) 
#         self.conv3 = nn.Conv2d(64, 64, kernel_size=3, padding=1) 
#         self.bn3 = nn.BatchNorm2d(64) 
#         self.fc1 = nn.Linear(64 * 4 * 4, 64) 
#         self.fc2 = nn.Linear(64, args.num_classes) 
#         self.fc3 = nn.Linear(64, args.num_classes) 
#         self.dropout = nn.Dropout(0.5) 

#     def forward(self, x):
#         x = self.pool(F.relu(self.bn1(self.conv1(x))))  
#         x = self.pool(F.relu(self.bn2(self.conv2(x))))  
#         x = self.pool(F.relu(self.bn3(self.conv3(x)))) 
#         x = x.view(-1, 64 * 4 * 4) 
#         x = self.dropout(F.relu(self.fc1(x))) 
#         y_g = self.fc2(x) 
#         y_p = self.fc3(x) 
#         return y_g, y_p