 

def data_loader(data_id, centered_data = 0):
    pol = fetch_openml(data_id = data_id) 
    
    # B classification set:
    # data_id = 727 -> 2dplanes
    # data_id = 41150 -> MiniBooNE
    # data_id = 23512 -> higgs
    # data_id = 1597 -> creditcard
    # data_id = 23517 -> numerai28.6
    
    # regression set:
    # data_id = 43141 -> ACSIncome
    # data_id = 4549 -> Buzzinsocialmedia_Twitter
    # data_id = 564 -> fried
    # data_id = 574 -> house_16H
    # data_id = 4545 -> OnlineNewsPopularity
    
    X, y_ori = pol.data, pol.target
    
    if data_id == 727:
        y = np.zeros(y_ori.shape[0])
        for i in np.arange(y_ori.shape[0]):
            if np.asarray(y_ori)[i] == 'P':
                y[i] = 1
            elif np.asarray(y_ori)[i] == 'N':
                y[i] = 0
                
    elif data_id == 41150:
        y = np.zeros(y_ori.shape[0])
        for i in np.arange(y_ori.shape[0]):
            if np.asarray(y_ori)[i] == 'True':
                y[i] = 1
            elif np.asarray(y_ori)[i] == 'False':
                y[i] = 0

    elif (data_id == 23512) or (data_id == 1597) (data_id == 23517):
        y = np.zeros(y_ori.shape[0])
        for i in np.arange(y_ori.shape[0]):
            if np.asarray(y_ori)[i] == '1':
                y[i] = 1
            elif np.asarray(y_ori)[i] == '0':
                y[i] = 0

    elif (data_id == 4545) or (data_id == 574):
        X = np.array(X)[:, 1:]
        y = np.abs(y_ori)
    else:
        y = np.abs(y_ori)
    
    standardScaler = StandardScaler()
    standardScaler.fit(X)
    X = standardScaler.transform(X)
    if centered_data:
        y = y - np.mean(y)

    return X, y

def partition_each_round(X, y, rounds):
    
    print("current round：", rounds)
    rstate = np.random.randint(10, 2000)
    print("random state:", rstate)
    n0 = round(X_train.shape[0] * 0.35)
    
    X_train, X_tests_, y_train, y_tests_ = train_test_split(X, y, train_size = 0.70, random_state = rstate, shuffle = True)
    X_val, X_test, y_val, y_test = train_test_split(X_tests_, y_tests_, train_size = 0.50, random_state = rstate, shuffle = True)

    X_init, y_init = X_train[:n0, :], y_train[:n0]
    X_del, y_del = X_train[n0:2 * n0, :], y_train[n0:2 * n0]
    X_add, y_add = X_train[2 * n0:, :], y_train[2 * n0:]
    
    return X_init, y_init, X_del, y_del, X_add, y_add, X_val, y_val, X_test, y_test

