import numpy as np
from sklearn.datasets import fetch_openml
from sklearn.preprocessing import StandardScaler
from sklearn.model_selection import train_test_split

from scipy.integrate import odeint
from scipy.integrate import solve_ivp
from scipy.linalg import block_diag
from scipy.optimize import minimize

from sklearn.metrics import mean_squared_error
 
lam = 0.4
lam1 = 0.2
lam2 = 0.2

def hf(X, w): 
    # Hypothesis Function
    return 1. / (1 + np.exp(-X@w))

def sig(x):
    return 1. / (1 + np.exp(-x))

def mu(t):
    return t
    # return t**2
    # return np.sqrt(t)


def nu(s):
    return 1 - s
    # return np.sqrt(1 - s**3)
    # return np.los(10 - s**2)
    
underline_, bar_ = 0, 1
# calculate manually

eps = 1e-8 # tuning 


def nabla1_ell(X, y, beta, lam1, lam2):
    return X.T@(np.exp(X@beta) - y) + lam1 * np.sign(beta) + 2 * lam2 * beta

def nabla2_ell(X, y, beta, lam2):
    return X.T@np.diag(np.exp(X@beta))@X + 2 * lam2 * np.eye(len(beta))

def optimize(X, y, lam, method):
    beta_init = np.zeros(X.shape[1])
    result = minimize(objective, beta_init, args = (X, y, lam), method = method, tol = 1e-6)
    return result.X

