#include "MatrixMul.h"

ap_int<OW> DOT(
	ap_uint<PI*WW> weights,
	ap_uint<PI*IW> in)
{
	ap_int<OW> accumulation = 0;

	for (unsigned p = 0; p < PI; p++) {
// #pragma HLS UNROLL
		ap_int<OW> result;

		ap_int<WW> temp_w = weights( (p+1)*WW-1, p*WW );
		ap_int<IW+1> temp_in = in( (p+1)*IW-1, p*IW );
		result = temp_w*temp_in;

		accumulation += result;
	}

	return accumulation;
}
