import numpy as np 
from data import *
from algorithm import *
from oracle import *

if __name__ == '__main__':
    # set up some data to learn from
    d, pos_labels = 64, 32
    data = thresholds(d, pos_labels)

    # set up a version space 
    Z = 2 * np.vstack([np.triu(np.ones((d,d))), np.zeros(d)]) - 1

    # choose an oracle
    oracle = gaussian_width_oracle()

    # choose an algorithm
    alg = GW_version_space(data, oracle, Z, verbose=True)
    alg.run()
    print('Was algorithm correct? {}'.format(alg.check_correct()))